/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.method;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.collection.CollectionUtil;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixFactory;
import gov.sandia.cognition.statistics.distribution.StudentizedRangeDistribution;
import gov.sandia.cognition.statistics.method.AbstractMultipleHypothesisComparison;
import gov.sandia.cognition.statistics.method.ConfidenceTestAssumptions;
import gov.sandia.cognition.statistics.method.FriedmanConfidence;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;

@ConfidenceTestAssumptions(name="Nemenyi's test", description={"Nemenyi's test determines which treatment is statistically different from a multiple comparison.", "This is a nonparametric rank-based alternative to Tukey's multiple comparison test."}, assumptions={"All data came from same distribution, without considering treatment effects.", "Measurements are independent and equivalent within a treatment.", "All observations are independent."}, nullHypothesis="Each treatment has no effect on the rank-based outcome of the subjects", dataPaired=true, dataSameSize=true, distribution=StudentizedRangeDistribution.class, reference={@PublicationReference(author={"Janez Demsar"}, title="Statistical Comparisons of Classifiers over Multiple Data Sets", type=PublicationType.Journal, publication="Journal of Machine Learning Research", year=2006, url="http://www.jmlr.org/papers/volume7/demsar06a/demsar06a.pdf"), @PublicationReference(author={"Wikipedia"}, title="Multiple comparisons, Post-hoc testing of ANOVAs", type=PublicationType.WebPage, year=2011, url="http://en.wikipedia.org/wiki/Multiple_comparisons#Post-hoc_testing_of_ANOVAs")})
public class NemenyiConfidence
extends AbstractMultipleHypothesisComparison<Collection<? extends Number>, Statistic> {
    public static final NemenyiConfidence INSTANCE = new NemenyiConfidence();

    @Override
    public Statistic evaluateNullHypotheses(Collection<? extends Collection<? extends Number>> data, double uncompensatedAlpha) {
        int K = data.size();
        int N = CollectionUtil.getFirst(data).size();
        ArrayList<Double> treatmentRankMeans = FriedmanConfidence.computeTreatmentRankMeans(data);
        double standardError = Math.sqrt((double)K * ((double)K + 1.0) / (6.0 * (double)N));
        return new Statistic(uncompensatedAlpha, N, treatmentRankMeans, standardError);
    }

    public static class Statistic
    extends AbstractMultipleHypothesisComparison.Statistic {
        private int subjectCount;
        private ArrayList<Double> treatmentRankMeans;
        private double standardError;

        public Statistic(double uncompensatedAlpha, int subjectCount, ArrayList<Double> treatmentRankMeans, double standardError) {
            this.treatmentCount = treatmentRankMeans.size();
            this.uncompensatedAlpha = uncompensatedAlpha;
            this.subjectCount = subjectCount;
            this.treatmentRankMeans = treatmentRankMeans;
            this.standardError = standardError;
            this.testStatistics = this.computeTestStatistics(subjectCount, treatmentRankMeans, standardError);
            this.nullHypothesisProbabilities = this.computeNullHypothesisProbabilities(subjectCount, this.testStatistics);
        }

        public Matrix computeTestStatistics(int subjectCount, ArrayList<Double> treatmentRankMeans, double standardError) {
            int K = treatmentRankMeans.size();
            Matrix Z = MatrixFactory.getDefault().createMatrix(K, K);
            for (int i = 0; i < K; ++i) {
                double yi = treatmentRankMeans.get(i);
                for (int j = i + 1; j < K; ++j) {
                    double yj = treatmentRankMeans.get(j);
                    double zij = Math.abs(yi - yj) / standardError;
                    Z.setElement(i, j, zij);
                    Z.setElement(j, i, zij);
                }
            }
            return Z;
        }

        protected Matrix computeNullHypothesisProbabilities(int subjectCount, Matrix Z) {
            int K = Z.getNumRows();
            int N = subjectCount;
            Matrix P = MatrixFactory.getDefault().createMatrix(K, K);
            StudentizedRangeDistribution.CDF cdf = new StudentizedRangeDistribution.CDF(K, K * N - 1);
            for (int i = 0; i < K; ++i) {
                P.setElement(i, i, 1.0);
                for (int j = i + 1; j < K; ++j) {
                    double zij = Z.getElement(i, j);
                    double pij = 1.0 - cdf.evaluate(zij * Math.sqrt(2.0));
                    P.setElement(i, j, pij);
                    P.setElement(j, i, pij);
                }
            }
            return P;
        }

        @Override
        public Statistic clone() {
            Statistic clone = (Statistic)super.clone();
            clone.treatmentRankMeans = ObjectUtil.cloneSmartElementsAsArrayList(this.getTreatmentMeans());
            return clone;
        }

        public int getSubjectCount() {
            return this.subjectCount;
        }

        public double getStandardError() {
            return this.standardError;
        }

        public ArrayList<Double> getTreatmentMeans() {
            return this.treatmentRankMeans;
        }

        @Override
        public boolean acceptNullHypothesis(int i, int j) {
            return this.getNullHypothesisProbability(i, j) >= this.getUncompensatedAlpha();
        }
    }
}

