/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.method;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.ProbabilityUtil;
import gov.sandia.cognition.math.UnivariateStatisticsUtil;
import gov.sandia.cognition.statistics.distribution.StudentTDistribution;
import gov.sandia.cognition.statistics.distribution.UnivariateGaussian;
import gov.sandia.cognition.statistics.method.AbstractConfidenceStatistic;
import gov.sandia.cognition.statistics.method.ConfidenceInterval;
import gov.sandia.cognition.statistics.method.ConfidenceIntervalEvaluator;
import gov.sandia.cognition.statistics.method.ConfidenceTestAssumptions;
import gov.sandia.cognition.statistics.method.NullHypothesisEvaluator;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.Pair;
import gov.sandia.cognition.util.Summarizer;
import java.util.Collection;
import java.util.Iterator;

@ConfidenceTestAssumptions(name="Paired Student's t-test", description={"Computes the value of the null hypothesis that the differences between paired samples have zero mean and that the data are sampled from a Gaussian distributions with equal variances."}, alsoKnownAs={"Dependent t-test for paired samples"}, nullHypothesis="The means of the groups are equal.", assumptions={"The data for the pairs are iid samples from a Gaussian distribution with equal variances.", "The common variances times the degrees of freedom is a chi-square distribution.", "The data pairs should be sampled independently from each other."}, distribution=StudentTDistribution.CDF.class, dataPaired=true, dataSameSize=true, reference={@PublicationReference(author={"Wikipedia"}, title="Student's t-test, Dependent t-test for paired samples", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Student_t_test#Dependent_t-test_for_paired_samples")})
public class StudentTConfidence
extends AbstractCloneableSerializable
implements NullHypothesisEvaluator<Collection<? extends Number>>,
ConfidenceIntervalEvaluator<Collection<? extends Number>> {
    public static final StudentTConfidence INSTANCE = new StudentTConfidence();
    public static final double DEFAULT_TOLERANCE = 1.0E-10;

    @PublicationReference(author={"William H. Press", "Saul A. Teukolsky", "William T. Vetterling", "Brian P. Flannery"}, title="Numerical Recipes in C, Second Edition", type=PublicationType.Book, year=1992, pages={618}, notes={"Function tptest()"}, url="http://www.nrbook.com/a/bookcpdf.php")
    public Statistic evaluateNullHypothesis(Collection<? extends Number> data1, Collection<? extends Number> data2) {
        if (data1.size() != data2.size()) {
            throw new IllegalArgumentException("Data collections must have same number of elements");
        }
        int N = data1.size();
        Pair<Double, Double> g1 = UnivariateStatisticsUtil.computeMeanAndVariance(data1);
        Pair<Double, Double> g2 = UnivariateStatisticsUtil.computeMeanAndVariance(data2);
        double mean1 = g1.getFirst();
        double var1 = g1.getSecond();
        double mean2 = g2.getFirst();
        double var2 = g2.getSecond();
        double dof = N - 1;
        Iterator<? extends Number> i1 = data1.iterator();
        Iterator<? extends Number> i2 = data2.iterator();
        double cov = 0.0;
        for (int n = 0; n < N; ++n) {
            double v1 = i1.next().doubleValue();
            double v2 = i2.next().doubleValue();
            cov += (v1 - mean1) * (v2 - mean2);
        }
        double sd = Math.sqrt((var1 + var2 - 2.0 * (cov /= dof)) / (double)N);
        if (sd < 1.0E-10) {
            sd = 1.0E-10;
        }
        double t = Math.abs((mean1 - mean2) / sd);
        return new Statistic(t, dof);
    }

    @Override
    public ConfidenceInterval computeConfidenceInterval(Collection<? extends Number> data, double confidence) {
        UnivariateGaussian.PDF g = UnivariateGaussian.MaximumLikelihoodEstimator.learn(data, 1.0E-5);
        return this.computeConfidenceInterval(((UnivariateGaussian)g).getMean(), g.getVariance(), data.size(), confidence);
    }

    @Override
    public ConfidenceInterval computeConfidenceInterval(double mean, double variance, int numSamples, double confidence) {
        if (confidence <= 0.0 || confidence > 1.0) {
            throw new IllegalArgumentException("Confidence must be on the interval (0,1]");
        }
        int dof = numSamples - 1;
        StudentTDistribution.CDF cdf = new StudentTDistribution.CDF(dof);
        double alpha = 1.0 - confidence;
        double z = -cdf.inverse(0.5 * alpha).doubleValue();
        double delta = z * Math.sqrt(variance / (double)numSamples);
        if (delta < 0.0) {
            delta = 0.0;
        }
        return new ConfidenceInterval(mean, mean - delta, mean + delta, confidence, numSamples);
    }

    public static class Summary
    extends AbstractCloneableSerializable
    implements Summarizer<Number, ConfidenceInterval> {
        private double confidence;

        public Summary(double confidence) {
            this.setConfidence(confidence);
        }

        @Override
        public ConfidenceInterval summarize(Collection<? extends Number> data) {
            return new StudentTConfidence().computeConfidenceInterval(data, this.getConfidence());
        }

        public double getConfidence() {
            return this.confidence;
        }

        public void setConfidence(double confidence) {
            ProbabilityUtil.assertIsProbability(confidence);
            this.confidence = confidence;
        }
    }

    public static class Statistic
    extends AbstractConfidenceStatistic {
        private double t;
        private double degreesOfFreedom;

        public Statistic(double t, double degreesOfFreedom) {
            super(Statistic.twoTailTStatistic(t, degreesOfFreedom));
            this.setT(t);
            this.setDegreesOfFreedom(degreesOfFreedom);
        }

        public Statistic(Statistic other) {
            this(other.getT(), other.getDegreesOfFreedom());
        }

        @Override
        public Statistic clone() {
            return (Statistic)super.clone();
        }

        public static double twoTailTStatistic(double t, double degreesOfFreedom) {
            StudentTDistribution.CDF cdf = new StudentTDistribution.CDF(degreesOfFreedom);
            return 2.0 * cdf.evaluate(-t);
        }

        public double getT() {
            return this.t;
        }

        protected void setT(double t) {
            this.t = t;
        }

        public double getDegreesOfFreedom() {
            return this.degreesOfFreedom;
        }

        protected void setDegreesOfFreedom(double degreesOfFreedom) {
            if (degreesOfFreedom <= 0.0) {
                throw new IllegalArgumentException("degreesOfFreedom > 0.0");
            }
            this.degreesOfFreedom = degreesOfFreedom;
        }

        @Override
        public double getTestStatistic() {
            return this.getT();
        }
    }
}

