/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.method;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.statistics.distribution.UnivariateGaussian;
import gov.sandia.cognition.statistics.method.AbstractConfidenceStatistic;
import gov.sandia.cognition.statistics.method.ConfidenceTestAssumptions;
import gov.sandia.cognition.statistics.method.NullHypothesisEvaluator;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ArrayIndexSorter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

@ConfidenceTestAssumptions(name="Wilcoxon Signed-Rank Sum Test", alsoKnownAs={"Wilcoxon signed-rank test"}, description={"A nonparameteric statistical hypothesis test for the case of two related samples or repeated measurements on a single sample.", "Wilcoxon Signed-Rank Sum Test does not assume that the data are generated according to a particular distribution.", "Used as an alternative to a paired Student-t test when the data are not assumed to be Gaussian."}, assumptions={"The differences between paired samples are independent.", "Each difference comes from a continuous population, identical for all differences, and is symmetric about a common median.", "The data are oridinal variables such that comparisons such as greater than, less than, and equal to have meaning."}, nullHypothesis="The median difference between the paired samples is 0.0", dataPaired=true, dataSameSize=true, distribution=UnivariateGaussian.CDF.class, reference={@PublicationReference(author={"Wikipedia"}, title="Wilcoxon signed-rank test", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Wilcoxon_signed-rank_test")})
public class WilcoxonSignedRankConfidence
extends AbstractCloneableSerializable
implements NullHypothesisEvaluator<Collection<? extends Number>> {
    public static final WilcoxonSignedRankConfidence INSTANCE = new WilcoxonSignedRankConfidence();

    public Statistic evaluateNullHypothesis(Collection<? extends Number> data1, Collection<? extends Number> data2) {
        if (data1.size() != data2.size()) {
            throw new IllegalArgumentException("Data1 and data2 must be same size!");
        }
        int N = data1.size();
        int numNonzero = 0;
        ArrayList<Double> rawDifference = new ArrayList<Double>(N);
        ArrayList<Double> absDifference = new ArrayList<Double>(N);
        Iterator<? extends Number> i1 = data1.iterator();
        Iterator<? extends Number> i2 = data2.iterator();
        while (i1.hasNext()) {
            double difference = i1.next().doubleValue() - i2.next().doubleValue();
            if (difference == 0.0) continue;
            ++numNonzero;
            rawDifference.add(difference);
            absDifference.add(Math.abs(difference));
        }
        double[] ranks = WilcoxonSignedRankConfidence.ranks(absDifference);
        double positiveRankSum = 0.0;
        double negativeRankSum = 0.0;
        for (int i = 0; i < numNonzero; ++i) {
            if ((Double)rawDifference.get(i) > 0.0) {
                positiveRankSum += ranks[i];
                continue;
            }
            negativeRankSum += ranks[i];
        }
        double T = Math.min(positiveRankSum, negativeRankSum);
        return new Statistic(T, numNonzero);
    }

    public static double[] ranks(Collection<? extends Number> values) {
        int N = values.size();
        double[] array = new double[N];
        int index = 0;
        for (Number number : values) {
            array[index] = number.doubleValue();
            ++index;
        }
        int[] sortedIndices = ArrayIndexSorter.sortArrayAscending(array);
        double[] dArray = new double[N];
        for (int rank = 1; rank <= N; ++rank) {
            if (rank < N && array[sortedIndices[rank - 1]] == array[sortedIndices[rank]]) {
                double sum = rank + (rank + 1);
                int numEqual = 2;
                for (int j = rank + 2; j <= N && array[sortedIndices[rank - 1]] == array[sortedIndices[j - 1]]; ++j) {
                    sum += (double)j;
                    ++numEqual;
                }
                for (int i = 0; i < numEqual; ++i) {
                    dArray[sortedIndices[rank + i - 1]] = sum / (double)numEqual;
                }
                rank += numEqual - 1;
                continue;
            }
            dArray[sortedIndices[rank - 1]] = rank;
        }
        return dArray;
    }

    public static class Statistic
    extends AbstractConfidenceStatistic {
        private double T;
        private int numNonZero;
        private double z;

        public Statistic(double T, int numNonZero) {
            this(T, numNonZero, Statistic.computeZ(T, numNonZero));
        }

        private Statistic(double T, int numNonZero, double z) {
            super(Statistic.computeNullHypothesisProbability(z));
            this.setT(T);
            this.setNumNonZero(numNonZero);
            this.setZ(z);
        }

        protected static double computeZ(double T, int numNonZero) {
            double numerator = T - (double)(numNonZero * (numNonZero + 1)) / 4.0;
            double denominator = Math.sqrt((double)(numNonZero * (numNonZero + 1) * (2 * numNonZero + 1)) / 24.0);
            double z = numerator / denominator;
            return z;
        }

        protected static double computeNullHypothesisProbability(double z) {
            return 2.0 * UnivariateGaussian.CDF.evaluate(-Math.abs(z), 0.0, 1.0);
        }

        public double getT() {
            return this.T;
        }

        protected void setT(double T) {
            this.T = T;
        }

        public int getNumNonZero() {
            return this.numNonZero;
        }

        protected void setNumNonZero(int numNonZero) {
            this.numNonZero = numNonZero;
        }

        public double getZ() {
            return this.z;
        }

        protected void setZ(double z) {
            this.z = z;
        }

        @Override
        public double getTestStatistic() {
            return this.getZ();
        }
    }
}

