/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.montecarlo;

import gov.sandia.cognition.math.ProbabilityUtil;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.statistics.Distribution;
import gov.sandia.cognition.statistics.distribution.UnivariateGaussian;
import java.util.ArrayList;
import java.util.Random;

public class MultivariateCumulativeDistributionFunction {
    public static UnivariateGaussian compute(Vector input, Distribution<Vector> distribution, Random random, double probabilityTolerance) {
        ProbabilityUtil.assertIsProbability(probabilityTolerance);
        double factor = 1.0 / probabilityTolerance;
        int numSamples = (int)Math.ceil(factor * factor);
        ArrayList<Vector> samples = distribution.sample(random, numSamples);
        int numNotLess = 0;
        int N = input.getDimensionality();
        block0: for (Vector sample : samples) {
            input.assertSameDimensionality(sample);
            for (int i = 0; i < N; ++i) {
                double y;
                double x = input.getElement(i);
                if (!(x > (y = sample.getElement(i)))) continue;
                ++numNotLess;
                continue block0;
            }
        }
        double p = 1.0 - (double)numNotLess / (double)numSamples;
        double pVariance = p * (1.0 - p) / (double)numSamples;
        return new UnivariateGaussian(p, pVariance);
    }
}

