/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.util;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviews;
import gov.sandia.cognition.util.AbstractNamed;
import gov.sandia.cognition.util.Named;
import gov.sandia.cognition.util.NamedValue;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;

@CodeReviews(reviews={@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-10-02", changesNeeded=false, comments={"Moved previous code review to CodeReview annotation.", "Otherwise, looks fine."}), @CodeReview(reviewer={"Kevin R. Dixon"}, date="2007-11-25", changesNeeded=false, comments={"Looks fine."})})
public class DefaultNamedValue<ValueType>
extends AbstractNamed
implements NamedValue<ValueType> {
    protected ValueType value;

    public DefaultNamedValue() {
        this(null, null);
    }

    public DefaultNamedValue(String name, ValueType value) {
        super(name);
        this.setValue(value);
    }

    public DefaultNamedValue(DefaultNamedValue<? extends ValueType> other) {
        this(other.getName(), other.getValue());
    }

    @Override
    public DefaultNamedValue<ValueType> clone() {
        DefaultNamedValue clone = (DefaultNamedValue)super.clone();
        clone.setValue(ObjectUtil.cloneSmart(this.getValue()));
        return clone;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    @Override
    public ValueType getValue() {
        return this.value;
    }

    public void setValue(ValueType value) {
        this.value = value;
    }

    public static <T> DefaultNamedValue<T> create(String name, T value) {
        return new DefaultNamedValue<T>(name, value);
    }

    public static <T extends Named> ArrayList<DefaultNamedValue<T>> createNamedValuesList(Collection<T> values) {
        ArrayList<DefaultNamedValue<T>> result = new ArrayList<DefaultNamedValue<T>>(values.size());
        for (Named value : values) {
            result.add(new DefaultNamedValue<Named>(value.getName(), value));
        }
        return result;
    }
}

