/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.util;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviews;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;
import gov.sandia.cognition.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

@CodeReviews(reviews={@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-10-02", changesNeeded=false, comments={"Moved previous code reviews to CodeReview annotations.", "Otherwise, still looks fine."}), @CodeReview(reviewer={"Kevin R. Dixon"}, date="2007-11-25", changesNeeded=false, comments={"Still looks fine."}), @CodeReview(reviewer={"Kevin R. Dixon"}, date="2006-07-18", changesNeeded=false, comments={"Looks fine."})})
public class DefaultPair<FirstType, SecondType>
extends AbstractCloneableSerializable
implements Pair<FirstType, SecondType> {
    protected FirstType first;
    protected SecondType second;

    public DefaultPair() {
        this(null, null);
    }

    public DefaultPair(FirstType first, SecondType second) {
        this.first = first;
        this.second = second;
    }

    public DefaultPair(Pair<? extends FirstType, ? extends SecondType> other) {
        this.setFirst(other.getFirst());
        this.setSecond(other.getSecond());
    }

    @Override
    public DefaultPair<FirstType, SecondType> clone() {
        DefaultPair result = (DefaultPair)super.clone();
        result.first = ObjectUtil.cloneSmart(result.first);
        result.second = ObjectUtil.cloneSmart(result.second);
        return result;
    }

    public boolean equals(Object other) {
        return other instanceof Pair && this.equals((Pair)other);
    }

    public boolean equals(Pair<FirstType, SecondType> other) {
        return other != null && ObjectUtil.equalsSafe(this.getFirst(), other.getFirst()) && ObjectUtil.equalsSafe(this.getSecond(), other.getSecond());
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + ObjectUtil.hashCodeSafe(this.getFirst());
        hash = 23 * hash + ObjectUtil.hashCodeSafe(this.getSecond());
        return hash;
    }

    public static <FirstType, SecondType> DefaultPair<FirstType, SecondType> create() {
        return new DefaultPair<FirstType, SecondType>();
    }

    public static <FirstType, SecondType> DefaultPair<FirstType, SecondType> create(FirstType first, SecondType second) {
        return new DefaultPair<FirstType, SecondType>(first, second);
    }

    @Override
    public FirstType getFirst() {
        return this.first;
    }

    @Override
    public SecondType getSecond() {
        return this.second;
    }

    public void setFirst(FirstType first) {
        this.first = first;
    }

    public void setSecond(SecondType second) {
        this.second = second;
    }

    public static <FirstType, SecondType> ArrayList<DefaultPair<FirstType, SecondType>> mergeCollections(Collection<FirstType> firsts, Collection<SecondType> seconds) {
        int count = firsts.size();
        if (count != seconds.size()) {
            throw new IllegalArgumentException("Collections are not the same size.");
        }
        ArrayList<DefaultPair<FirstType, SecondType>> result = new ArrayList<DefaultPair<FirstType, SecondType>>(count);
        Iterator<SecondType> i2 = seconds.iterator();
        for (FirstType d1 : firsts) {
            result.add(new DefaultPair<FirstType, SecondType>(d1, i2.next()));
        }
        return result;
    }
}

