/*
 * Decompiled with CFR 0.152.
 */
package jal.strings;

import jal.strings.BinaryOperator;

public final class Numeric {
    public static String accumulate(String[] array, int first, int last, String init, BinaryOperator op) {
        String acc = init;
        while (first < last) {
            acc = op.apply(acc, array[first++]);
        }
        return acc;
    }

    public static String inner_product(String[] array1, String[] array2, int first1, int last1, int first2, String init, BinaryOperator op1, BinaryOperator op2) {
        String acc = init;
        while (first1 < last1) {
            acc = op1.apply(acc, op2.apply(array1[first1++], array2[first2++]));
        }
        return acc;
    }

    public static int partial_sum(String[] source, String[] dest, int first, int last, int to, BinaryOperator op) {
        if (first < last) {
            dest[to] = source[first];
            String value = dest[to];
            while (++first < last) {
                value = op.apply(value, source[first]);
                dest[++to] = value;
            }
            return to + 1;
        }
        return to;
    }

    public static int adjacent_difference(String[] source, String[] dest, int first, int last, int to, BinaryOperator op) {
        if (first < last) {
            dest[to] = source[first];
            String prev_value = source[first];
            while (++first < last) {
                String cur_value = source[first];
                dest[++to] = op.apply(cur_value, prev_value);
                prev_value = cur_value;
            }
            return to + 1;
        }
        return to;
    }

    private Numeric() {
    }
}

