/*
 * Decompiled with CFR 0.152.
 */
package jal.strings;

import jal.strings.BinaryPredicate;
import jal.strings.Modification;
import jal.strings.Range;

public final class Sorting {
    private static final int partitionCutoff = 13;
    private static final int qsort_stacksize = 56;
    private static final int stableSortCutoff = 9;

    public static void sort(String[] array, int first, int last, BinaryPredicate comp) {
        if (last - first >= 13) {
            Sorting.qsortLoop(array, first, last, comp);
        }
        Sorting.insertion_sort(array, first, last, comp);
    }

    public static void insertion_sort(String[] array, int first, int last, BinaryPredicate comp) {
        int current = first;
        while (++current < last) {
            String tmp = array[current];
            int i = current;
            String tmp1 = array[i - 1];
            while (comp.apply(tmp, tmp1)) {
                array[i] = tmp1;
                if (first == i - 1) {
                    --i;
                    break;
                }
                tmp1 = array[--i - 1];
            }
            array[i] = tmp;
        }
    }

    private static int quickPartition(String[] array, int first, int last, BinaryPredicate comp) {
        String f = array[first];
        String l = array[last - 1];
        String pivot = array[first + (last - first) / 2];
        if (comp.apply(pivot, f)) {
            if (comp.apply(f, l)) {
                pivot = f;
            } else if (comp.apply(pivot, l)) {
                pivot = l;
            }
        } else if (comp.apply(l, f)) {
            pivot = f;
        } else if (comp.apply(l, pivot)) {
            pivot = l;
        }
        --first;
        while (true) {
            if (comp.apply(array[++first], pivot)) {
                continue;
            }
            while (comp.apply(pivot, array[--last])) {
            }
            if (first >= last) {
                return first;
            }
            String tmp = array[first];
            array[first] = array[last];
            array[last] = tmp;
        }
    }

    private static void qsortLoop(String[] array, int first, int last, BinaryPredicate comp) {
        int[] stack = new int[56];
        int position = 0;
        while (true) {
            int cut;
            if (last - (cut = Sorting.quickPartition(array, first, last, comp)) < 13) {
                if (cut - first < 13) {
                    if (position == 0) {
                        return;
                    }
                    last = stack[--position];
                    first = stack[--position];
                    continue;
                }
                last = cut;
                continue;
            }
            if (cut - first < 13) {
                first = cut;
                continue;
            }
            if (last - cut > cut - first) {
                stack[position++] = cut;
                stack[position++] = last;
                last = cut;
                continue;
            }
            stack[position++] = first;
            stack[position++] = cut;
            first = cut;
        }
    }

    public static void stable_sort(String[] array, int first, int last, BinaryPredicate comp) {
        if (last - first < 9) {
            Sorting.insertion_sort(array, first, last, comp);
        } else {
            int middle = first + (last - first) / 2;
            Sorting.stable_sort(array, first, middle, comp);
            Sorting.stable_sort(array, middle, last, comp);
            Sorting.inplace_merge(array, first, middle, last, comp);
        }
    }

    public static void partial_sort(String[] array, int first, int middle, int last, BinaryPredicate comp) {
        Sorting.make_heap(array, first, middle, comp);
        for (int current = middle; current < last; ++current) {
            if (!comp.apply(array[current], array[first])) continue;
            String tmp = array[current];
            array[current] = array[first];
            array[first] = tmp;
            Sorting.adjust_heap(array, first, first, middle, comp);
        }
        Sorting.sort_heap(array, first, middle, comp);
    }

    public static int partial_sort_copy(String[] source, String[] destination, int first, int last, int result_first, int result_last, BinaryPredicate comp) {
        if (result_first == result_last) {
            return result_last;
        }
        int len = Math.min(last - first, result_last - result_first);
        Modification.copy(source, destination, first, first + len, result_first);
        result_last = result_first + len;
        Sorting.make_heap(destination, result_first, result_last, comp);
        first += len;
        while (first < last) {
            if (comp.apply(source[first], destination[result_first])) {
                destination[result_first] = source[first];
                Sorting.adjust_heap(destination, result_first, result_first, result_last, comp);
            }
            ++first;
        }
        Sorting.sort_heap(destination, result_first, result_last, comp);
        return result_last;
    }

    public static void nth_element(String[] array, int first, int nth, int last, BinaryPredicate comp) {
        while (last - first > 3) {
            int cut = Sorting.quickPartition(array, first, last, comp);
            if (cut <= nth) {
                first = cut;
                continue;
            }
            last = cut;
        }
        Sorting.insertion_sort(array, first, last, comp);
    }

    public static int lower_bound(String[] array, int first, int last, String x, BinaryPredicate comp) {
        int len = last - first;
        while (len > 0) {
            int half = len / 2;
            int middle = first + half;
            if (comp.apply(array[middle], x)) {
                first = middle + 1;
                len -= half + 1;
                continue;
            }
            len = half;
        }
        return first;
    }

    public static int upper_bound(String[] array, int first, int last, String x, BinaryPredicate comp) {
        int len = last - first;
        while (len > 0) {
            int half = len / 2;
            int middle = first + half;
            if (comp.apply(x, array[middle])) {
                len = half;
                continue;
            }
            first = middle + 1;
            len -= half + 1;
        }
        return first;
    }

    public static Range equal_range(String[] array, int first, int last, String x, BinaryPredicate comp) {
        int len = last - first;
        while (len > 0) {
            int half = len / 2;
            int middle = first + half;
            if (comp.apply(array[middle], x)) {
                first = middle + 1;
                len = len - half + 1;
                continue;
            }
            if (comp.apply(x, array[middle])) {
                len = half;
                continue;
            }
            int left = Sorting.lower_bound(array, first, middle, x, comp);
            int right = Sorting.upper_bound(array, middle + 1, first + len, x, comp);
            return new Range(array, left, right);
        }
        return new Range(array, first, first);
    }

    public static boolean binary_search(String[] array, int first, int last, String x, BinaryPredicate comp) {
        int i = Sorting.lower_bound(array, first, last, x, comp);
        return i < last && !comp.apply(x, array[i]);
    }

    public static int merge(String[] source1, String[] source2, String[] dest, int first1, int last1, int first2, int last2, int to, BinaryPredicate comp) {
        while (first1 < last1 && first2 < last2) {
            if (comp.apply(source2[first2], source1[first1])) {
                dest[to++] = source2[first2++];
                continue;
            }
            dest[to++] = source1[first1++];
        }
        Modification.copy(source1, dest, first1, last1, to);
        Modification.copy(source2, dest, first2, last2, to);
        return to + (last1 - first1) + (last2 - first2);
    }

    public static void inplace_merge(String[] array, int first, int middle, int last, BinaryPredicate comp) {
        int secondCut;
        int firstCut;
        if (first >= middle || middle >= last) {
            return;
        }
        if (last - first == 2) {
            if (comp.apply(array[middle], array[first])) {
                String tmp = array[first];
                array[first] = array[middle];
                array[middle] = tmp;
            }
            return;
        }
        if (middle - first > last - middle) {
            firstCut = first + (middle - first) / 2;
            secondCut = Sorting.lower_bound(array, middle, last, array[firstCut], comp);
        } else {
            secondCut = middle + (last - middle) / 2;
            firstCut = Sorting.upper_bound(array, first, middle, array[secondCut], comp);
        }
        Modification.rotate(array, firstCut, middle, secondCut);
        middle = firstCut + (secondCut - middle);
        Sorting.inplace_merge(array, first, firstCut, middle, comp);
        Sorting.inplace_merge(array, middle, secondCut, last, comp);
    }

    public static boolean includes(String[] array1, String[] array2, int first1, int last1, int first2, int last2, BinaryPredicate comp) {
        while (first1 < last1 && first2 < last2) {
            if (comp.apply(array2[first2], array1[first1])) {
                return false;
            }
            if (comp.apply(array1[first1], array2[first2])) {
                ++first1;
                continue;
            }
            ++first1;
            ++first2;
        }
        return first2 == last2;
    }

    public static int set_union(String[] source1, String[] source2, String[] destination, int first1, int last1, int first2, int last2, int to, BinaryPredicate comp) {
        while (first1 < last1 && first2 < last2) {
            if (comp.apply(source1[first1], source2[first2])) {
                destination[to++] = source1[first1++];
                continue;
            }
            if (comp.apply(source2[first2], source1[first1])) {
                destination[to++] = source2[first2++];
                continue;
            }
            destination[to++] = source1[first1++];
            ++first2;
        }
        Modification.copy(source1, destination, first1, last1, to);
        Modification.copy(source2, destination, first2, last2, to);
        return to + (last1 - first1) + (last2 - first2);
    }

    public static int set_intersection(String[] source1, String[] source2, String[] destination, int first1, int last1, int first2, int last2, int to, BinaryPredicate comp) {
        while (first1 < last1 && first2 < last2) {
            if (comp.apply(source1[first1], source2[first2])) {
                ++first1;
                continue;
            }
            if (comp.apply(source2[first2], source1[first1])) {
                ++first2;
                continue;
            }
            destination[to++] = source1[first1++];
            ++first2;
        }
        return to;
    }

    public static int set_difference(String[] source1, String[] source2, String[] destination, int first1, int last1, int first2, int last2, int to, BinaryPredicate comp) {
        while (first1 < last1 && first2 < last2) {
            if (comp.apply(source1[first1], source2[first2])) {
                destination[to++] = source1[first1++];
                continue;
            }
            if (comp.apply(source2[first2], source1[first1])) {
                ++first2;
                continue;
            }
            ++first1;
            ++first2;
        }
        Modification.copy(source1, destination, first1, last1, to);
        return to + (last1 - first1);
    }

    public static int set_symmetric_difference(String[] source1, String[] source2, String[] destination, int first1, int last1, int first2, int last2, int to, BinaryPredicate comp) {
        while (first1 < last1 && first2 < last2) {
            if (comp.apply(source1[first1], source2[first2])) {
                destination[to++] = source1[first1++];
                continue;
            }
            if (comp.apply(source2[first2], source1[first1])) {
                destination[to++] = source2[first2++];
                continue;
            }
            ++first1;
            ++first2;
        }
        Modification.copy(source1, destination, first1, last1, to);
        Modification.copy(source2, destination, first2, last2, to);
        return to + (last1 - first1) + (last2 - first2);
    }

    public static void push_heap(String[] array, int first, int last, BinaryPredicate comp) {
        if (last - first < 2) {
            return;
        }
        String tmp = array[--last];
        int parent = first + (last - first - 1) / 2;
        while (last > first && comp.apply(array[parent], tmp)) {
            array[last] = array[parent];
            last = parent;
            parent = first + (last - first - 1) / 2;
        }
        array[last] = tmp;
    }

    private static void adjust_heap(String[] array, int first, int position, int last, BinaryPredicate comp) {
        int secondChild;
        String tmp = array[position];
        int len = last - first;
        int holeIndex = position - first;
        for (secondChild = 2 * holeIndex + 2; secondChild < len; secondChild *= 2) {
            if (comp.apply(array[first + secondChild], array[first + (secondChild - 1)])) {
                --secondChild;
            }
            array[first + holeIndex] = array[first + secondChild];
            holeIndex = secondChild++;
        }
        if (secondChild-- == len) {
            array[first + holeIndex] = array[first + secondChild];
            holeIndex = secondChild;
        }
        int parent = (holeIndex - 1) / 2;
        int topIndex = position - first;
        while (holeIndex != topIndex && comp.apply(array[first + parent], tmp)) {
            array[first + holeIndex] = array[first + parent];
            holeIndex = parent;
            parent = (holeIndex - 1) / 2;
        }
        array[first + holeIndex] = tmp;
    }

    public static void pop_heap(String[] array, int first, int last, BinaryPredicate comp) {
        if (last - first < 2) {
            return;
        }
        String tmp = array[--last];
        array[last] = array[first];
        array[first] = tmp;
        Sorting.adjust_heap(array, first, first, last, comp);
    }

    public static void make_heap(String[] array, int first, int last, BinaryPredicate comp) {
        if (last - first < 2) {
            return;
        }
        int parent = (last - first - 2) / 2;
        do {
            Sorting.adjust_heap(array, first, first + parent, last, comp);
        } while (parent-- != 0);
    }

    public static void sort_heap(String[] array, int first, int last, BinaryPredicate comp) {
        while (last - first > 1) {
            String tmp = array[--last];
            array[last] = array[first];
            array[first] = tmp;
            Sorting.adjust_heap(array, first, first, last, comp);
        }
    }

    public static int max_element(String[] array, int first, int last, BinaryPredicate comp) {
        if (first >= last) {
            return last;
        }
        int result = first;
        while (++first < last) {
            if (!comp.apply(array[result], array[first])) continue;
            result = first;
        }
        return result;
    }

    public static int min_element(String[] array, int first, int last, BinaryPredicate comp) {
        if (first >= last) {
            return last;
        }
        int result = first;
        while (++first < last) {
            if (!comp.apply(array[first], array[result])) continue;
            result = first;
        }
        return result;
    }

    public static boolean lexicographical_compare(String[] array1, String[] array2, int first1, int last1, int first2, int last2, BinaryPredicate comp) {
        while (first1 < last1 && first2 < last2) {
            if (comp.apply(array1[first1], array2[first2])) {
                return true;
            }
            if (!comp.apply(array2[first2++], array1[first1++])) continue;
            return false;
        }
        return first1 == last1 && first2 != last2;
    }

    public static boolean next_permutation(String[] array, int first, int last, BinaryPredicate comp) {
        if (last - first < 2) {
            return false;
        }
        int i = last - 1;
        do {
            int ii;
            if (!comp.apply(array[--i], array[ii])) continue;
            int j = last;
            while (!comp.apply(array[i], array[--j])) {
            }
            String tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
            Modification.reverse(array, ii, last);
            return true;
        } while (i != first);
        Modification.reverse(array, first, last);
        return false;
    }

    public static boolean prev_permutation(String[] array, int first, int last, BinaryPredicate comp) {
        if (last - first < 2) {
            return false;
        }
        int i = last - 1;
        do {
            int ii;
            if (!comp.apply(array[ii], array[--i])) continue;
            int j = last;
            while (!comp.apply(array[--j], array[i])) {
            }
            String tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
            Modification.reverse(array, ii, last);
            return true;
        } while (i != first);
        Modification.reverse(array, first, last);
        return false;
    }

    private Sorting() {
    }
}

