/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import com.github.fommil.netlib.LAPACK;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.JobSVD;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.NotConvergedException;
import org.netlib.util.intW;

public class EconomySVD {
    private final double[] work;
    private final int[] iwork;
    private final int m;
    private final int n;
    private final double[] S;
    private final DenseMatrix U;
    private final DenseMatrix Vt;

    public EconomySVD(int m, int n) {
        this.m = m;
        this.n = n;
        this.S = new double[Math.min(m, n)];
        this.U = new DenseMatrix(Matrices.ld(m), Math.min(m, n));
        this.Vt = new DenseMatrix(Matrices.ld(Math.min(m, n)), n);
        this.iwork = new int[8 * Math.min(m, n)];
        double[] worksize = new double[1];
        intW info = new intW(0);
        LAPACK.getInstance().dgesdd(JobSVD.Part.netlib(), m, n, new double[0], Matrices.ld(m), new double[0], new double[0], this.U.numRows, new double[0], this.Vt.numRows, worksize, -1, this.iwork, info);
        int lwork = -1;
        lwork = info.val != 0 ? Math.min(m, n) * (6 + 4 * Math.min(m, n)) + Math.max(m, n) : (int)worksize[0];
        lwork = Math.max(lwork, 1);
        this.work = new double[lwork];
    }

    public static EconomySVD factorize(Matrix A) throws NotConvergedException {
        return new EconomySVD(A.numRows(), A.numColumns()).factor(new DenseMatrix(A));
    }

    public EconomySVD factor(DenseMatrix A) throws NotConvergedException {
        if (A.numRows() != this.m) {
            throw new IllegalArgumentException("A.numRows() != m");
        }
        if (A.numColumns() != this.n) {
            throw new IllegalArgumentException("A.numColumns() != n");
        }
        intW info = new intW(0);
        LAPACK.getInstance().dgesdd(JobSVD.Part.netlib(), this.m, this.n, A.getData(), A.numRows, this.S, this.U.getData(), this.U.numRows, this.Vt.getData(), this.Vt.numRows, this.work, this.work.length, this.iwork, info);
        if (info.val > 0) {
            throw new NotConvergedException(NotConvergedException.Reason.Iterations);
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return this;
    }

    public DenseMatrix getU() {
        return this.U;
    }

    public DenseMatrix getVt() {
        return this.Vt;
    }

    public double[] getS() {
        return this.S;
    }
}

