/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import com.github.fommil.netlib.LAPACK;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.OrthogonalComputer;
import no.uib.cipr.matrix.UpperTriangDenseMatrix;
import org.netlib.util.intW;

public class QR
extends OrthogonalComputer {
    public QR(int m, int n) {
        super(m, n, true);
        if (n > m) {
            throw new IllegalArgumentException("n > m");
        }
        this.work = new double[1];
        intW info = new intW(0);
        LAPACK.getInstance().dgeqrf(m, n, new double[0], Matrices.ld(m), new double[0], this.work, -1, info);
        int lwork = info.val != 0 ? n : (int)this.work[0];
        lwork = Math.max(1, lwork);
        this.work = new double[lwork];
        this.workGen = new double[1];
        info = new intW(0);
        LAPACK.getInstance().dorgqr(m, n, this.k, new double[0], Matrices.ld(m), new double[0], this.workGen, -1, info);
        lwork = info.val != 0 ? n : (int)this.workGen[0];
        lwork = Math.max(1, lwork);
        this.workGen = new double[lwork];
    }

    public static QR factorize(Matrix A) {
        return new QR(A.numRows(), A.numColumns()).factor(new DenseMatrix(A));
    }

    @Override
    public QR factor(DenseMatrix A) {
        if (this.Q.numRows() != A.numRows()) {
            throw new IllegalArgumentException("Q.numRows() != A.numRows()");
        }
        if (this.Q.numColumns() != A.numColumns()) {
            throw new IllegalArgumentException("Q.numColumns() != A.numColumns()");
        }
        if (this.R == null) {
            throw new IllegalArgumentException("R == null");
        }
        intW info = new intW(0);
        LAPACK.getInstance().dgeqrf(this.m, this.n, A.getData(), Matrices.ld(this.m), this.tau, this.work, this.work.length, info);
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        this.R.zero();
        for (MatrixEntry e : A) {
            if (e.row() > e.column()) continue;
            this.R.set(e.row(), e.column(), e.get());
        }
        info.val = 0;
        LAPACK.getInstance().dorgqr(this.m, this.n, this.k, A.getData(), Matrices.ld(this.m), this.tau, this.workGen, this.workGen.length, info);
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        this.Q.set(A);
        return this;
    }

    public UpperTriangDenseMatrix getR() {
        return this.R;
    }
}

