/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileNotFolderException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.ftp.FtpClient;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystem;
import org.apache.commons.vfs2.provider.ftp.FtpRandomAccessContent;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.apache.commons.vfs2.util.Messages;
import org.apache.commons.vfs2.util.MonitorInputStream;
import org.apache.commons.vfs2.util.MonitorOutputStream;
import org.apache.commons.vfs2.util.RandomAccessMode;

public class FtpFileObject
extends AbstractFileObject {
    private static final Map<String, FTPFile> EMPTY_FTP_FILE_MAP = Collections.unmodifiableMap(new TreeMap());
    private static final FTPFile UNKNOWN = new FTPFile();
    private final Log log = LogFactory.getLog(FtpFileObject.class);
    private final FtpFileSystem ftpFs;
    private final String relPath;
    private FTPFile fileInfo;
    private Map<String, FTPFile> children;
    private FileObject linkDestination;
    private boolean inRefresh;

    protected FtpFileObject(AbstractFileName name, FtpFileSystem fileSystem, FileName rootName) throws FileSystemException {
        super(name, fileSystem);
        this.ftpFs = fileSystem;
        String relPath = UriParser.decode(rootName.getRelativeName(name));
        this.relPath = ".".equals(relPath) ? null : relPath;
    }

    private FTPFile getChildFile(String name, boolean flush) throws IOException {
        if (flush && !this.inRefresh) {
            this.children = null;
        }
        this.doGetChildren();
        if (this.children == null) {
            return null;
        }
        FTPFile ftpFile = this.children.get(name);
        return ftpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGetChildren() throws IOException {
        if (this.children != null) {
            return;
        }
        FtpClient client = this.ftpFs.getClient();
        try {
            String path = this.fileInfo != null && this.fileInfo.isSymbolicLink() ? this.getFileSystem().getFileSystemManager().resolveName(this.getParent().getName(), this.fileInfo.getLink()).getPath() : this.relPath;
            FTPFile[] tmpChildren = client.listFiles(path);
            if (tmpChildren == null || tmpChildren.length == 0) {
                this.children = EMPTY_FTP_FILE_MAP;
            } else {
                this.children = new TreeMap<String, FTPFile>();
                for (int i = 0; i < tmpChildren.length; ++i) {
                    FTPFile child = tmpChildren[i];
                    if (child == null) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug(Messages.getString("vfs.provider.ftp/invalid-directory-entry.debug", new Object[]{new Integer(i), this.relPath}));
                        continue;
                    }
                    if (".".equals(child.getName()) || "..".equals(child.getName())) continue;
                    this.children.put(child.getName(), child);
                }
            }
        }
        finally {
            this.ftpFs.putClient(client);
        }
    }

    protected void doAttach() throws IOException {
    }

    private void getInfo(boolean flush) throws IOException {
        FTPFile newFileInfo;
        FtpFileObject parent = (FtpFileObject)FileObjectUtils.getAbstractFileObject(this.getParent());
        if (parent != null) {
            newFileInfo = parent.getChildFile(UriParser.decode(this.getName().getBaseName()), flush);
        } else {
            newFileInfo = new FTPFile();
            newFileInfo.setType(1);
        }
        this.fileInfo = newFileInfo == null ? UNKNOWN : newFileInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws FileSystemException {
        if (!this.inRefresh) {
            try {
                this.inRefresh = true;
                super.refresh();
                FileSystem fileSystem = this.getFileSystem();
                synchronized (fileSystem) {
                    this.fileInfo = null;
                }
            }
            finally {
                this.inRefresh = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDetach() {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            this.fileInfo = null;
            this.children = null;
        }
    }

    protected void onChildrenChanged(FileName child, FileType newType) {
        if (this.children != null && newType.equals((Object)FileType.IMAGINARY)) {
            try {
                this.children.remove(UriParser.decode(child.getBaseName()));
            }
            catch (FileSystemException e) {
                throw new RuntimeException(e.getMessage());
            }
        } else {
            this.children = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onChange() throws IOException {
        this.children = null;
        if (this.getType().equals((Object)FileType.IMAGINARY)) {
            FileSystem fileSystem = this.getFileSystem();
            synchronized (fileSystem) {
                this.fileInfo = UNKNOWN;
            }
            return;
        }
        this.getInfo(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileType doGetType() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.fileInfo == null) {
                this.getInfo(false);
            }
            if (this.fileInfo == UNKNOWN) {
                return FileType.IMAGINARY;
            }
            if (this.fileInfo.isDirectory()) {
                return FileType.FOLDER;
            }
            if (this.fileInfo.isFile()) {
                return FileType.FILE;
            }
            if (this.fileInfo.isSymbolicLink()) {
                return this.getLinkDestination().getType();
            }
        }
        throw new FileSystemException("vfs.provider.ftp/get-type.error", this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject getLinkDestination() throws FileSystemException {
        if (this.linkDestination == null) {
            String path;
            FileSystem fileSystem = this.getFileSystem();
            synchronized (fileSystem) {
                path = this.fileInfo.getLink();
            }
            FileName relativeTo = this.getName().getParent();
            if (relativeTo == null) {
                relativeTo = this.getName();
            }
            FileName linkDestinationName = this.getFileSystem().getFileSystemManager().resolveName(relativeTo, path);
            this.linkDestination = this.getFileSystem().resolveFile(linkDestinationName);
        }
        return this.linkDestination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject[] doListChildrenResolved() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.fileInfo != null && this.fileInfo.isSymbolicLink()) {
                return this.getLinkDestination().getChildren();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject[] getChildren() throws FileSystemException {
        try {
            if (this.doGetType() != FileType.FOLDER) {
                throw new FileNotFolderException(this.getName());
            }
        }
        catch (Exception ex) {
            throw new FileNotFolderException(this.getName(), (Throwable)ex);
        }
        try {
            this.inRefresh = true;
            FileObject[] fileObjectArray = super.getChildren();
            return fileObjectArray;
        }
        finally {
            this.inRefresh = false;
        }
    }

    protected String[] doListChildren() throws Exception {
        this.doGetChildren();
        if (this.children == null) {
            return null;
        }
        String[] childNames = new String[this.children.size()];
        int childNum = -1;
        for (FTPFile child : this.children.values()) {
            childNames[++childNum] = child.getName();
        }
        return UriParser.encode(childNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            boolean ok;
            FtpClient ftpClient = this.ftpFs.getClient();
            try {
                ok = this.fileInfo.isDirectory() ? ftpClient.removeDirectory(this.relPath) : ftpClient.deleteFile(this.relPath);
            }
            finally {
                this.ftpFs.putClient(ftpClient);
            }
            if (!ok) {
                throw new FileSystemException("vfs.provider.ftp/delete-file.error", this.getName());
            }
            this.fileInfo = null;
            this.children = EMPTY_FTP_FILE_MAP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRename(FileObject newfile) throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            boolean ok;
            FtpClient ftpClient = this.ftpFs.getClient();
            try {
                String oldName = this.getName().getPath();
                String newName = newfile.getName().getPath();
                ok = ftpClient.rename(oldName, newName);
            }
            finally {
                this.ftpFs.putClient(ftpClient);
            }
            if (!ok) {
                throw new FileSystemException("vfs.provider.ftp/rename-file.error", new Object[]{this.getName().toString(), newfile});
            }
            this.fileInfo = null;
            this.children = EMPTY_FTP_FILE_MAP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCreateFolder() throws Exception {
        boolean ok;
        FtpClient client = this.ftpFs.getClient();
        try {
            ok = client.makeDirectory(this.relPath);
        }
        finally {
            this.ftpFs.putClient(client);
        }
        if (!ok) {
            throw new FileSystemException("vfs.provider.ftp/create-folder.error", this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long doGetContentSize() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.fileInfo.isSymbolicLink()) {
                return this.getLinkDestination().getContent().getSize();
            }
            return this.fileInfo.getSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long doGetLastModifiedTime() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.fileInfo.isSymbolicLink()) {
                return this.getLinkDestination().getContent().getLastModifiedTime();
            }
            Calendar timestamp = this.fileInfo.getTimestamp();
            if (timestamp == null) {
                return 0L;
            }
            return timestamp.getTime().getTime();
        }
    }

    protected InputStream doGetInputStream() throws Exception {
        FtpClient client = this.ftpFs.getClient();
        try {
            InputStream instr = client.retrieveFileStream(this.relPath);
            if (instr == null) {
                throw new FileNotFoundException(this.getName().toString());
            }
            return new FtpInputStream(client, instr);
        }
        catch (Exception e) {
            this.ftpFs.putClient(client);
            throw e;
        }
    }

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new FtpRandomAccessContent(this, mode);
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        FtpClient client = this.ftpFs.getClient();
        try {
            OutputStream out = null;
            out = bAppend ? client.appendFileStream(this.relPath) : client.storeFileStream(this.relPath);
            if (out == null) {
                throw new FileSystemException("vfs.provider.ftp/output-error.debug", new Object[]{this.getName(), client.getReplyString()});
            }
            return new FtpOutputStream(client, out);
        }
        catch (Exception e) {
            this.ftpFs.putClient(client);
            throw e;
        }
    }

    String getRelPath() {
        return this.relPath;
    }

    FtpInputStream getInputStream(long filePointer) throws IOException {
        FtpClient client = this.ftpFs.getClient();
        try {
            InputStream instr = client.retrieveFileStream(this.relPath, filePointer);
            if (instr == null) {
                throw new FileSystemException("vfs.provider.ftp/input-error.debug", new Object[]{this.getName(), client.getReplyString()});
            }
            return new FtpInputStream(client, instr);
        }
        catch (IOException e) {
            this.ftpFs.putClient(client);
            throw e;
        }
    }

    private class FtpOutputStream
    extends MonitorOutputStream {
        private final FtpClient client;

        public FtpOutputStream(FtpClient client, OutputStream outstr) {
            super(outstr);
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onClose() throws IOException {
            boolean ok;
            try {
                ok = this.client.completePendingCommand();
            }
            finally {
                FtpFileObject.this.ftpFs.putClient(this.client);
            }
            if (!ok) {
                throw new FileSystemException("vfs.provider.ftp/finish-put.error", FtpFileObject.this.getName());
            }
        }
    }

    class FtpInputStream
    extends MonitorInputStream {
        private final FtpClient client;

        public FtpInputStream(FtpClient client, InputStream in) {
            super(in);
            this.client = client;
        }

        void abort() throws IOException {
            this.client.abort();
            this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onClose() throws IOException {
            boolean ok;
            try {
                ok = this.client.completePendingCommand();
            }
            finally {
                FtpFileObject.this.ftpFs.putClient(this.client);
            }
            if (!ok) {
                throw new FileSystemException("vfs.provider.ftp/finish-get.error", FtpFileObject.this.getName());
            }
        }
    }
}

