/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.png.chunks;

import java.io.ByteArrayInputStream;
import org.apache.sanselan.common.BinaryFileParser;

public class PNGChunk
extends BinaryFileParser {
    public final int length;
    public final int chunkType;
    public final int crc;
    public final byte[] bytes;
    public final boolean[] propertyBits;
    public final boolean ancillary;
    public final boolean isPrivate;
    public final boolean reserved;
    public final boolean safeToCopy;

    public PNGChunk(int Length2, int ChunkType, int CRC2, byte[] bytes) {
        this.length = Length2;
        this.chunkType = ChunkType;
        this.crc = CRC2;
        this.bytes = bytes;
        this.propertyBits = new boolean[4];
        int shift = 24;
        for (int i = 0; i < 4; ++i) {
            int theByte = 0xFF & ChunkType >> shift;
            shift -= 8;
            int theMask = 32;
            this.propertyBits[i] = (theByte & theMask) > 0;
        }
        this.ancillary = this.propertyBits[0];
        this.isPrivate = this.propertyBits[1];
        this.reserved = this.propertyBits[2];
        this.safeToCopy = this.propertyBits[3];
    }

    protected ByteArrayInputStream getDataStream() {
        ByteArrayInputStream is = new ByteArrayInputStream(this.bytes);
        return is;
    }
}

