/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.formats.tiff.TiffElement;
import org.apache.sanselan.formats.tiff.constants.TagInfo;
import org.apache.sanselan.formats.tiff.constants.TiffConstants;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldType;

public class TiffField
implements TiffConstants {
    public final TagInfo tagInfo;
    public final FieldType fieldType;
    public final int tag;
    public final int directoryType;
    public final int type;
    public final int length;
    public final int valueOffset;
    public final byte[] valueOffsetBytes;
    public byte[] oversizeValue = null;
    public final int byteOrder;
    private int sortHint = -1;
    public static final String Attribute_Tag = "Tag";
    private static final Map GPS_TAG_MAP = TiffField.makeTagMap(ALL_GPS_TAGS, false, "GPS");
    private static final Map TIFF_TAG_MAP = TiffField.makeTagMap(ALL_TIFF_TAGS, false, "TIFF");
    private static final Map EXIF_TAG_MAP = TiffField.makeTagMap(ALL_EXIF_TAGS, true, "EXIF");
    private static final Map ALL_TAG_MAP = TiffField.makeTagMap(ALL_TAGS, true, "All");

    public TiffField(int tag, int directoryType, int type, int Length2, int ValueOffset, byte[] ValueOffsetBytes, int byteOrder) {
        this.tag = tag;
        this.directoryType = directoryType;
        this.type = type;
        this.length = Length2;
        this.valueOffset = ValueOffset;
        this.valueOffsetBytes = ValueOffsetBytes;
        this.byteOrder = byteOrder;
        this.fieldType = TiffField.getFieldType(type);
        this.tagInfo = TiffField.getTag(directoryType, tag);
    }

    public boolean isLocalValue() {
        return this.fieldType.isLocalValue(this);
    }

    public int getBytesLength() throws ImageReadException {
        return this.fieldType.getBytesLength(this);
    }

    public TiffElement getOversizeValueElement() {
        if (this.fieldType.isLocalValue(this)) {
            return null;
        }
        return new OversizeValueElement(this.valueOffset, this.oversizeValue.length);
    }

    public void setOversizeValue(byte[] bytes) {
        this.oversizeValue = bytes;
    }

    private static FieldType getFieldType(int value) {
        for (int i = 0; i < FIELD_TYPES.length; ++i) {
            FieldType fieldType = FIELD_TYPES[i];
            if (fieldType.type != value) continue;
            return fieldType;
        }
        return FIELD_TYPE_UNKNOWN;
    }

    private static TagInfo getTag(int directoryType, int tag, List possibleMatches) {
        TagInfo tagInfo;
        int i;
        if (possibleMatches.size() < 1) {
            return null;
        }
        for (i = 0; i < possibleMatches.size(); ++i) {
            tagInfo = (TagInfo)possibleMatches.get(i);
            if (tagInfo.directoryType == EXIF_DIRECTORY_UNKNOWN) continue;
            if (directoryType == -2 && tagInfo.directoryType == EXIF_DIRECTORY_EXIF_IFD) {
                return tagInfo;
            }
            if (directoryType == -4 && tagInfo.directoryType == EXIF_DIRECTORY_INTEROP_IFD) {
                return tagInfo;
            }
            if (directoryType == -3 && tagInfo.directoryType == EXIF_DIRECTORY_GPS) {
                return tagInfo;
            }
            if (directoryType == -5 && tagInfo.directoryType == EXIF_DIRECTORY_MAKER_NOTES) {
                return tagInfo;
            }
            if (directoryType == 0 && tagInfo.directoryType == TIFF_DIRECTORY_IFD0) {
                return tagInfo;
            }
            if (directoryType == 1 && tagInfo.directoryType == TIFF_DIRECTORY_IFD1) {
                return tagInfo;
            }
            if (directoryType == 2 && tagInfo.directoryType == TIFF_DIRECTORY_IFD2) {
                return tagInfo;
            }
            if (directoryType != 3 || tagInfo.directoryType != TIFF_DIRECTORY_IFD3) continue;
            return tagInfo;
        }
        for (i = 0; i < possibleMatches.size(); ++i) {
            tagInfo = (TagInfo)possibleMatches.get(i);
            if (tagInfo.directoryType == EXIF_DIRECTORY_UNKNOWN) continue;
            if (directoryType >= 0 && tagInfo.directoryType.isImageDirectory()) {
                return tagInfo;
            }
            if (directoryType >= 0 || tagInfo.directoryType.isImageDirectory()) continue;
            return tagInfo;
        }
        for (i = 0; i < possibleMatches.size(); ++i) {
            tagInfo = (TagInfo)possibleMatches.get(i);
            if (tagInfo.directoryType != EXIF_DIRECTORY_UNKNOWN) continue;
            return tagInfo;
        }
        return TIFF_TAG_UNKNOWN;
    }

    private static TagInfo getTag(int directoryType, int tag) {
        Integer key = new Integer(tag);
        List possibleMatches = (List)EXIF_TAG_MAP.get(key);
        if (null == possibleMatches) {
            return TIFF_TAG_UNKNOWN;
        }
        TagInfo result = TiffField.getTag(directoryType, tag, possibleMatches);
        return result;
    }

    private int getValueLengthInBytes() {
        int unit_length = this.fieldType.length;
        int valueLength = unit_length * this.length;
        return valueLength;
    }

    public void fillInValue(ByteSource byteSource) throws ImageReadException, IOException {
        if (this.fieldType.isLocalValue(this)) {
            return;
        }
        int valueLength = this.getValueLengthInBytes();
        byte[] bytes = byteSource.getBlock(this.valueOffset, valueLength);
        this.setOversizeValue(bytes);
    }

    public String getValueDescription() {
        try {
            return this.getValueDescription(this.getValue());
        }
        catch (ImageReadException e) {
            return "Invalid value: " + e.getMessage();
        }
    }

    private String getValueDescription(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return o.toString();
        }
        if (o instanceof String) {
            return "'" + o.toString().trim() + "'";
        }
        if (o instanceof Date) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            return df.format((Date)o);
        }
        if (o instanceof Object[]) {
            Object[] objects = (Object[])o;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < objects.length; ++i) {
                Object object = objects[i];
                if (i > 50) {
                    result.append("... (" + objects.length + ")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append("" + object);
            }
            return result.toString();
        }
        if (o instanceof int[]) {
            int[] values = (int[])o;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < values.length; ++i) {
                int value = values[i];
                if (i > 50) {
                    result.append("... (" + values.length + ")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append("" + value);
            }
            return result.toString();
        }
        if (o instanceof long[]) {
            long[] values = (long[])o;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < values.length; ++i) {
                long value = values[i];
                if (i > 50) {
                    result.append("... (" + values.length + ")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append("" + value);
            }
            return result.toString();
        }
        if (o instanceof double[]) {
            double[] values = (double[])o;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < values.length; ++i) {
                double value = values[i];
                if (i > 50) {
                    result.append("... (" + values.length + ")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append("" + value);
            }
            return result.toString();
        }
        if (o instanceof byte[]) {
            byte[] values = (byte[])o;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < values.length; ++i) {
                byte value = values[i];
                if (i > 50) {
                    result.append("... (" + values.length + ")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append("" + value);
            }
            return result.toString();
        }
        if (o instanceof char[]) {
            char[] values = (char[])o;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < values.length; ++i) {
                char value = values[i];
                if (i > 50) {
                    result.append("... (" + values.length + ")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append("" + value);
            }
            return result.toString();
        }
        if (o instanceof float[]) {
            float[] values = (float[])o;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < values.length; ++i) {
                float value = values[i];
                if (i > 50) {
                    result.append("... (" + values.length + ")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append("" + value);
            }
            return result.toString();
        }
        return "Unknown: " + o.getClass().getName();
    }

    public void dump() {
        PrintWriter pw = new PrintWriter(System.out);
        this.dump(pw);
        pw.flush();
    }

    public void dump(PrintWriter pw) {
        this.dump(pw, null);
    }

    public void dump(PrintWriter pw, String prefix) {
        if (prefix != null) {
            pw.print(prefix + ": ");
        }
        pw.println(this.toString());
        pw.flush();
    }

    public String getDescriptionWithoutValue() {
        return this.tag + " (0x" + Integer.toHexString(this.tag) + ": " + this.tagInfo.name + "): ";
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.tag + " (0x" + Integer.toHexString(this.tag) + ": " + this.tagInfo.name + "): ");
        result.append(this.getValueDescription() + " (" + this.length + " " + this.fieldType.name + ")");
        return result.toString();
    }

    public String getTagName() {
        if (this.tagInfo == TIFF_TAG_UNKNOWN) {
            return this.tagInfo.name + " (0x" + Integer.toHexString(this.tag) + ")";
        }
        return this.tagInfo.name;
    }

    public String getFieldTypeName() {
        return this.fieldType.name;
    }

    public Object getValue() throws ImageReadException {
        return this.tagInfo.getValue(this);
    }

    public String getStringValue() throws ImageReadException {
        Object o = this.getValue();
        if (o == null) {
            return null;
        }
        if (!(o instanceof String)) {
            throw new ImageReadException("Expected String value(" + this.tagInfo.getDescription() + "): " + o);
        }
        return (String)o;
    }

    private static final Map makeTagMap(TagInfo[] tags, boolean ignoreDuplicates, String name) {
        Hashtable<Integer, ArrayList<TagInfo>> map = new Hashtable<Integer, ArrayList<TagInfo>>();
        for (int i = 0; i < tags.length; ++i) {
            TagInfo tag = tags[i];
            Integer key = new Integer(tag.tag);
            ArrayList<TagInfo> tagList = (ArrayList<TagInfo>)map.get(key);
            if (tagList == null) {
                tagList = new ArrayList<TagInfo>();
                map.put(key, tagList);
            }
            tagList.add(tag);
        }
        return map;
    }

    public int[] getIntArrayValue() throws ImageReadException {
        Object o = this.getValue();
        if (o instanceof Number) {
            return new int[]{((Number)o).intValue()};
        }
        if (o instanceof Number[]) {
            Number[] numbers = (Number[])o;
            int[] result = new int[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                result[i] = numbers[i].intValue();
            }
            return result;
        }
        if (o instanceof int[]) {
            int[] numbers = (int[])o;
            int[] result = new int[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                result[i] = numbers[i];
            }
            return result;
        }
        throw new ImageReadException("Unknown value: " + o + " for: " + this.tagInfo.getDescription());
    }

    public double[] getDoubleArrayValue() throws ImageReadException {
        Object o = this.getValue();
        if (o instanceof Number) {
            return new double[]{((Number)o).doubleValue()};
        }
        if (o instanceof Number[]) {
            Number[] numbers = (Number[])o;
            double[] result = new double[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                result[i] = numbers[i].doubleValue();
            }
            return result;
        }
        if (o instanceof int[]) {
            int[] numbers = (int[])o;
            double[] result = new double[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                result[i] = numbers[i];
            }
            return result;
        }
        if (o instanceof float[]) {
            float[] numbers = (float[])o;
            double[] result = new double[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                result[i] = numbers[i];
            }
            return result;
        }
        if (o instanceof double[]) {
            double[] numbers = (double[])o;
            double[] result = new double[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                result[i] = numbers[i];
            }
            return result;
        }
        throw new ImageReadException("Unknown value: " + o + " for: " + this.tagInfo.getDescription());
    }

    public int getIntValueOrArraySum() throws ImageReadException {
        Object o = this.getValue();
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof Number[]) {
            Number[] numbers = (Number[])o;
            int sum = 0;
            for (int i = 0; i < numbers.length; ++i) {
                sum += numbers[i].intValue();
            }
            return sum;
        }
        if (o instanceof int[]) {
            int[] numbers = (int[])o;
            int sum = 0;
            for (int i = 0; i < numbers.length; ++i) {
                sum += numbers[i];
            }
            return sum;
        }
        throw new ImageReadException("Unknown value: " + o + " for: " + this.tagInfo.getDescription());
    }

    public int getIntValue() throws ImageReadException {
        Object o = this.getValue();
        if (o == null) {
            throw new ImageReadException("Missing value: " + this.tagInfo.getDescription());
        }
        return ((Number)o).intValue();
    }

    public double getDoubleValue() throws ImageReadException {
        Object o = this.getValue();
        if (o == null) {
            throw new ImageReadException("Missing value: " + this.tagInfo.getDescription());
        }
        return ((Number)o).doubleValue();
    }

    public byte[] getByteArrayValue() throws ImageReadException {
        return this.fieldType.getRawBytes(this);
    }

    public int getSortHint() {
        return this.sortHint;
    }

    public void setSortHint(int sortHint) {
        this.sortHint = sortHint;
    }

    public final class OversizeValueElement
    extends TiffElement {
        public OversizeValueElement(int offset, int length) {
            super(offset, length);
        }

        public String getElementDescription(boolean verbose) {
            if (verbose) {
                return null;
            }
            return "OversizeValueElement, tag: " + TiffField.this.tagInfo.name + ", fieldType: " + TiffField.this.fieldType.name;
        }
    }
}

