/*
 * Decompiled with CFR 0.152.
 */
package org.jbibtex.citation;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.jbibtex.Key;
import org.jbibtex.LaTeXObject;
import org.jbibtex.LaTeXParser;
import org.jbibtex.LaTeXPrinter;
import org.jbibtex.ParseException;
import org.jbibtex.StringUtil;
import org.jbibtex.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldFormat {
    private Key key = null;
    private String separator = null;

    public FieldFormat(Key key, String separator) {
        this.setKey(key);
        this.setSeparator(separator);
    }

    public String format(Value value, boolean latex, boolean html) {
        String string = value.toUserString();
        if (latex) {
            try {
                string = FieldFormat.printLaTeX(FieldFormat.parseLaTeX(string));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(string, e);
            }
        }
        if (html) {
            string = StringUtil.escapeXml(string);
        }
        return string;
    }

    public Key getKey() {
        return this.key;
    }

    private void setKey(Key key) {
        this.key = key;
    }

    public String getSeparator() {
        return this.separator;
    }

    private void setSeparator(String separator) {
        this.separator = separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<LaTeXObject> parseLaTeX(String string) throws IOException, ParseException {
        StringReader reader = new StringReader(string);
        try {
            LaTeXParser parser = new LaTeXParser();
            List<LaTeXObject> list = parser.parse(reader);
            return list;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    private static String printLaTeX(List<LaTeXObject> objects) {
        LaTeXPrinter printer = new LaTeXPrinter();
        return printer.print(objects);
    }
}

