/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineOptionsProvider;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.MethodSetter;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;
import org.kohsuke.args4j.spi.Setters;

public class ProxyOptionHandler
extends OptionHandler<Object> {
    OptionHandler<?> proxy;

    public ProxyOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Object> setter) throws CmdLineException {
        super(parser, option, setter);
        OptionDef proxyOption = new OptionDef(option.usage(), option.metaVar(), option.required(), OptionHandler.class, option.isMultiValued());
        this.proxy = parser.createOptionHandler(proxyOption, setter);
        if (!option.required() && CmdLineOptionsProvider.class.isAssignableFrom(this.setter.getType())) {
            this.handleExtraArgs();
        }
    }

    @Override
    public String getDefaultMetaVariable() {
        return this.proxy.getDefaultMetaVariable();
    }

    @Override
    public int parseArguments(Parameters params) throws CmdLineException {
        if (CmdLineOptionsProvider.class.isAssignableFrom(this.setter.getType())) {
            this.removeExtraArgs();
        }
        int val = this.proxy.parseArguments(params);
        if (CmdLineOptionsProvider.class.isAssignableFrom(this.setter.getType())) {
            this.handleExtraArgs();
        }
        return val;
    }

    private void removeExtraArgs() throws CmdLineException {
        try {
            Setter actualsetter = null;
            actualsetter = this.setter instanceof SetterWrapper ? ((SetterWrapper)this.setter).setter : this.setter;
            Class<?> type = actualsetter.getClass();
            Field beanField = type.getDeclaredField("bean");
            beanField.setAccessible(true);
            Object bean = beanField.get(actualsetter);
            Field field = type.getDeclaredField("f");
            field.setAccessible(true);
            field = (Field)field.get(actualsetter);
            field.setAccessible(true);
            Object object = field.get(bean);
            if (object == null) {
                return;
            }
            if (!(object instanceof ArrayList)) {
                Object obj = ((CmdLineOptionsProvider)object).getOptions();
                if (obj instanceof Enum) {
                    System.err.println("Warning: Using an enum (" + field + ") as an options object with proxied options is not recommended and will be disallowed in the near future!");
                }
                this.removeOptions(obj, this.owner);
            }
        }
        catch (CmdLineException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CmdLineException(this.owner, "", e);
        }
    }

    private void handleExtraArgs() throws CmdLineException {
        try {
            Object obj;
            Setter actualsetter = null;
            actualsetter = this.setter instanceof SetterWrapper ? ((SetterWrapper)this.setter).setter : this.setter;
            Class<?> type = actualsetter.getClass();
            Field beanField = type.getDeclaredField("bean");
            beanField.setAccessible(true);
            Object bean = beanField.get(actualsetter);
            Field field = type.getDeclaredField("f");
            field.setAccessible(true);
            field = (Field)field.get(actualsetter);
            field.setAccessible(true);
            Object object = field.get(bean);
            if (object == null) {
                return;
            }
            if (object instanceof ArrayList) {
                if (((ArrayList)object).size() > 0) {
                    obj = ((CmdLineOptionsProvider)((ArrayList)object).get(((ArrayList)object).size() - 1)).getOptions();
                    this.addOptions(obj, this.owner);
                    this.setObjectField(bean, field, obj);
                }
            } else {
                obj = ((CmdLineOptionsProvider)object).getOptions();
                if (obj instanceof Enum) {
                    System.err.println("Warning: Using an enum (" + field + ") as an options object with proxied options is not recommended and will be disallowed in the near future!");
                }
                this.addOptions(obj, this.owner);
                this.setObjectField(bean, field, obj);
            }
            Field optionsField = this.owner.getClass().getDeclaredField("options");
            optionsField.setAccessible(true);
            List options = (List)optionsField.get(this.owner);
            Collections.sort(options, new Comparator<OptionHandler<?>>(){

                @Override
                public int compare(OptionHandler<?> o1, OptionHandler<?> o2) {
                    return o1.option.toString().compareTo(o2.option.toString());
                }
            });
        }
        catch (Exception e) {
            throw new CmdLineException(this.owner, "", e);
        }
    }

    protected void setObjectField(Object bean, Field field, Object obj) throws IllegalArgumentException, IllegalAccessException {
        try {
            Field newoptsfield = this.getDeclaredField(bean.getClass(), field.getName() + "Op");
            newoptsfield.setAccessible(true);
            ArrayList o = newoptsfield.get(bean);
            if (Collection.class.isAssignableFrom(newoptsfield.getType())) {
                if (o == null) {
                    o = new ArrayList();
                    newoptsfield.set(bean, o);
                }
                ((Collection)o).add(obj);
            } else {
                newoptsfield.set(bean, obj);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    protected Field getDeclaredField(Class<?> clz, String name) throws NoSuchFieldException {
        try {
            return clz.getDeclaredField(name);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            if (clz.getSuperclass() != null) {
                return this.getDeclaredField(clz.getSuperclass(), name);
            }
            throw e;
        }
    }

    private void addOptions(Object bean, CmdLineParser parser) {
        for (Class<?> c = bean.getClass(); c != null; c = c.getSuperclass()) {
            Argument a;
            Option o;
            for (Method method : c.getDeclaredMethods()) {
                o = method.getAnnotation(Option.class);
                if (o != null) {
                    parser.addOption(new SetterWrapper(new MethodSetter(parser, bean, method)), o);
                }
                if ((a = method.getAnnotation(Argument.class)) == null) continue;
                parser.addArgument(new SetterWrapper(new MethodSetter(parser, bean, method)), a);
            }
            for (AccessibleObject accessibleObject : c.getDeclaredFields()) {
                o = ((Field)accessibleObject).getAnnotation(Option.class);
                if (o != null) {
                    parser.addOption(new SetterWrapper(Setters.create((Field)accessibleObject, bean)), o);
                }
                if ((a = ((Field)accessibleObject).getAnnotation(Argument.class)) == null) continue;
                parser.addArgument(new SetterWrapper(Setters.create((Field)accessibleObject, bean)), a);
            }
        }
    }

    private void removeOptions(Object bean, CmdLineParser parser) throws CmdLineException {
        if (bean == null) {
            return;
        }
        for (Class<?> c = bean.getClass(); c != null; c = c.getSuperclass()) {
            Argument a;
            Option o;
            for (Method method : c.getDeclaredMethods()) {
                o = method.getAnnotation(Option.class);
                if (o != null) {
                    this.removeOption(parser, o);
                }
                if ((a = method.getAnnotation(Argument.class)) == null) continue;
                this.removeArgument(parser, a);
            }
            for (AccessibleObject accessibleObject : c.getDeclaredFields()) {
                o = ((Field)accessibleObject).getAnnotation(Option.class);
                if (o != null) {
                    this.removeOption(parser, o);
                    try {
                        ((Field)accessibleObject).setAccessible(true);
                        Object val = ((Field)accessibleObject).get(bean);
                        if (val instanceof CmdLineOptionsProvider) {
                            this.removeOptions(((CmdLineOptionsProvider)val).getOptions(), parser);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if ((a = ((Field)accessibleObject).getAnnotation(Argument.class)) == null) continue;
                this.removeArgument(parser, a);
            }
        }
    }

    private void removeArgument(CmdLineParser parser, Argument a) throws CmdLineException {
        try {
            Field argsField = CmdLineParser.class.getDeclaredField("arguments");
            argsField.setAccessible(true);
            List args = (List)argsField.get(parser);
            OptionHandler op = (OptionHandler)args.get(a.index());
            if (op.setter instanceof SetterWrapper && ((SetterWrapper)op.setter).used) {
                throw new CmdLineException(parser, "The use of the argument " + op.option.metaVar() + " is shaded by another argument");
            }
            args.set(a.index(), null);
        }
        catch (CmdLineException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CmdLineException(parser, "", e);
        }
    }

    private void removeOption(CmdLineParser parser, Option o) throws CmdLineException {
        try {
            Method find = CmdLineParser.class.getDeclaredMethod("findOptionHandler", String.class);
            find.setAccessible(true);
            OptionHandler op = (OptionHandler)find.invoke((Object)parser, o.name());
            if (op.setter instanceof SetterWrapper && ((SetterWrapper)op.setter).used) {
                throw new CmdLineException(parser, "The use of the option " + op.option + " is shaded by another option");
            }
            Field optionsField = CmdLineParser.class.getDeclaredField("options");
            optionsField.setAccessible(true);
            List options = (List)optionsField.get(parser);
            options.remove(op);
        }
        catch (CmdLineException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CmdLineException(parser, "", e);
        }
    }

    private class SetterWrapper
    implements Setter {
        Setter setter;
        boolean used = false;

        SetterWrapper(Setter setter) {
            this.setter = setter;
        }

        public void addValue(Object value) throws CmdLineException {
            this.used = true;
            this.setter.addValue(value);
        }

        public Class getType() {
            return this.setter.getType();
        }

        @Override
        public boolean isMultiValued() {
            return this.setter.isMultiValued();
        }
    }
}

