/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j.spi;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kohsuke.args4j.IllegalAnnotationError;
import org.kohsuke.args4j.spi.AbstractGetter;
import org.kohsuke.args4j.spi.Messages;
import org.openimaj.util.pair.IndependentPair;

public class MapGetter
extends AbstractGetter<Object> {
    public MapGetter(String name, Object bean, Field f) {
        super(name, bean, f);
    }

    @Override
    public List<IndependentPair<String, Class<?>>> getStringValues() {
        try {
            return this.getListStrings();
        }
        catch (Exception _ignore) {
            this.f.setAccessible(true);
            try {
                return this.getListStrings();
            }
            catch (Exception e) {
                throw new IllegalAccessError(e.getMessage());
            }
        }
    }

    private List<IndependentPair<String, Class<?>>> getListStrings() throws IllegalArgumentException, IllegalAccessException {
        Object o = this.f.get(this.bean);
        if (o == null) {
            return new ArrayList();
        }
        if (!(o instanceof Map)) {
            throw new IllegalAnnotationError(Messages.ILLEGAL_FIELD_SIGNATURE.format(this.f));
        }
        ArrayList ret = new ArrayList();
        for (Map.Entry obj : ((Map)o).entrySet()) {
            Class<Object> objClass = Object.class;
            IndependentPair<String, Class<Object>> pair = new IndependentPair<String, Class<Object>>(obj.getKey().toString() + "=" + obj.getValue().toString(), objClass);
            ret.add(pair);
        }
        return ret;
    }

    @Override
    public boolean isMultiValued() {
        return true;
    }
}

