/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.matrix;

import java.io.InputStream;
import java.util.Arrays;
import org.la4j.decomposition.CholeskyDecompositor;
import org.la4j.decomposition.EigenDecompositor;
import org.la4j.decomposition.LUDecompositor;
import org.la4j.decomposition.MatrixDecompositor;
import org.la4j.decomposition.QRDecompositor;
import org.la4j.decomposition.SingularValueDecompositor;
import org.la4j.factory.Basic1DFactory;
import org.la4j.factory.Basic2DFactory;
import org.la4j.factory.CCSFactory;
import org.la4j.factory.CRSFactory;
import org.la4j.factory.Factory;
import org.la4j.factory.SafeFactory;
import org.la4j.inversion.GaussianInvertor;
import org.la4j.inversion.MatrixInvertor;
import org.la4j.io.MatrixMarketStream;
import org.la4j.io.SymbolSeparatedStream;
import org.la4j.linear.GaussianSolver;
import org.la4j.linear.JacobiSolver;
import org.la4j.linear.LinearSystem;
import org.la4j.linear.LinearSystemSolver;
import org.la4j.linear.SeidelSolver;
import org.la4j.linear.SquareRootSolver;
import org.la4j.linear.SweepSolver;
import org.la4j.matrix.Matrix;
import org.la4j.matrix.functor.AdvancedMatrixPredicate;
import org.la4j.matrix.functor.MatrixAccumulator;
import org.la4j.matrix.functor.MatrixFunction;
import org.la4j.matrix.functor.MatrixPredicate;
import org.la4j.matrix.source.Array1DMatrixSource;
import org.la4j.matrix.source.Array2DMatrixSource;
import org.la4j.matrix.source.IdentityMattixSource;
import org.la4j.matrix.source.MatrixSource;
import org.la4j.matrix.source.RandomMatrixSource;
import org.la4j.matrix.source.RandomSymmetricMatrixSource;
import org.la4j.matrix.source.SafeMatrixSource;
import org.la4j.matrix.source.StreamMatrixSource;
import org.la4j.matrix.source.UnsafeMatrixSource;
import org.la4j.vector.Vector;

public final class Matrices {
    public static final double EPS;
    public static final MatrixPredicate DIAGONAL_MATRIX;
    public static final MatrixPredicate IDENTITY_MATRIX;
    public static final MatrixPredicate ZERO_MATRIX;
    public static final MatrixPredicate TRIDIAGONAL_MATRIX;
    public static final MatrixPredicate POSITIVE_MATRIX;
    public static final MatrixPredicate NEGATIVE_MATRIX;
    public static final MatrixPredicate LOWER_BIDIAGONAL_MATRIX;
    public static final MatrixPredicate UPPER_BIDIAGONAL_MATRIX;
    public static final MatrixPredicate LOWER_TRIANGULAR_MARTIX;
    public static final MatrixPredicate UPPER_TRIANGULAR_MATRIX;
    public static final MatrixPredicate SYMMETRIC_MATRIX;
    public static final MatrixFunction INC_FUNCTION;
    public static final MatrixFunction DEC_FUNCTION;
    public static final MatrixFunction INV_FUNCTION;
    public static final Factory BASIC1D_FACTORY;
    public static final Factory BASIC2D_FACTORY;
    public static final Factory CRS_FACTORY;
    public static final Factory CCS_FACTORY;
    public static final Factory SAFE_BASIC1D_FACTORY;
    public static final Factory SAFE_BASIC2D_FACTORY;
    public static final Factory SAFE_CRS_FACTORY;
    public static final Factory SAFE_CCS_FACTORY;
    public static final Factory UNSAFE_BASIC1D_FACTORY;
    public static final Factory UNSAFE_BASIC2D_FACTORY;
    public static final Factory UNSAFE_CRS_FACTORY;
    public static final Factory UNSAFE_CCS_FACTORY;
    public static final Factory DEFAULT_DENSE_FACTORY;
    public static final Factory DEFAULT_SPARSE_FACTORY;
    public static final Factory DEFAULT_FACTORY;
    public static final MatrixDecompositor CHOLESKY_DECOMPOSITOR;
    public static final MatrixDecompositor EIGEN_DECOMPOSITOR;
    public static final MatrixDecompositor LU_DECOMPOSITOR;
    public static final MatrixDecompositor QR_DECOMPOSITOR;
    public static final MatrixDecompositor SINGULAR_VALUE_DECOMPOSITOR;
    public static final MatrixInvertor GAUSSIAN_INVERTOR;
    public static final MatrixInvertor DEFAULT_INVERTOR;
    public static final LinearSystemSolver GAUSSIAN_SOLVER;
    public static final LinearSystemSolver JACOBI_SOLVER;
    public static final LinearSystemSolver SEIDEL_SOLVER;
    public static final LinearSystemSolver SQUARE_ROOT_SOLVER;
    public static final LinearSystemSolver SWEEP_SOLVER;
    public static final LinearSystemSolver DEFAULT_SOLVER;

    public static MatrixFunction asPlusFunction(double value) {
        return new PlusMatrixFunction(value);
    }

    public static MatrixFunction asMinusFunction(double value) {
        return new MinusMatrixFunction(value);
    }

    public static MatrixFunction asMulFunction(double value) {
        return new MulMatrixFunction(value);
    }

    public static MatrixFunction asDivFunction(double value) {
        return new DivMatrixFunction(value);
    }

    public static Matrix asSingletonMatrix(double value) {
        return DEFAULT_FACTORY.createMatrix(new double[][]{{value}});
    }

    public static LinearSystem asLinearSystem(Matrix a, Vector b) {
        return DEFAULT_FACTORY.createLinearSystem(a, b);
    }

    public static Matrix asSafeMatrix(Matrix matrix) {
        return matrix.safe();
    }

    public static Matrix asUnsafeMatrix(Matrix matrix) {
        return matrix.unsafe();
    }

    public static MatrixSource asSafeSource(Matrix matrix) {
        return new SafeMatrixSource(matrix);
    }

    public static MatrixSource asUnsafeSource(Matrix matrix) {
        return new UnsafeMatrixSource(matrix);
    }

    public static MatrixSource asArray1DSource(int rows, int columns, double[] array) {
        return new Array1DMatrixSource(rows, columns, array);
    }

    public static MatrixSource asArray2DSource(double[][] array) {
        return new Array2DMatrixSource(array);
    }

    public static MatrixSource asIdentitySource(int size) {
        return new IdentityMattixSource(size);
    }

    public static MatrixSource asRandomSource(int rows, int columns) {
        return new RandomMatrixSource(rows, columns);
    }

    public static MatrixSource asRandomSymmetricSource(int size) {
        return new RandomSymmetricMatrixSource(size);
    }

    public static MatrixSource asMatrixMarketSource(InputStream in) {
        return new StreamMatrixSource(new MatrixMarketStream(in));
    }

    public static MatrixSource asSymbolSeparatedSource(InputStream in) {
        return new StreamMatrixSource(new SymbolSeparatedStream(in));
    }

    public static MatrixSource asSymbolSeparatedSource(InputStream in, String separator) {
        return new StreamMatrixSource(new SymbolSeparatedStream(in, separator));
    }

    public static MatrixAccumulator asSumAccumulator(double neutral) {
        return new SumMatrixAccumulator(neutral);
    }

    public static MatrixAccumulator asProductAccumulator(double neutral) {
        return new ProductMatrixAccumulator(neutral);
    }

    public static MatrixAccumulator asSumFunctionAccumulator(double neutral, MatrixFunction function) {
        return new FunctionMatrixAccumulator(new SumMatrixAccumulator(neutral), function);
    }

    public static MatrixAccumulator asProductFunctionAccumulator(double neutral, MatrixFunction function) {
        return new FunctionMatrixAccumulator(new ProductMatrixAccumulator(neutral), function);
    }

    static {
        double eps = 1.0;
        while (1.0 + eps > 1.0) {
            eps /= 2.0;
        }
        EPS = eps * 100.0;
        DIAGONAL_MATRIX = new DiagonalMatrixPredicate();
        IDENTITY_MATRIX = new IdentityMatrixPredicate();
        ZERO_MATRIX = new ZeroMatrixPredicate();
        TRIDIAGONAL_MATRIX = new TridiagonalMatrixPredicate();
        POSITIVE_MATRIX = new PositiveMatrixPredicate();
        NEGATIVE_MATRIX = new NegativeMatrixPredicate();
        LOWER_BIDIAGONAL_MATRIX = new LowerBidiagonalMatrixPredicate();
        UPPER_BIDIAGONAL_MATRIX = new UpperBidiagonalMatrixPredicate();
        LOWER_TRIANGULAR_MARTIX = new LowerTriangularMatrixPredicate();
        UPPER_TRIANGULAR_MATRIX = new UpperTriangularMatrixPredicate();
        SYMMETRIC_MATRIX = new SymmetricMatrixPredicate();
        INC_FUNCTION = new IncMatrixFunction();
        DEC_FUNCTION = new DecMatrixFunction();
        INV_FUNCTION = new InvMatrixFunction();
        BASIC1D_FACTORY = new Basic1DFactory();
        BASIC2D_FACTORY = new Basic2DFactory();
        CRS_FACTORY = new CRSFactory();
        CCS_FACTORY = new CCSFactory();
        SAFE_BASIC1D_FACTORY = new SafeFactory(BASIC1D_FACTORY);
        SAFE_BASIC2D_FACTORY = new SafeFactory(BASIC2D_FACTORY);
        SAFE_CRS_FACTORY = new SafeFactory(CRS_FACTORY);
        SAFE_CCS_FACTORY = new SafeFactory(CCS_FACTORY);
        UNSAFE_BASIC1D_FACTORY = BASIC1D_FACTORY;
        UNSAFE_BASIC2D_FACTORY = BASIC2D_FACTORY;
        UNSAFE_CRS_FACTORY = CRS_FACTORY;
        UNSAFE_CCS_FACTORY = CCS_FACTORY;
        DEFAULT_DENSE_FACTORY = BASIC2D_FACTORY;
        DEFAULT_SPARSE_FACTORY = CRS_FACTORY;
        DEFAULT_FACTORY = BASIC2D_FACTORY;
        CHOLESKY_DECOMPOSITOR = new CholeskyDecompositor();
        EIGEN_DECOMPOSITOR = new EigenDecompositor();
        LU_DECOMPOSITOR = new LUDecompositor();
        QR_DECOMPOSITOR = new QRDecompositor();
        SINGULAR_VALUE_DECOMPOSITOR = new SingularValueDecompositor();
        DEFAULT_INVERTOR = GAUSSIAN_INVERTOR = new GaussianInvertor();
        GAUSSIAN_SOLVER = new GaussianSolver();
        JACOBI_SOLVER = new JacobiSolver();
        SEIDEL_SOLVER = new SeidelSolver();
        SQUARE_ROOT_SOLVER = new SquareRootSolver();
        SWEEP_SOLVER = new SweepSolver();
        DEFAULT_SOLVER = GAUSSIAN_SOLVER;
    }

    private static class FunctionMatrixAccumulator
    implements MatrixAccumulator {
        private MatrixAccumulator accumulator;
        private MatrixFunction function;

        public FunctionMatrixAccumulator(MatrixAccumulator accumulator, MatrixFunction function) {
            this.accumulator = accumulator;
            this.function = function;
        }

        @Override
        public void update(int i, int j, double value) {
            this.accumulator.update(i, j, this.function.evaluate(i, j, value));
        }

        @Override
        public double accumulate() {
            return this.accumulator.accumulate();
        }
    }

    private static class ProductMatrixAccumulator
    implements MatrixAccumulator {
        private double result;

        public ProductMatrixAccumulator(double neutral) {
            this.result = neutral;
        }

        @Override
        public void update(int i, int j, double value) {
            this.result *= value;
        }

        @Override
        public double accumulate() {
            return this.result;
        }
    }

    private static class SumMatrixAccumulator
    implements MatrixAccumulator {
        private double result;

        public SumMatrixAccumulator(double neutral) {
            this.result = neutral;
        }

        @Override
        public void update(int i, int j, double value) {
            this.result += value;
        }

        @Override
        public double accumulate() {
            return this.result;
        }
    }

    private static class DivMatrixFunction
    implements MatrixFunction {
        private double arg;

        public DivMatrixFunction(double arg) {
            this.arg = arg;
        }

        @Override
        public double evaluate(int i, int j, double value) {
            return value / this.arg;
        }
    }

    private static class MulMatrixFunction
    implements MatrixFunction {
        private double arg;

        public MulMatrixFunction(double arg) {
            this.arg = arg;
        }

        @Override
        public double evaluate(int i, int j, double value) {
            return value * this.arg;
        }
    }

    private static class MinusMatrixFunction
    implements MatrixFunction {
        private double arg;

        public MinusMatrixFunction(double arg) {
            this.arg = arg;
        }

        @Override
        public double evaluate(int i, int j, double value) {
            return value - this.arg;
        }
    }

    private static class PlusMatrixFunction
    implements MatrixFunction {
        private double arg;

        public PlusMatrixFunction(double arg) {
            this.arg = arg;
        }

        @Override
        public double evaluate(int i, int j, double value) {
            return value + this.arg;
        }
    }

    private static class InvMatrixFunction
    implements MatrixFunction {
        private InvMatrixFunction() {
        }

        @Override
        public double evaluate(int i, int j, double value) {
            return -value;
        }
    }

    private static class DecMatrixFunction
    implements MatrixFunction {
        private DecMatrixFunction() {
        }

        @Override
        public double evaluate(int i, int j, double value) {
            return value - 1.0;
        }
    }

    private static class IncMatrixFunction
    implements MatrixFunction {
        private IncMatrixFunction() {
        }

        @Override
        public double evaluate(int i, int j, double value) {
            return value + 1.0;
        }
    }

    private static class SymmetricMatrixPredicate
    implements AdvancedMatrixPredicate {
        private double[] values;
        private int size;

        private SymmetricMatrixPredicate() {
        }

        @Override
        public boolean test(int rows, int columns) {
            if (rows != columns) {
                return false;
            }
            this.size = rows;
            this.values = new double[(this.size * this.size - this.size) / 2];
            Arrays.fill(this.values, Double.NaN);
            return true;
        }

        @Override
        public boolean test(int i, int j, double value) {
            int offset = -1;
            if (i < j) {
                offset = j - (i + 1) + (int)((double)(this.size - 1 + (this.size - i)) / 2.0 * (double)i);
            } else if (i > j) {
                offset = i - (j + 1) + (int)((double)(this.size - 1 + (this.size - j)) / 2.0 * (double)j);
            } else {
                return true;
            }
            if (Double.isNaN(this.values[offset])) {
                this.values[offset] = value;
                return true;
            }
            double diff = Math.abs(value - this.values[offset]);
            return value == this.values[offset] ? true : (diff < EPS ? true : diff / Math.max(Math.abs(value), Math.abs(this.values[offset])) < EPS);
        }
    }

    private static class UpperTriangularMatrixPredicate
    implements MatrixPredicate {
        private UpperTriangularMatrixPredicate() {
        }

        @Override
        public boolean test(int i, int j, double value) {
            return i < j ? Math.abs(value) < EPS : true;
        }
    }

    private static class LowerTriangularMatrixPredicate
    implements MatrixPredicate {
        private LowerTriangularMatrixPredicate() {
        }

        @Override
        public boolean test(int i, int j, double value) {
            return i > j ? Math.abs(value) < EPS : true;
        }
    }

    private static class UpperBidiagonalMatrixPredicate
    implements MatrixPredicate {
        private UpperBidiagonalMatrixPredicate() {
        }

        @Override
        public boolean test(int i, int j, double value) {
            return i == j || i == j - 1 ? Math.abs(value) < EPS : true;
        }
    }

    private static class LowerBidiagonalMatrixPredicate
    implements MatrixPredicate {
        private LowerBidiagonalMatrixPredicate() {
        }

        @Override
        public boolean test(int i, int j, double value) {
            return i == j || i == j + 1 ? Math.abs(value) < EPS : true;
        }
    }

    private static class NegativeMatrixPredicate
    implements MatrixPredicate {
        private NegativeMatrixPredicate() {
        }

        @Override
        public boolean test(int i, int j, double value) {
            return value < 0.0;
        }
    }

    private static class PositiveMatrixPredicate
    implements MatrixPredicate {
        private PositiveMatrixPredicate() {
        }

        @Override
        public boolean test(int i, int j, double value) {
            return value > 0.0;
        }
    }

    private static class TridiagonalMatrixPredicate
    implements MatrixPredicate {
        private TridiagonalMatrixPredicate() {
        }

        @Override
        public boolean test(int i, int j, double value) {
            return Math.abs(i - j) > 1 ? Math.abs(value) < EPS : true;
        }
    }

    private static class ZeroMatrixPredicate
    implements MatrixPredicate {
        private ZeroMatrixPredicate() {
        }

        @Override
        public boolean test(int i, int j, double value) {
            return Math.abs(value) < EPS;
        }
    }

    private static class IdentityMatrixPredicate
    implements MatrixPredicate {
        private IdentityMatrixPredicate() {
        }

        @Override
        public boolean test(int i, int j, double value) {
            return i == j ? Math.abs(1.0 - value) < EPS : Math.abs(value) < EPS;
        }
    }

    private static class DiagonalMatrixPredicate
    implements MatrixPredicate {
        private DiagonalMatrixPredicate() {
        }

        @Override
        public boolean test(int i, int j, double value) {
            return i != j ? Math.abs(value) < EPS : true;
        }
    }
}

