/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.blas;

import org.netlib.blas.BLAS;
import org.netlib.blas.Dasum;
import org.netlib.blas.Daxpy;
import org.netlib.blas.Dcopy;
import org.netlib.blas.Ddot;
import org.netlib.blas.Dgbmv;
import org.netlib.blas.Dgemm;
import org.netlib.blas.Dgemv;
import org.netlib.blas.Dger;
import org.netlib.blas.Dnrm2;
import org.netlib.blas.Drot;
import org.netlib.blas.Drotg;
import org.netlib.blas.Drotm;
import org.netlib.blas.Drotmg;
import org.netlib.blas.Dsbmv;
import org.netlib.blas.Dscal;
import org.netlib.blas.Dspmv;
import org.netlib.blas.Dspr;
import org.netlib.blas.Dspr2;
import org.netlib.blas.Dswap;
import org.netlib.blas.Dsymm;
import org.netlib.blas.Dsymv;
import org.netlib.blas.Dsyr;
import org.netlib.blas.Dsyr2;
import org.netlib.blas.Dsyr2k;
import org.netlib.blas.Dsyrk;
import org.netlib.blas.Dtbmv;
import org.netlib.blas.Dtbsv;
import org.netlib.blas.Dtpmv;
import org.netlib.blas.Dtpsv;
import org.netlib.blas.Dtrmm;
import org.netlib.blas.Dtrmv;
import org.netlib.blas.Dtrsm;
import org.netlib.blas.Dtrsv;
import org.netlib.blas.Idamax;
import org.netlib.blas.Isamax;
import org.netlib.blas.Sasum;
import org.netlib.blas.Saxpy;
import org.netlib.blas.Scopy;
import org.netlib.blas.Sdot;
import org.netlib.blas.Sdsdot;
import org.netlib.blas.Sgbmv;
import org.netlib.blas.Sgemm;
import org.netlib.blas.Sgemv;
import org.netlib.blas.Sger;
import org.netlib.blas.Snrm2;
import org.netlib.blas.Srot;
import org.netlib.blas.Srotg;
import org.netlib.blas.Srotm;
import org.netlib.blas.Srotmg;
import org.netlib.blas.Ssbmv;
import org.netlib.blas.Sscal;
import org.netlib.blas.Sspmv;
import org.netlib.blas.Sspr;
import org.netlib.blas.Sspr2;
import org.netlib.blas.Sswap;
import org.netlib.blas.Ssymm;
import org.netlib.blas.Ssymv;
import org.netlib.blas.Ssyr;
import org.netlib.blas.Ssyr2;
import org.netlib.blas.Ssyr2k;
import org.netlib.blas.Ssyrk;
import org.netlib.blas.Stbmv;
import org.netlib.blas.Stbsv;
import org.netlib.blas.Stpmv;
import org.netlib.blas.Stpsv;
import org.netlib.blas.Strmm;
import org.netlib.blas.Strmv;
import org.netlib.blas.Strsm;
import org.netlib.blas.Strsv;
import org.netlib.util.doubleW;
import org.netlib.util.floatW;

final class JBLAS
extends BLAS {
    static final BLAS INSTANCE = new JBLAS();

    private JBLAS() {
    }

    public double dasum(int n, double[] dx, int incx) {
        return Dasum.dasum(n, dx, 0, incx);
    }

    public void daxpy(int n, double da, double[] dx, int incx, double[] dy, int incy) {
        Daxpy.daxpy(n, da, dx, 0, incx, dy, 0, incy);
    }

    public void dcopy(int n, double[] dx, int incx, double[] dy, int incy) {
        Dcopy.dcopy(n, dx, 0, incx, dy, 0, incy);
    }

    public double ddot(int n, double[] dx, int incx, double[] dy, int incy) {
        return Ddot.ddot(n, dx, 0, incx, dy, 0, incy);
    }

    public void dgbmv(String trans, int m, int n, int kl, int ku, double alpha, double[] a, int lda, double[] x, int incx, double beta, double[] y, int incy) {
        Dgbmv.dgbmv(trans, m, n, kl, ku, alpha, a, 0, lda, x, 0, incx, beta, y, 0, incy);
    }

    public void dgemm(String transa, String transb, int m, int n, int k, double alpha, double[] a, int lda, double[] b, int ldb, double beta, double[] c, int Ldc) {
        Dgemm.dgemm(transa, transb, m, n, k, alpha, a, 0, lda, b, 0, ldb, beta, c, 0, Ldc);
    }

    public void dgemv(String trans, int m, int n, double alpha, double[] a, int lda, double[] x, int incx, double beta, double[] y, int incy) {
        Dgemv.dgemv(trans, m, n, alpha, a, 0, lda, x, 0, incx, beta, y, 0, incy);
    }

    public void dger(int m, int n, double alpha, double[] x, int incx, double[] y, int incy, double[] a, int lda) {
        Dger.dger(m, n, alpha, x, 0, incx, y, 0, incy, a, 0, lda);
    }

    public double dnrm2(int n, double[] x, int incx) {
        return Dnrm2.dnrm2(n, x, 0, incx);
    }

    public void drot(int n, double[] dx, int incx, double[] dy, int incy, double c, double s) {
        Drot.drot(n, dx, 0, incx, dy, 0, incy, c, s);
    }

    public void drotg(doubleW da, doubleW db, doubleW c, doubleW s) {
        Drotg.drotg(da, db, c, s);
    }

    public void drotm(int n, double[] dx, int incx, double[] dy, int incy, double[] dparam) {
        Drotm.drotm(n, dx, 0, incx, dy, 0, incy, dparam, 0);
    }

    public void drotmg(doubleW dd1, doubleW dd2, doubleW dx1, double dy1, double[] dparam) {
        Drotmg.drotmg(dd1, dd2, dx1, dy1, dparam, 0);
    }

    public void dsbmv(String uplo, int n, int k, double alpha, double[] a, int lda, double[] x, int incx, double beta, double[] y, int incy) {
        Dsbmv.dsbmv(uplo, n, k, alpha, a, 0, lda, x, 0, incx, beta, y, 0, incy);
    }

    public void dscal(int n, double da, double[] dx, int incx) {
        Dscal.dscal(n, da, dx, 0, incx);
    }

    public void dspmv(String uplo, int n, double alpha, double[] ap, double[] x, int incx, double beta, double[] y, int incy) {
        Dspmv.dspmv(uplo, n, alpha, ap, 0, x, 0, incx, beta, y, 0, incy);
    }

    public void dspr(String uplo, int n, double alpha, double[] x, int incx, double[] ap) {
        Dspr.dspr(uplo, n, alpha, x, 0, incx, ap, 0);
    }

    public void dspr2(String uplo, int n, double alpha, double[] x, int incx, double[] y, int incy, double[] ap) {
        Dspr2.dspr2(uplo, n, alpha, x, 0, incx, y, 0, incy, ap, 0);
    }

    public void dswap(int n, double[] dx, int incx, double[] dy, int incy) {
        Dswap.dswap(n, dx, 0, incx, dy, 0, incy);
    }

    public void dsymm(String side, String uplo, int m, int n, double alpha, double[] a, int lda, double[] b, int ldb, double beta, double[] c, int Ldc) {
        Dsymm.dsymm(side, uplo, m, n, alpha, a, 0, lda, b, 0, ldb, beta, c, 0, Ldc);
    }

    public void dsymv(String uplo, int n, double alpha, double[] a, int lda, double[] x, int incx, double beta, double[] y, int incy) {
        Dsymv.dsymv(uplo, n, alpha, a, 0, lda, x, 0, incx, beta, y, 0, incy);
    }

    public void dsyr(String uplo, int n, double alpha, double[] x, int incx, double[] a, int lda) {
        Dsyr.dsyr(uplo, n, alpha, x, 0, incx, a, 0, lda);
    }

    public void dsyr2(String uplo, int n, double alpha, double[] x, int incx, double[] y, int incy, double[] a, int lda) {
        Dsyr2.dsyr2(uplo, n, alpha, x, 0, incx, y, 0, incy, a, 0, lda);
    }

    public void dsyr2k(String uplo, String trans, int n, int k, double alpha, double[] a, int lda, double[] b, int ldb, double beta, double[] c, int Ldc) {
        Dsyr2k.dsyr2k(uplo, trans, n, k, alpha, a, 0, lda, b, 0, ldb, beta, c, 0, Ldc);
    }

    public void dsyrk(String uplo, String trans, int n, int k, double alpha, double[] a, int lda, double beta, double[] c, int Ldc) {
        Dsyrk.dsyrk(uplo, trans, n, k, alpha, a, 0, lda, beta, c, 0, Ldc);
    }

    public void dtbmv(String uplo, String trans, String diag, int n, int k, double[] a, int lda, double[] x, int incx) {
        Dtbmv.dtbmv(uplo, trans, diag, n, k, a, 0, lda, x, 0, incx);
    }

    public void dtbsv(String uplo, String trans, String diag, int n, int k, double[] a, int lda, double[] x, int incx) {
        Dtbsv.dtbsv(uplo, trans, diag, n, k, a, 0, lda, x, 0, incx);
    }

    public void dtpmv(String uplo, String trans, String diag, int n, double[] ap, double[] x, int incx) {
        Dtpmv.dtpmv(uplo, trans, diag, n, ap, 0, x, 0, incx);
    }

    public void dtpsv(String uplo, String trans, String diag, int n, double[] ap, double[] x, int incx) {
        Dtpsv.dtpsv(uplo, trans, diag, n, ap, 0, x, 0, incx);
    }

    public void dtrmm(String side, String uplo, String transa, String diag, int m, int n, double alpha, double[] a, int lda, double[] b, int ldb) {
        Dtrmm.dtrmm(side, uplo, transa, diag, m, n, alpha, a, 0, lda, b, 0, ldb);
    }

    public void dtrmv(String uplo, String trans, String diag, int n, double[] a, int lda, double[] x, int incx) {
        Dtrmv.dtrmv(uplo, trans, diag, n, a, 0, lda, x, 0, incx);
    }

    public void dtrsm(String side, String uplo, String transa, String diag, int m, int n, double alpha, double[] a, int lda, double[] b, int ldb) {
        Dtrsm.dtrsm(side, uplo, transa, diag, m, n, alpha, a, 0, lda, b, 0, ldb);
    }

    public void dtrsv(String uplo, String trans, String diag, int n, double[] a, int lda, double[] x, int incx) {
        Dtrsv.dtrsv(uplo, trans, diag, n, a, 0, lda, x, 0, incx);
    }

    public int idamax(int n, double[] dx, int incx) {
        return Idamax.idamax(n, dx, 0, incx);
    }

    public int isamax(int n, float[] sx, int incx) {
        return Isamax.isamax(n, sx, 0, incx);
    }

    public float sasum(int n, float[] sx, int incx) {
        return Sasum.sasum(n, sx, 0, incx);
    }

    public void saxpy(int n, float sa, float[] sx, int incx, float[] sy, int incy) {
        Saxpy.saxpy(n, sa, sx, 0, incx, sy, 0, incy);
    }

    public void scopy(int n, float[] sx, int incx, float[] sy, int incy) {
        Scopy.scopy(n, sx, 0, incx, sy, 0, incy);
    }

    public float sdot(int n, float[] sx, int incx, float[] sy, int incy) {
        return Sdot.sdot(n, sx, 0, incx, sy, 0, incy);
    }

    public float sdsdot(int n, float sb, float[] sx, int incx, float[] sy, int incy) {
        return Sdsdot.sdsdot(n, sb, sx, 0, incx, sy, 0, incy);
    }

    public void sgbmv(String trans, int m, int n, int kl, int ku, float alpha, float[] a, int lda, float[] x, int incx, float beta, float[] y, int incy) {
        Sgbmv.sgbmv(trans, m, n, kl, ku, alpha, a, 0, lda, x, 0, incx, beta, y, 0, incy);
    }

    public void sgemm(String transa, String transb, int m, int n, int k, float alpha, float[] a, int lda, float[] b, int ldb, float beta, float[] c, int Ldc) {
        Sgemm.sgemm(transa, transb, m, n, k, alpha, a, 0, lda, b, 0, ldb, beta, c, 0, Ldc);
    }

    public void sgemv(String trans, int m, int n, float alpha, float[] a, int lda, float[] x, int incx, float beta, float[] y, int incy) {
        Sgemv.sgemv(trans, m, n, alpha, a, 0, lda, x, 0, incx, beta, y, 0, incy);
    }

    public void sger(int m, int n, float alpha, float[] x, int incx, float[] y, int incy, float[] a, int lda) {
        Sger.sger(m, n, alpha, x, 0, incx, y, 0, incy, a, 0, lda);
    }

    public float snrm2(int n, float[] x, int incx) {
        return Snrm2.snrm2(n, x, 0, incx);
    }

    public void srot(int n, float[] sx, int incx, float[] sy, int incy, float c, float s) {
        Srot.srot(n, sx, 0, incx, sy, 0, incy, c, s);
    }

    public void srotg(floatW sa, floatW sb, floatW c, floatW s) {
        Srotg.srotg(sa, sb, c, s);
    }

    public void srotm(int n, float[] sx, int incx, float[] sy, int incy, float[] sparam) {
        Srotm.srotm(n, sx, 0, incx, sy, 0, incy, sparam, 0);
    }

    public void srotmg(floatW sd1, floatW sd2, floatW sx1, float sy1, float[] sparam) {
        Srotmg.srotmg(sd1, sd2, sx1, sy1, sparam, 0);
    }

    public void ssbmv(String uplo, int n, int k, float alpha, float[] a, int lda, float[] x, int incx, float beta, float[] y, int incy) {
        Ssbmv.ssbmv(uplo, n, k, alpha, a, 0, lda, x, 0, incx, beta, y, 0, incy);
    }

    public void sscal(int n, float sa, float[] sx, int incx) {
        Sscal.sscal(n, sa, sx, 0, incx);
    }

    public void sspmv(String uplo, int n, float alpha, float[] ap, float[] x, int incx, float beta, float[] y, int incy) {
        Sspmv.sspmv(uplo, n, alpha, ap, 0, x, 0, incx, beta, y, 0, incy);
    }

    public void sspr(String uplo, int n, float alpha, float[] x, int incx, float[] ap) {
        Sspr.sspr(uplo, n, alpha, x, 0, incx, ap, 0);
    }

    public void sspr2(String uplo, int n, float alpha, float[] x, int incx, float[] y, int incy, float[] ap) {
        Sspr2.sspr2(uplo, n, alpha, x, 0, incx, y, 0, incy, ap, 0);
    }

    public void sswap(int n, float[] sx, int incx, float[] sy, int incy) {
        Sswap.sswap(n, sx, 0, incx, sy, 0, incy);
    }

    public void ssymm(String side, String uplo, int m, int n, float alpha, float[] a, int lda, float[] b, int ldb, float beta, float[] c, int Ldc) {
        Ssymm.ssymm(side, uplo, m, n, alpha, a, 0, lda, b, 0, ldb, beta, c, 0, Ldc);
    }

    public void ssymv(String uplo, int n, float alpha, float[] a, int lda, float[] x, int incx, float beta, float[] y, int incy) {
        Ssymv.ssymv(uplo, n, alpha, a, 0, lda, x, 0, incx, beta, y, 0, incy);
    }

    public void ssyr(String uplo, int n, float alpha, float[] x, int incx, float[] a, int lda) {
        Ssyr.ssyr(uplo, n, alpha, x, 0, incx, a, 0, lda);
    }

    public void ssyr2(String uplo, int n, float alpha, float[] x, int incx, float[] y, int incy, float[] a, int lda) {
        Ssyr2.ssyr2(uplo, n, alpha, x, 0, incx, y, 0, incy, a, 0, lda);
    }

    public void ssyr2k(String uplo, String trans, int n, int k, float alpha, float[] a, int lda, float[] b, int ldb, float beta, float[] c, int Ldc) {
        Ssyr2k.ssyr2k(uplo, trans, n, k, alpha, a, 0, lda, b, 0, ldb, beta, c, 0, Ldc);
    }

    public void ssyrk(String uplo, String trans, int n, int k, float alpha, float[] a, int lda, float beta, float[] c, int Ldc) {
        Ssyrk.ssyrk(uplo, trans, n, k, alpha, a, 0, lda, beta, c, 0, Ldc);
    }

    public void stbmv(String uplo, String trans, String diag, int n, int k, float[] a, int lda, float[] x, int incx) {
        Stbmv.stbmv(uplo, trans, diag, n, k, a, 0, lda, x, 0, incx);
    }

    public void stbsv(String uplo, String trans, String diag, int n, int k, float[] a, int lda, float[] x, int incx) {
        Stbsv.stbsv(uplo, trans, diag, n, k, a, 0, lda, x, 0, incx);
    }

    public void stpmv(String uplo, String trans, String diag, int n, float[] ap, float[] x, int incx) {
        Stpmv.stpmv(uplo, trans, diag, n, ap, 0, x, 0, incx);
    }

    public void stpsv(String uplo, String trans, String diag, int n, float[] ap, float[] x, int incx) {
        Stpsv.stpsv(uplo, trans, diag, n, ap, 0, x, 0, incx);
    }

    public void strmm(String side, String uplo, String transa, String diag, int m, int n, float alpha, float[] a, int lda, float[] b, int ldb) {
        Strmm.strmm(side, uplo, transa, diag, m, n, alpha, a, 0, lda, b, 0, ldb);
    }

    public void strmv(String uplo, String trans, String diag, int n, float[] a, int lda, float[] x, int incx) {
        Strmv.strmv(uplo, trans, diag, n, a, 0, lda, x, 0, incx);
    }

    public void strsm(String side, String uplo, String transa, String diag, int m, int n, float alpha, float[] a, int lda, float[] b, int ldb) {
        Strsm.strsm(side, uplo, transa, diag, m, n, alpha, a, 0, lda, b, 0, ldb);
    }

    public void strsv(String uplo, String trans, String diag, int n, float[] a, int lda, float[] x, int incx) {
        Strsv.strsv(uplo, trans, diag, n, a, 0, lda, x, 0, incx);
    }
}

