/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.citation.annotation.input;

import java.io.IOException;
import java.io.InputStreamReader;
import org.jbibtex.BibTeXDatabase;
import org.jbibtex.BibTeXEntry;
import org.jbibtex.BibTeXParser;
import org.jbibtex.ParseException;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.mock.MockReference;
import org.openimaj.citation.annotation.output.StandardFormatters;

public class BibtexToReference {
    public static void main(String[] args) throws IOException, ParseException {
        System.out.println("Enter bibtex record(s), followed by ctrl-d: ");
        InputStreamReader reader = new InputStreamReader(System.in);
        BibTeXParser parser = new BibTeXParser();
        BibTeXDatabase database = parser.parse(reader);
        System.out.println();
        for (BibTeXEntry entry : database.getEntries().values()) {
            Reference r = MockReference.makeReference(entry);
            System.out.println(StandardFormatters.REFERENCE_ANNOTATION.format(r));
        }
    }
}

