/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.citation.annotation.processor;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.References;
import org.openimaj.citation.annotation.output.StandardFormatters;

@SupportedAnnotationTypes(value={"org.openimaj.citation.annotation.Reference", "org.openimaj.citation.annotation.References"})
public class ReferenceProcessor
extends AbstractProcessor {
    private static final String[] extensions = new String[]{"bib", "html", "txt"};
    private static final String[] names = new String[]{"BibTeX", "HTML", "text"};
    private static final StandardFormatters[] types = new StandardFormatters[]{StandardFormatters.BIBTEX, StandardFormatters.HTML, StandardFormatters.STRING};
    Set<Reference> references = new HashSet<Reference>();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                References ann2;
                Reference ann1 = element.getAnnotation(Reference.class);
                if (ann1 != null) {
                    this.references.add(ann1);
                }
                if ((ann2 = element.getAnnotation(References.class)) == null) continue;
                for (Reference r : ann2.references()) {
                    this.references.add(r);
                }
            }
        }
        if (roundEnv.processingOver()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Creating project bibliography");
            for (int i = 0; i < types.length; ++i) {
                try {
                    String string = types[i].format(this.references);
                    FileObject file = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", "bibliography." + extensions[i], new Element[0]);
                    PrintWriter printWriter = new PrintWriter(file.openOutputStream());
                    ((Writer)printWriter).append(string);
                    ((Writer)printWriter).close();
                    continue;
                }
                catch (IOException iOException) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error writing " + names[i] + " " + iOException);
                }
            }
        }
        return true;
    }
}

