/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.content.animation.animator;

import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import org.openimaj.content.animation.animator.LinearFloatValueAnimator;
import org.openimaj.content.animation.animator.ValueAnimator;

public class RandomLinearFloatValueAnimator
implements ValueAnimator<Float> {
    private int seed;
    Uniform rng;
    LinearFloatValueAnimator animator;
    private float min;
    private float max;
    private int duration;

    public RandomLinearFloatValueAnimator(float min, float max, int duration) {
        this.seed = (int)System.nanoTime();
        this.min = min;
        this.max = max;
        this.duration = duration;
        this.reset();
    }

    public RandomLinearFloatValueAnimator(float min, float max, int duration, float initial) {
        this(min, max, duration);
        this.setNextAnimator(initial);
    }

    public RandomLinearFloatValueAnimator(int startWait, int stopWait, float min, float max, int duration) {
        this.seed = (int)System.currentTimeMillis();
        this.min = min;
        this.max = max;
        this.duration = duration;
        this.reset();
    }

    public RandomLinearFloatValueAnimator(int startWait, int stopWait, float min, float max, int duration, float initial) {
        this(min, max, duration);
        this.setNextAnimator(initial);
    }

    @Override
    public Float nextValue() {
        if (this.animator.hasFinished()) {
            this.setNextAnimator(((Float)this.animator.nextValue()).floatValue());
        }
        return (Float)this.animator.nextValue();
    }

    @Override
    public boolean hasFinished() {
        return false;
    }

    @Override
    public void reset() {
        this.rng = new Uniform(new MersenneTwister(this.seed));
        float v1 = this.rng.nextFloatFromTo(this.min, this.max);
        this.setNextAnimator(v1);
    }

    protected void setNextAnimator(float v1) {
        float v2 = this.rng.nextFloatFromTo(this.min, this.max);
        this.animator = new LinearFloatValueAnimator(v1, v2, this.duration);
    }
}

