/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.content.animation.animator;

import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import org.openimaj.content.animation.animator.LinearLongValueAnimator;
import org.openimaj.content.animation.animator.ValueAnimator;

public class RandomLinearLongValueAnimator
implements ValueAnimator<Long> {
    private int seed;
    Uniform rng;
    LinearLongValueAnimator animator;
    private long min;
    private long max;
    private int duration;

    public RandomLinearLongValueAnimator(long min, long max, int duration) {
        this.seed = (int)System.nanoTime();
        this.min = min;
        this.max = max;
        this.duration = duration;
        this.reset();
    }

    public RandomLinearLongValueAnimator(long min, long max, int duration, long initial) {
        this(min, max, duration);
        this.setNextAnimator(initial);
    }

    public RandomLinearLongValueAnimator(int startWait, int stopWait, long min, long max, int duration) {
        this.seed = (int)System.currentTimeMillis();
        this.min = min;
        this.max = max;
        this.duration = duration;
        this.reset();
    }

    public RandomLinearLongValueAnimator(int startWait, int stopWait, long min, long max, int duration, long initial) {
        this(min, max, duration);
        this.setNextAnimator(initial);
    }

    @Override
    public Long nextValue() {
        if (this.animator.hasFinished()) {
            this.setNextAnimator((Long)this.animator.nextValue());
        }
        return (Long)this.animator.nextValue();
    }

    @Override
    public boolean hasFinished() {
        return false;
    }

    @Override
    public void reset() {
        this.rng = new Uniform(new MersenneTwister(this.seed));
        long v1 = this.rng.nextLongFromTo(this.min, this.max);
        this.setNextAnimator(v1);
    }

    protected void setNextAnimator(long v1) {
        long v2 = this.rng.nextLongFromTo(this.min, this.max);
        this.animator = new LinearLongValueAnimator(v1, v2, this.duration);
    }
}

