/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import org.openimaj.feature.ArrayFeatureVector;
import org.openimaj.feature.ByteFVComparison;
import org.openimaj.feature.DoubleFV;
import org.openimaj.util.concatenate.Concatenatable;

public class ByteFV
extends ArrayFeatureVector<byte[]>
implements Concatenatable<ByteFV, ByteFV>,
Cloneable {
    private static final long serialVersionUID = 1L;

    public ByteFV() {
    }

    public ByteFV(int nbins) {
        this.values = new byte[nbins];
    }

    public ByteFV(byte[] values) {
        this.values = values;
    }

    public byte get(int x) {
        return ((byte[])this.values)[x];
    }

    void set(byte value, int x) {
        ((byte[])this.values)[x] = value;
    }

    @Override
    public DoubleFV normaliseFV(double[] min, double[] max) {
        double[] dvals = this.asDoubleVector();
        for (int i = 0; i < dvals.length; ++i) {
            int n = i;
            dvals[n] = dvals[n] - min[i];
            int n2 = i;
            dvals[n2] = dvals[n2] / (max[i] - min[i]);
            if (dvals[i] < 0.0) {
                dvals[i] = 0.0;
            }
            if (!(dvals[i] > 1.0)) continue;
            dvals[i] = 1.0;
        }
        return new DoubleFV(dvals);
    }

    @Override
    public DoubleFV normaliseFV(double min, double max) {
        double[] dvals = this.asDoubleVector();
        for (int i = 0; i < dvals.length; ++i) {
            int n = i;
            dvals[n] = dvals[n] - min;
            int n2 = i;
            dvals[n2] = dvals[n2] / (max - min);
            if (dvals[i] < 0.0) {
                dvals[i] = 0.0;
            }
            if (!(dvals[i] > 1.0)) continue;
            dvals[i] = 1.0;
        }
        return new DoubleFV(dvals);
    }

    @Override
    public DoubleFV normaliseFV() {
        int i;
        double[] dvals = this.asDoubleVector();
        double sum = 0.0;
        for (i = 0; i < dvals.length; ++i) {
            sum += dvals[i];
        }
        i = 0;
        while (i < dvals.length) {
            int n = i++;
            dvals[n] = dvals[n] / sum;
        }
        return new DoubleFV(dvals);
    }

    @Override
    public DoubleFV normaliseFV(double p) {
        int i;
        double[] dvals = this.asDoubleVector();
        double pnorm = 0.0;
        for (i = 0; i < dvals.length; ++i) {
            pnorm += Math.pow(Math.abs(dvals[i]), p);
        }
        pnorm = Math.pow(pnorm, 1.0 / p);
        i = 0;
        while (i < dvals.length) {
            int n = i++;
            dvals[n] = dvals[n] / pnorm;
        }
        return new DoubleFV(dvals);
    }

    public ByteFV clone() {
        try {
            ByteFV model = (ByteFV)super.clone();
            model.values = ((byte[])this.values).clone();
            return model;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toString() {
        String ret = this.getClass().getName() + Arrays.toString((byte[])this.values);
        return ret;
    }

    @Override
    public DoubleFV asDoubleFV() {
        return new DoubleFV(this.asDoubleVector());
    }

    @Override
    public double[] asDoubleVector() {
        double[] d = new double[((byte[])this.values).length];
        for (int i = 0; i < ((byte[])this.values).length; ++i) {
            d[i] = ((byte[])this.values)[i];
        }
        return d;
    }

    public double compare(ByteFV h, ByteFVComparison method) {
        return method.compare(this, h);
    }

    @Override
    public int length() {
        return ((byte[])this.values).length;
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        out.writeInt(((byte[])this.values).length);
        for (int i = 0; i < ((byte[])this.values).length; ++i) {
            out.writeByte(((byte[])this.values)[i]);
        }
    }

    @Override
    public void writeASCII(PrintWriter out) throws IOException {
        out.println(((byte[])this.values).length);
        for (int i = 0; i < ((byte[])this.values).length; ++i) {
            out.print(((byte[])this.values)[i] + " ");
        }
        out.println();
    }

    @Override
    public void readBinary(DataInput in) throws IOException {
        int nbins = in.readInt();
        this.values = new byte[nbins];
        for (int i = 0; i < nbins; ++i) {
            ((byte[])this.values)[i] = in.readByte();
        }
    }

    @Override
    public void readASCII(Scanner in) throws IOException {
        int nbins = Integer.parseInt(in.nextLine());
        this.values = new byte[nbins];
        String[] line = in.nextLine().trim().split(" ");
        for (int i = 0; i < nbins; ++i) {
            ((byte[])this.values)[i] = Byte.parseByte(line[i]);
        }
    }

    @Override
    public byte[] binaryHeader() {
        return (this.getClass().getName().substring(0, 2) + "FV").getBytes();
    }

    @Override
    public String asciiHeader() {
        return this.getClass().getName() + " ";
    }

    public ByteFV concatenate(ByteFV ... ins) {
        int l = ((byte[])this.values).length;
        for (int i = 0; i < ins.length; ++i) {
            l += ((byte[])ins[i].values).length;
        }
        byte[] data = new byte[l];
        System.arraycopy(this.values, 0, data, 0, ((byte[])this.values).length);
        int offset = ((byte[])this.values).length;
        for (int i = 0; i < ins.length; ++i) {
            System.arraycopy(ins[i].values, 0, data, offset, ((byte[])ins[i].values).length);
            offset += ((byte[])ins[i].values).length;
        }
        return new ByteFV(data);
    }

    @Override
    public ByteFV concatenate(List<ByteFV> ins) {
        int l = ((byte[])this.values).length;
        for (int i = 0; i < ins.size(); ++i) {
            l += ((byte[])ins.get((int)i).values).length;
        }
        byte[] data = new byte[l];
        System.arraycopy(this.values, 0, data, 0, ((byte[])this.values).length);
        int offset = ((byte[])this.values).length;
        for (int i = 0; i < ins.size(); ++i) {
            System.arraycopy(ins.get((int)i).values, 0, data, offset, ((byte[])ins.get((int)i).values).length);
            offset += ((byte[])ins.get((int)i).values).length;
        }
        return new ByteFV(data);
    }

    public int hashCode() {
        return Arrays.hashCode((byte[])this.values);
    }

    public boolean equals(Object obj) {
        return Arrays.equals((byte[])this.values, (byte[])((ByteFV)obj).values);
    }

    public ByteFV subvector(int beginIndex) {
        return new ByteFV(Arrays.copyOfRange((byte[])this.values, beginIndex, ((byte[])this.values).length));
    }

    public ByteFV subvector(int beginIndex, int endIndex) {
        return new ByteFV(Arrays.copyOfRange((byte[])this.values, beginIndex, endIndex));
    }

    @Override
    public double getAsDouble(int i) {
        return ((byte[])this.values)[i];
    }

    @Override
    public void setFromDouble(int i, double v) {
        ((byte[])this.values)[i] = (byte)v;
    }

    @Override
    public ByteFV newInstance() {
        return new ByteFV(this.length());
    }
}

