/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature;

import java.util.HashMap;
import org.openimaj.data.identity.Identifiable;
import org.openimaj.feature.FeatureExtractor;

public class CachingFeatureExtractor<FEATURE, OBJECT extends Identifiable>
implements FeatureExtractor<FEATURE, OBJECT> {
    private FeatureExtractor<FEATURE, OBJECT> extractor;
    private boolean force;
    private HashMap<String, FEATURE> cache = new HashMap();

    public CachingFeatureExtractor(FeatureExtractor<FEATURE, OBJECT> extractor) {
        this(extractor, false);
    }

    public CachingFeatureExtractor(FeatureExtractor<FEATURE, OBJECT> extractor, boolean force) {
        this.extractor = extractor;
        this.force = force;
    }

    @Override
    public FEATURE extractFeature(OBJECT object) {
        FEATURE cachedFeature = this.cache.get(object.getID());
        FEATURE feature = null;
        if (!this.force && cachedFeature != null && (feature = (FEATURE)cachedFeature) != null) {
            return feature;
        }
        feature = this.extractor.extractFeature(object);
        this.cache.put(object.getID(), feature);
        return feature;
    }

    public String toString() {
        return this.extractor.toString();
    }
}

