/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature;

import gnu.trove.set.hash.TDoubleHashSet;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.DoubleFVComparator;
import org.openimaj.math.util.distance.HammingUtils;

public enum DoubleFVComparison implements DoubleFVComparator
{
    EUCLIDEAN(true){

        @Override
        public double compare(double[] h1, double[] h2) {
            if (h1.length != h2.length) {
                throw new IllegalArgumentException("Vectors have differing lengths");
            }
            double d = 0.0;
            for (int i = 0; i < h1.length; ++i) {
                double diff = h1[i] - h2[i];
                d += diff * diff;
            }
            return Math.sqrt(d);
        }
    }
    ,
    SUM_SQUARE(true){

        @Override
        public double compare(double[] h1, double[] h2) {
            if (h1.length != h2.length) {
                throw new IllegalArgumentException("Vectors have differing lengths");
            }
            double d = 0.0;
            for (int i = 0; i < h1.length; ++i) {
                double diff = h1[i] - h2[i];
                d += diff * diff;
            }
            return d;
        }
    }
    ,
    CORRELATION(false){

        @Override
        public double compare(double[] h1, double[] h2) {
            if (h1.length != h2.length) {
                throw new IllegalArgumentException("Vectors have differing lengths");
            }
            double N = h1.length;
            double SH1 = 0.0;
            double SH2 = 0.0;
            int i = 0;
            while ((double)i < N) {
                SH1 += h1[i];
                SH2 += h2[i];
                ++i;
            }
            SH1 /= N;
            SH2 /= N;
            double d = 0.0;
            double SH1S = 0.0;
            double SH2S = 0.0;
            int i2 = 0;
            while ((double)i2 < N) {
                double h1prime = h1[i2] - SH1;
                double h2prime = h2[i2] - SH2;
                d += h1prime * h2prime;
                SH1S += h1prime * h1prime;
                SH2S += h2prime * h2prime;
                ++i2;
            }
            if (d == 0.0) {
                return 0.0;
            }
            return d / Math.sqrt(SH1S * SH2S);
        }
    }
    ,
    CHI_SQUARE(true){

        @Override
        public double compare(double[] h1, double[] h2) {
            if (h1.length != h2.length) {
                throw new IllegalArgumentException("Vectors have differing lengths");
            }
            double d = 0.0;
            for (int i = 0; i < h1.length; ++i) {
                double a = h1[i] - h2[i];
                double b = h1[i] + h2[i];
                if (!(Math.abs(b) > 0.0)) continue;
                d += a * a / b;
            }
            return d / 2.0;
        }
    }
    ,
    INTERSECTION(false){

        @Override
        public double compare(double[] h1, double[] h2) {
            if (h1.length != h2.length) {
                throw new IllegalArgumentException("Vectors have differing lengths");
            }
            double d = 0.0;
            for (int i = 0; i < h1.length; ++i) {
                d += Math.min(h1[i], h2[i]);
            }
            return d;
        }
    }
    ,
    BHATTACHARYYA(true){

        @Override
        public double compare(double[] h1, double[] h2) {
            if (h1.length != h2.length) {
                throw new IllegalArgumentException("Vectors have differing lengths");
            }
            int N = h1.length;
            double SH1 = 0.0;
            double SH2 = 0.0;
            double d = 0.0;
            for (int i = 0; i < N; ++i) {
                SH1 += h1[i];
                SH2 += h2[i];
                d += Math.sqrt(h1[i] * h2[i]);
            }
            double den = SH1 * SH2;
            if (den == 0.0) {
                return 1.0;
            }
            return Math.sqrt(1.0 - (d /= Math.sqrt(den)));
        }
    }
    ,
    HAMMING(true){

        @Override
        public double compare(double[] h1, double[] h2) {
            if (h1.length != h2.length) {
                throw new IllegalArgumentException("Vectors have differing lengths");
            }
            int d = 0;
            for (int i = 0; i < h1.length; ++i) {
                if (h1[i] == h2[i]) continue;
                ++d;
            }
            return d;
        }
    }
    ,
    PACKED_HAMMING(true){

        @Override
        public double compare(double[] h1, double[] h2) {
            if (h1.length != h2.length) {
                throw new IllegalArgumentException("Vectors have differing lengths");
            }
            int d = 0;
            for (int i = 0; i < h1.length; ++i) {
                d += HammingUtils.packedHamming(h1[i], h2[i]);
            }
            return d;
        }
    }
    ,
    CITY_BLOCK(true){

        @Override
        public double compare(double[] h1, double[] h2) {
            if (h1.length != h2.length) {
                throw new IllegalArgumentException("Vectors have differing lengths");
            }
            double d = 0.0;
            for (int i = 0; i < h1.length; ++i) {
                d += Math.abs(h1[i] - h2[i]);
            }
            return d;
        }
    }
    ,
    COSINE_SIM(false){

        @Override
        public double compare(double[] h1, double[] h2) {
            if (h1.length != h2.length) {
                throw new IllegalArgumentException("Vectors have differing lengths");
            }
            double h12 = 0.0;
            double h11 = 0.0;
            double h22 = 0.0;
            for (int i = 0; i < h1.length; ++i) {
                h12 += h1[i] * h2[i];
                h11 += h1[i] * h1[i];
                h22 += h2[i] * h2[i];
            }
            return h12 / (Math.sqrt(h11) * Math.sqrt(h22));
        }
    }
    ,
    COSINE_DIST(true){

        @Override
        public double compare(double[] h1, double[] h2) {
            return -1.0 * COSINE_SIM.compare(h1, h2);
        }
    }
    ,
    ARCCOS(true){

        @Override
        public double compare(double[] h1, double[] h2) {
            return Math.acos(COSINE_SIM.compare(h1, h2));
        }
    }
    ,
    SYMMETRIC_KL_DIVERGENCE(true){

        @Override
        public double compare(double[] h1, double[] h2) {
            if (h1.length != h2.length) {
                throw new IllegalArgumentException("Vectors have differing lengths");
            }
            double sum1 = 0.0;
            double sum2 = 0.0;
            for (int i = 0; i < h1.length; ++i) {
                sum1 += h1[i];
                sum2 += h2[i];
            }
            double d = 0.0;
            for (int i = 0; i < h1.length; ++i) {
                double h1n = h1[i] / sum1;
                double h2n = h2[i] / sum2;
                double q1 = h1n / h2n;
                double q2 = h2n / h1n;
                if (h1n != 0.0) {
                    d += h1n * Math.log(q1) / Math.log(2.0);
                }
                if (h2n == 0.0) continue;
                d += h2n * Math.log(q2) / Math.log(2.0);
            }
            return d / 2.0;
        }
    }
    ,
    JACCARD_DISTANCE(true){

        @Override
        public double compare(double[] h1, double[] h2) {
            TDoubleHashSet union = new TDoubleHashSet(h1);
            union.addAll(h2);
            TDoubleHashSet intersection = new TDoubleHashSet(h1);
            intersection.retainAll((double[])h2.clone());
            return 1.0 - (double)intersection.size() / (double)union.size();
        }
    }
    ,
    INNER_PRODUCT(false){

        @Override
        public double compare(double[] h1, double[] h2) {
            if (h1.length != h2.length) {
                throw new IllegalArgumentException("Vectors have differing lengths");
            }
            double h12 = 0.0;
            for (int i = 0; i < h1.length; ++i) {
                h12 += h1[i] * h2[i];
            }
            return h12;
        }
    };

    private boolean isDistance;

    private DoubleFVComparison(boolean isDistance) {
        this.isDistance = isDistance;
    }

    @Override
    public boolean isDistance() {
        return this.isDistance;
    }

    @Override
    public double compare(DoubleFV h1, DoubleFV h2) {
        return this.compare((double[])h1.values, (double[])h2.values);
    }

    @Override
    public abstract double compare(double[] var1, double[] var2);
}

