/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import org.openimaj.feature.ArrayFeatureVector;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.IntFVComparison;
import org.openimaj.util.concatenate.Concatenatable;

public class IntFV
extends ArrayFeatureVector<int[]>
implements Concatenatable<IntFV, IntFV>,
Cloneable {
    private static final long serialVersionUID = 1L;

    public IntFV() {
    }

    public IntFV(int nbins) {
        this.values = new int[nbins];
    }

    public IntFV(int[] values) {
        this.values = values;
    }

    public int get(int x) {
        return ((int[])this.values)[x];
    }

    void set(int value, int x) {
        ((int[])this.values)[x] = value;
    }

    @Override
    public DoubleFV normaliseFV(double[] min, double[] max) {
        double[] dvals = this.asDoubleVector();
        for (int i = 0; i < dvals.length; ++i) {
            int n = i;
            dvals[n] = dvals[n] - min[i];
            int n2 = i;
            dvals[n2] = dvals[n2] / (max[i] - min[i]);
            if (dvals[i] < 0.0) {
                dvals[i] = 0.0;
            }
            if (!(dvals[i] > 1.0)) continue;
            dvals[i] = 1.0;
        }
        return new DoubleFV(dvals);
    }

    @Override
    public DoubleFV normaliseFV(double min, double max) {
        double[] dvals = this.asDoubleVector();
        for (int i = 0; i < dvals.length; ++i) {
            int n = i;
            dvals[n] = dvals[n] - min;
            int n2 = i;
            dvals[n2] = dvals[n2] / (max - min);
            if (dvals[i] < 0.0) {
                dvals[i] = 0.0;
            }
            if (!(dvals[i] > 1.0)) continue;
            dvals[i] = 1.0;
        }
        return new DoubleFV(dvals);
    }

    @Override
    public DoubleFV normaliseFV() {
        int i;
        double[] dvals = this.asDoubleVector();
        double sum = 0.0;
        for (i = 0; i < dvals.length; ++i) {
            sum += dvals[i];
        }
        i = 0;
        while (i < dvals.length) {
            int n = i++;
            dvals[n] = dvals[n] / sum;
        }
        return new DoubleFV(dvals);
    }

    @Override
    public DoubleFV normaliseFV(double p) {
        int i;
        double[] dvals = this.asDoubleVector();
        double pnorm = 0.0;
        for (i = 0; i < dvals.length; ++i) {
            pnorm += Math.pow(Math.abs(dvals[i]), p);
        }
        pnorm = Math.pow(pnorm, 1.0 / p);
        i = 0;
        while (i < dvals.length) {
            int n = i++;
            dvals[n] = dvals[n] / pnorm;
        }
        return new DoubleFV(dvals);
    }

    public IntFV clone() {
        try {
            IntFV model = (IntFV)super.clone();
            model.values = ((int[])this.values).clone();
            return model;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toString() {
        String ret = this.getClass().getName() + Arrays.toString((int[])this.values);
        return ret;
    }

    @Override
    public DoubleFV asDoubleFV() {
        return new DoubleFV(this.asDoubleVector());
    }

    @Override
    public double[] asDoubleVector() {
        double[] d = new double[((int[])this.values).length];
        for (int i = 0; i < ((int[])this.values).length; ++i) {
            d[i] = ((int[])this.values)[i];
        }
        return d;
    }

    public double compare(IntFV h, IntFVComparison method) {
        return method.compare(this, h);
    }

    @Override
    public int length() {
        return ((int[])this.values).length;
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        out.writeInt(((int[])this.values).length);
        for (int i = 0; i < ((int[])this.values).length; ++i) {
            out.writeInt(((int[])this.values)[i]);
        }
    }

    @Override
    public void writeASCII(PrintWriter out) throws IOException {
        out.println(((int[])this.values).length);
        for (int i = 0; i < ((int[])this.values).length; ++i) {
            out.print(((int[])this.values)[i] + " ");
        }
        out.println();
    }

    @Override
    public void readBinary(DataInput in) throws IOException {
        int nbins = in.readInt();
        this.values = new int[nbins];
        for (int i = 0; i < nbins; ++i) {
            ((int[])this.values)[i] = in.readInt();
        }
    }

    @Override
    public void readASCII(Scanner in) throws IOException {
        int nbins = Integer.parseInt(in.nextLine());
        this.values = new int[nbins];
        String[] line = in.nextLine().trim().split(" ");
        for (int i = 0; i < nbins; ++i) {
            ((int[])this.values)[i] = Integer.parseInt(line[i]);
        }
    }

    @Override
    public byte[] binaryHeader() {
        return (this.getClass().getName().substring(0, 2) + "FV").getBytes();
    }

    @Override
    public String asciiHeader() {
        return this.getClass().getName() + " ";
    }

    public IntFV concatenate(IntFV ... ins) {
        int l = ((int[])this.values).length;
        for (int i = 0; i < ins.length; ++i) {
            l += ((int[])ins[i].values).length;
        }
        int[] data = new int[l];
        System.arraycopy(this.values, 0, data, 0, ((int[])this.values).length);
        int offset = ((int[])this.values).length;
        for (int i = 0; i < ins.length; ++i) {
            System.arraycopy(ins[i].values, 0, data, offset, ((int[])ins[i].values).length);
            offset += ((int[])ins[i].values).length;
        }
        return new IntFV(data);
    }

    @Override
    public IntFV concatenate(List<IntFV> ins) {
        int l = ((int[])this.values).length;
        for (int i = 0; i < ins.size(); ++i) {
            l += ((int[])ins.get((int)i).values).length;
        }
        int[] data = new int[l];
        System.arraycopy(this.values, 0, data, 0, ((int[])this.values).length);
        int offset = ((int[])this.values).length;
        for (int i = 0; i < ins.size(); ++i) {
            System.arraycopy(ins.get((int)i).values, 0, data, offset, ((int[])ins.get((int)i).values).length);
            offset += ((int[])ins.get((int)i).values).length;
        }
        return new IntFV(data);
    }

    public int hashCode() {
        return Arrays.hashCode((int[])this.values);
    }

    public boolean equals(Object obj) {
        return Arrays.equals((int[])this.values, (int[])((IntFV)obj).values);
    }

    public IntFV subvector(int beginIndex) {
        return new IntFV(Arrays.copyOfRange((int[])this.values, beginIndex, ((int[])this.values).length));
    }

    public IntFV subvector(int beginIndex, int endIndex) {
        return new IntFV(Arrays.copyOfRange((int[])this.values, beginIndex, endIndex));
    }

    @Override
    public double getAsDouble(int i) {
        return ((int[])this.values)[i];
    }

    @Override
    public void setFromDouble(int i, double v) {
        ((int[])this.values)[i] = (int)v;
    }

    @Override
    public IntFV newInstance() {
        return new IntFV(this.length());
    }
}

