/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature.local;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.openimaj.feature.FeatureVector;
import org.openimaj.feature.local.LocalFeature;
import org.openimaj.feature.local.Location;

public class LocalFeatureImpl<L extends Location, F extends FeatureVector>
implements LocalFeature<L, F> {
    public L location;
    public F feature;

    public LocalFeatureImpl(L location, F feature) {
        this.location = location;
        this.feature = feature;
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        this.location.writeBinary(out);
        this.feature.writeBinary(out);
    }

    @Override
    public void writeASCII(PrintWriter out) throws IOException {
        this.location.writeASCII(out);
        this.feature.writeASCII(out);
    }

    @Override
    public void readBinary(DataInput in) throws IOException {
        this.location.readBinary(in);
        this.feature.readBinary(in);
    }

    @Override
    public void readASCII(Scanner in) throws IOException {
        this.location.readASCII(in);
        this.feature.readASCII(in);
    }

    @Override
    public byte[] binaryHeader() {
        return ("LFVI." + new String(this.location.binaryHeader()) + "." + new String(this.feature.asciiHeader())).getBytes();
    }

    @Override
    public String asciiHeader() {
        return this.getClass().getName() + "." + this.location.asciiHeader() + "." + this.feature.asciiHeader();
    }

    @Override
    public F getFeatureVector() {
        return this.feature;
    }

    @Override
    public L getLocation() {
        return this.location;
    }
}

