/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature.local;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.openimaj.feature.local.Location;
import org.openimaj.math.geometry.point.Point2dImpl;

public class SpatialLocation
extends Point2dImpl
implements Location,
Cloneable {
    private static final long serialVersionUID = 1L;

    public SpatialLocation() {
        super(0.0f, 0.0f);
    }

    public SpatialLocation(float x, float y) {
        super(x, y);
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        out.writeFloat(this.x);
        out.writeFloat(this.y);
    }

    @Override
    public void writeASCII(PrintWriter out) throws IOException {
        out.format("%4.2f %4.2f", Float.valueOf(this.y), Float.valueOf(this.x));
        out.println();
    }

    @Override
    public void readBinary(DataInput in) throws IOException {
        this.x = in.readFloat();
        this.y = in.readFloat();
    }

    @Override
    public void readASCII(Scanner in) throws IOException {
        this.y = Float.parseFloat(in.next());
        this.x = Float.parseFloat(in.next());
    }

    @Override
    public byte[] binaryHeader() {
        return "".getBytes();
    }

    @Override
    public String asciiHeader() {
        return "";
    }

    @Override
    public Float getOrdinate(int dimension) {
        float[] pos = new float[]{this.x, this.y};
        return Float.valueOf(pos[dimension]);
    }

    @Override
    public int getDimensions() {
        return 3;
    }

    @Override
    public SpatialLocation clone() {
        SpatialLocation c = (SpatialLocation)super.clone();
        return c;
    }
}

