/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature.local.list;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import org.openimaj.feature.local.LocalFeature;
import org.openimaj.feature.local.list.LocalFeatureList;
import org.openimaj.feature.local.list.LocalFeatureListUtils;
import org.openimaj.feature.local.list.MemoryLocalFeatureList;
import org.openimaj.io.IOUtils;
import org.openimaj.util.list.AbstractFileBackedList;

public class FileLocalFeatureList<T extends LocalFeature<?, ?>>
extends AbstractFileBackedList<T>
implements LocalFeatureList<T>,
Cloneable {
    protected final int veclen;

    protected FileLocalFeatureList(int size, int veclen, boolean isBinary, int headerLength, int recordLength, File file, Class<T> clz) {
        super(size, isBinary, headerLength, recordLength, file, clz);
        this.veclen = veclen;
    }

    public static <T extends LocalFeature<?, ?>> FileLocalFeatureList<T> read(File keypointFile, Class<T> clz) throws IOException {
        boolean isBinary = IOUtils.isBinary(keypointFile, LocalFeatureList.BINARY_HEADER);
        int[] header = LocalFeatureListUtils.readHeader(keypointFile, isBinary);
        int size = header[0];
        int veclen = header[1];
        int headerLength = header[2];
        LocalFeature instance = (LocalFeature)LocalFeatureListUtils.newInstance(clz, veclen);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        instance.writeBinary(new DataOutputStream(buffer));
        int recordLength = buffer.toByteArray().length;
        return new FileLocalFeatureList<T>(size, veclen, isBinary, headerLength, recordLength, keypointFile, clz);
    }

    @Override
    public int vecLength() {
        return this.veclen;
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        LocalFeatureListUtils.writeBinary(out, this);
    }

    @Override
    public void writeASCII(PrintWriter out) throws IOException {
        LocalFeatureListUtils.writeASCII(out, this);
    }

    @Override
    public byte[] binaryHeader() {
        return LocalFeatureList.BINARY_HEADER;
    }

    @Override
    public String asciiHeader() {
        return "";
    }

    @Override
    public <Q> Q[] asDataArray(Q[] a) {
        if (a.length < this.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        }
        int i = 0;
        for (LocalFeature t : this) {
            a[i++] = t.getFeatureVector().getVector();
        }
        return a;
    }

    @Override
    protected AbstractFileBackedList<T> newInstance(int newSize, boolean isBinary, int newHeaderLength, int recordLength, File file) {
        return new FileLocalFeatureList<T>(newSize, this.veclen, isBinary, newHeaderLength, recordLength, file, this.clz);
    }

    @Override
    protected T newElementInstance() {
        return (T)((LocalFeature)LocalFeatureListUtils.newInstance(this.clz, this.veclen));
    }

    @Override
    public MemoryLocalFeatureList<T> subList(int fromIndex, int toIndex) {
        return new MemoryLocalFeatureList(super.subList(fromIndex, toIndex));
    }
}

