/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature.local.list;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openimaj.feature.local.LocalFeature;
import org.openimaj.feature.local.list.LocalFeatureList;
import org.openimaj.feature.local.list.MemoryLocalFeatureList;
import org.openimaj.feature.local.quantised.QuantisedLocalFeature;
import org.openimaj.io.ReadWriteable;
import org.openimaj.io.ReadWriteableBinary;

public class LocalFeatureListIndex<K extends ReadWriteable, V extends LocalFeature<?, ?>>
extends HashMap<K, LocalFeatureList<V>>
implements ReadWriteableBinary {
    private static final long serialVersionUID = 1L;
    public static final byte[] BINARY_HEADER = "LFLI".getBytes();
    protected Class<K> keyClass;
    protected Class<V> valueClass;

    @Override
    public void readBinary(DataInput in) throws IOException {
        try {
            String kclzstr = in.readUTF();
            String vclzstr = in.readUTF();
            Class<?> kclz = Class.forName(kclzstr);
            Class<?> vclz = Class.forName(vclzstr);
            if (this.keyClass != null && !this.keyClass.equals(kclz)) {
                throw new IOException("type mismatch");
            }
            if (this.valueClass != null && !this.valueClass.equals(vclz)) {
                throw new IOException("type mismatch");
            }
            this.keyClass = kclz;
            this.valueClass = vclz;
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                ReadWriteable key = (ReadWriteable)this.keyClass.newInstance();
                key.readBinary(in);
                MemoryLocalFeatureList<V> value = MemoryLocalFeatureList.readNoHeader(in, this.valueClass);
                this.put(key, value);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] binaryHeader() {
        return BINARY_HEADER;
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        if (this.keyClass == null) {
            if (!this.keySet().iterator().hasNext()) {
                throw new IOException("unable to guess type");
            }
            this.keyClass = ((ReadWriteable)this.keySet().iterator().next()).getClass();
        }
        if (this.valueClass == null) {
            if (!this.values().iterator().hasNext()) {
                throw new IOException("unable to guess type");
            }
            if (!((LocalFeatureList)this.values().iterator().next()).iterator().hasNext()) {
                throw new IOException("unable to guess type");
            }
            this.valueClass = ((LocalFeature)((LocalFeatureList)this.values().iterator().next()).iterator().next()).getClass();
        }
        out.writeUTF(this.keyClass.getCanonicalName());
        out.writeUTF(this.valueClass.getCanonicalName());
        out.writeInt(this.size());
        for (Map.Entry e : this.entrySet()) {
            ((ReadWriteable)e.getKey()).writeBinary(out);
            ((LocalFeatureList)e.getValue()).writeBinary(out);
        }
    }

    public static <K extends ReadWriteable, T extends QuantisedLocalFeature<?>> TIntObjectHashMap<TIntObjectHashMap<List<T>>> invert(LocalFeatureListIndex<K, T> index) {
        TIntObjectHashMap<TIntObjectHashMap<List<T>>> invertedIndex = new TIntObjectHashMap<TIntObjectHashMap<List<T>>>();
        for (Map.Entry e : index.entrySet()) {
            ReadWriteable docid = (ReadWriteable)e.getKey();
            for (QuantisedLocalFeature t : (LocalFeatureList)e.getValue()) {
                TIntObjectHashMap<List<T>> postings;
                int termid = t.id;
                if (!invertedIndex.containsKey(termid)) {
                    invertedIndex.put(termid, new TIntObjectHashMap());
                }
                if (!(postings = invertedIndex.get(termid)).containsKey(docid.hashCode())) {
                    postings.put(docid.hashCode(), new ArrayList());
                }
                postings.get(docid.hashCode()).add(t);
            }
        }
        return invertedIndex;
    }
}

