/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature.local.list;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.Scanner;
import org.openimaj.feature.local.LocalFeature;
import org.openimaj.feature.local.list.LocalFeatureList;
import org.openimaj.feature.local.list.MemoryLocalFeatureList;
import org.openimaj.io.VariableLength;

class LocalFeatureListUtils {
    LocalFeatureListUtils() {
    }

    protected static <T extends LocalFeature<?, ?>> void writeBinary(DataOutput out, LocalFeatureList<T> list) throws IOException {
        out.writeInt(list.size());
        out.writeInt(list.vecLength());
        for (LocalFeature k : list) {
            k.writeBinary(out);
        }
    }

    protected static <T extends LocalFeature<?, ?>> void writeASCII(PrintWriter out, LocalFeatureList<T> list) throws IOException {
        Locale def = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
        out.println(list.size() + " " + list.vecLength());
        for (LocalFeature k : list) {
            k.writeASCII(out);
        }
        Locale.setDefault(def);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T extends LocalFeature<?, ?>> void readBinary(File file, MemoryLocalFeatureList<T> memoryKeypointList, Class<T> clz) throws IOException {
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(file));
            LocalFeatureListUtils.readBinary(bis, memoryKeypointList, clz);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected static <T extends LocalFeature<?, ?>> void readBinary(BufferedInputStream bis, MemoryLocalFeatureList<T> memoryKeypointList, Class<T> clz) throws IOException {
        DataInputStream dis = null;
        dis = new DataInputStream(bis);
        dis.read(new byte[memoryKeypointList.binaryHeader().length]);
        int nItems = dis.readInt();
        int veclen = dis.readInt();
        memoryKeypointList.clear();
        memoryKeypointList.cached_veclen = veclen;
        for (int i = 0; i < nItems; ++i) {
            LocalFeature t = (LocalFeature)LocalFeatureListUtils.newInstance(clz, veclen);
            t.readBinary(dis);
            memoryKeypointList.add(t);
        }
    }

    protected static <T extends LocalFeature<?, ?>> void readBinary(DataInput in, MemoryLocalFeatureList<T> memoryKeypointList, Class<T> clz) throws IOException {
        int nItems = in.readInt();
        int veclen = in.readInt();
        memoryKeypointList.clear();
        memoryKeypointList.cached_veclen = veclen;
        for (int i = 0; i < nItems; ++i) {
            LocalFeature t = (LocalFeature)LocalFeatureListUtils.newInstance(clz, veclen);
            t.readBinary(in);
            memoryKeypointList.add(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T extends LocalFeature<?, ?>> void readASCII(File file, MemoryLocalFeatureList<T> memoryKeypointList, Class<T> clz) throws IOException {
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(file));
            LocalFeatureListUtils.readASCII(bis, memoryKeypointList, clz);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected static <T extends LocalFeature<?, ?>> void readASCII(BufferedInputStream bis, MemoryLocalFeatureList<T> memoryKeypointList, Class<T> clz) throws IOException {
        Scanner in = new Scanner(bis);
        String head = in.nextLine().trim();
        String[] h = head.split(" ");
        int nItems = Integer.decode(h[0]);
        int veclen = 0;
        veclen = h.length > 1 ? Integer.decode(h[1]).intValue() : Integer.decode(in.nextLine().trim()).intValue();
        memoryKeypointList.clear();
        memoryKeypointList.cached_veclen = veclen;
        for (int i = 0; i < nItems; ++i) {
            LocalFeature t = (LocalFeature)LocalFeatureListUtils.newInstance(clz, veclen);
            t.readASCII(in);
            memoryKeypointList.add(t);
        }
    }

    public static <T> T newInstance(Class<T> cls, int length) {
        try {
            if (VariableLength.class.isAssignableFrom(cls)) {
                return cls.getConstructor(Integer.TYPE).newInstance(length);
            }
            return cls.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int[] readHeader(File keypointFile, boolean isBinary) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(keypointFile);
            int[] nArray = LocalFeatureListUtils.readHeader(fis, isBinary, true);
            return nArray;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int[] readHeader(InputStream stream, boolean isBinary, boolean close) throws IOException {
        if (isBinary) {
            DataInputStream dis = null;
            try {
                dis = new DataInputStream(stream);
                for (int i = 0; i < LocalFeatureList.BINARY_HEADER.length; ++i) {
                    dis.readByte();
                }
                int nItems = dis.readInt();
                int veclen = dis.readInt();
                int[] nArray = new int[]{nItems, veclen, 8 + LocalFeatureList.BINARY_HEADER.length};
                return nArray;
            }
            finally {
                if (close && dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        InputStreamReader fr = null;
        BufferedReader br = null;
        int nlines = 1;
        boolean isBuffered = stream.markSupported();
        try {
            if (isBuffered) {
                stream.mark(1024);
            }
            fr = new InputStreamReader(stream);
            br = new BufferedReader(fr);
            String head = br.readLine().trim();
            if (isBuffered) {
                stream.reset();
            }
            String[] h = head.split(" ");
            int nItems = Integer.decode(h[0]);
            int veclen = 0;
            veclen = h.length > 1 ? Integer.decode(h[1]).intValue() : Integer.decode(br.readLine().trim()).intValue();
            int[] nArray = new int[]{nItems, veclen, ++nlines};
            return nArray;
        }
        finally {
            if (close && br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            if (close && fr != null) {
                try {
                    fr.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

