/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature.local.list;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.openimaj.data.RandomData;
import org.openimaj.feature.local.LocalFeature;
import org.openimaj.feature.local.Location;
import org.openimaj.feature.local.LocationFilter;
import org.openimaj.feature.local.list.LocalFeatureList;
import org.openimaj.feature.local.list.LocalFeatureListUtils;
import org.openimaj.io.IOUtils;

public class MemoryLocalFeatureList<T extends LocalFeature<?, ?>>
extends ArrayList<T>
implements LocalFeatureList<T> {
    private static final long serialVersionUID = 1L;
    protected int cached_veclen = -1;

    public MemoryLocalFeatureList() {
    }

    public MemoryLocalFeatureList(int veclen) {
        this.cached_veclen = veclen;
    }

    public MemoryLocalFeatureList(Collection<? extends T> c) {
        super(c);
        if (this.size() > 0) {
            this.cached_veclen = ((LocalFeature)this.get(0)).getFeatureVector().length();
        }
    }

    public MemoryLocalFeatureList(int veclen, int initialCapacity) {
        super(initialCapacity);
        this.cached_veclen = veclen;
    }

    public static <T extends LocalFeature<?, ?>> MemoryLocalFeatureList<T> read(File keypointFile, Class<T> clz) throws IOException {
        boolean isBinary = IOUtils.isBinary(keypointFile, LocalFeatureList.BINARY_HEADER);
        MemoryLocalFeatureList<T> list = new MemoryLocalFeatureList<T>();
        if (isBinary) {
            LocalFeatureListUtils.readBinary(keypointFile, list, clz);
        } else {
            LocalFeatureListUtils.readASCII(keypointFile, list, clz);
        }
        return list;
    }

    public static <T extends LocalFeature<?, ?>> MemoryLocalFeatureList<T> read(InputStream stream, Class<T> clz) throws IOException {
        return MemoryLocalFeatureList.read(new BufferedInputStream(stream), clz);
    }

    public static <T extends LocalFeature<?, ?>> MemoryLocalFeatureList<T> read(BufferedInputStream stream, Class<T> clz) throws IOException {
        boolean isBinary = IOUtils.isBinary(stream, LocalFeatureList.BINARY_HEADER);
        MemoryLocalFeatureList<T> list = new MemoryLocalFeatureList<T>();
        if (isBinary) {
            LocalFeatureListUtils.readBinary(stream, list, clz);
        } else {
            LocalFeatureListUtils.readASCII(stream, list, clz);
        }
        return list;
    }

    public static <T extends LocalFeature<?, ?>> MemoryLocalFeatureList<T> readNoHeader(DataInput in, Class<T> clz) throws IOException {
        MemoryLocalFeatureList<T> list = new MemoryLocalFeatureList<T>();
        LocalFeatureListUtils.readBinary(in, list, clz);
        return list;
    }

    @Override
    public <Q> Q[] asDataArray(Q[] a) {
        if (a.length < this.size()) {
            System.out.println(a.getClass());
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        }
        int i = 0;
        for (LocalFeature t : this) {
            a[i++] = t.getFeatureVector().getVector();
        }
        return a;
    }

    @Override
    public MemoryLocalFeatureList<T> randomSubList(int nelem) {
        MemoryLocalFeatureList<T> kl;
        if (nelem > this.size()) {
            kl = new MemoryLocalFeatureList<T>(this);
            Collections.shuffle(kl);
        } else {
            int[] rnds = RandomData.getUniqueRandomInts(nelem, 0, this.size());
            kl = new MemoryLocalFeatureList<T>(this.cached_veclen);
            for (int idx : rnds) {
                kl.add(this.get(idx));
            }
        }
        return kl;
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        this.resetVecLength();
        LocalFeatureListUtils.writeBinary(out, this);
    }

    @Override
    public void writeASCII(PrintWriter out) throws IOException {
        this.resetVecLength();
        LocalFeatureListUtils.writeASCII(out, this);
    }

    @Override
    public byte[] binaryHeader() {
        return LocalFeatureList.BINARY_HEADER;
    }

    @Override
    public String asciiHeader() {
        return "";
    }

    @Override
    public int vecLength() {
        this.resetVecLength();
        if (this.cached_veclen == -1 && this.size() > 0) {
            this.cached_veclen = ((LocalFeature)this.get(0)).getFeatureVector().length();
        }
        return this.cached_veclen;
    }

    public void resetVecLength() {
        if (this.size() > 0) {
            this.cached_veclen = ((LocalFeature)this.get(0)).getFeatureVector().length();
        }
    }

    public MemoryLocalFeatureList<T> filter(LocationFilter locationFilter) {
        MemoryLocalFeatureList<T> newlist = new MemoryLocalFeatureList<T>();
        for (LocalFeature t : this) {
            if (!locationFilter.accept((Location)t.getLocation())) continue;
            newlist.add(t);
        }
        return newlist;
    }

    @Override
    public MemoryLocalFeatureList<T> subList(int fromIndex, int toIndex) {
        return new MemoryLocalFeatureList(super.subList(fromIndex, toIndex));
    }
}

