/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature.local.list;

import java.io.BufferedInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import org.openimaj.feature.local.LocalFeature;
import org.openimaj.feature.local.list.LocalFeatureList;
import org.openimaj.feature.local.list.LocalFeatureListUtils;
import org.openimaj.feature.local.list.MemoryLocalFeatureList;
import org.openimaj.io.IOUtils;
import org.openimaj.util.list.AbstractStreamBackedList;

public class StreamLocalFeatureList<T extends LocalFeature<?, ?>>
extends AbstractStreamBackedList<T>
implements LocalFeatureList<T> {
    int veclen;

    protected StreamLocalFeatureList(InputStream stream, int size, boolean isBinary, int headerLength, int recordLength, int veclen, Class<T> clz) {
        super(stream, size, isBinary, headerLength, recordLength, clz);
        this.veclen = veclen;
    }

    public static <T extends LocalFeature<?, ?>> StreamLocalFeatureList<T> read(InputStream stream, Class<T> clz) throws IOException {
        return StreamLocalFeatureList.read(new BufferedInputStream(stream), clz);
    }

    public static <T extends LocalFeature<?, ?>> StreamLocalFeatureList<T> read(BufferedInputStream stream, Class<T> clz) throws IOException {
        boolean isBinary = IOUtils.isBinary(stream, LocalFeatureList.BINARY_HEADER);
        int[] header = LocalFeatureListUtils.readHeader(stream, isBinary, false);
        int size = header[0];
        int veclen = header[1];
        int headerLength = header[2];
        int recordLength = veclen + 16;
        return new StreamLocalFeatureList<T>((InputStream)stream, size, isBinary, headerLength, recordLength, veclen, clz);
    }

    @Override
    public <Q> Q[] asDataArray(Q[] a) {
        if (a.length < this.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        }
        int i = 0;
        for (LocalFeature t : this) {
            a[i++] = t.getFeatureVector().getVector();
        }
        return a;
    }

    @Override
    public int vecLength() {
        return this.veclen;
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        LocalFeatureListUtils.writeBinary(out, this);
    }

    @Override
    public void writeASCII(PrintWriter out) throws IOException {
        LocalFeatureListUtils.writeASCII(out, this);
    }

    @Override
    public byte[] binaryHeader() {
        return LocalFeatureList.BINARY_HEADER;
    }

    @Override
    public String asciiHeader() {
        return "";
    }

    @Override
    protected T newElementInstance() {
        return (T)((LocalFeature)LocalFeatureListUtils.newInstance(this.clz, this.veclen));
    }

    @Override
    public MemoryLocalFeatureList<T> subList(int fromIndex, int toIndex) {
        return new MemoryLocalFeatureList(super.subList(fromIndex, toIndex));
    }
}

