/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.processor.connectedcomponent.render.BlobRenderer;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.Polygon;

public class DisplayUtilities {
    private static int windowCount = 0;
    private static int windowOpenCount = 0;
    private static Map<String, JFrame> namedWindows = new HashMap<String, JFrame>();

    public static int openWindowCount() {
        return windowOpenCount;
    }

    public static JFrame display(Image<?, ?> image) {
        return DisplayUtilities.display(image, "Image: " + windowCount);
    }

    public static JFrame display(BufferedImage image) {
        return DisplayUtilities.display(image, "Image: " + windowCount);
    }

    public static JFrame display(Image<?, ?> image, String title) {
        return DisplayUtilities.display(ImageUtilities.createBufferedImageForDisplay(image), title, image);
    }

    public static JFrame displaySimple(Image<?, ?> image) {
        return DisplayUtilities.displaySimple(image, "Image: " + windowCount);
    }

    public static JFrame displaySimple(BufferedImage image) {
        return DisplayUtilities.displaySimple(image, "Image: " + windowCount);
    }

    public static JFrame displaySimple(Image<?, ?> image, String title) {
        return DisplayUtilities.displaySimple(ImageUtilities.createBufferedImageForDisplay(image), title, image);
    }

    private static BufferedImage getImage(JFrame frame) {
        if (frame == null) {
            return null;
        }
        if (frame.getContentPane().getComponentCount() > 0 && frame.getContentPane().getComponent(0) instanceof ImageComponent) {
            return ((ImageComponent)frame.getContentPane().getComponent((int)0)).image;
        }
        return null;
    }

    public static JFrame display(Image<?, ?> image, JFrame frame) {
        BufferedImage bimg = DisplayUtilities.getImage(frame);
        return DisplayUtilities.display(ImageUtilities.createBufferedImageForDisplay(image, bimg), frame);
    }

    public static void positionNamed(String name, int x, int y) {
        JFrame w = DisplayUtilities.createNamedWindow(name);
        w.setBounds(x, y, w.getWidth(), w.getHeight());
    }

    public static void updateNamed(String name, Image<?, ?> newImage, String title) {
        JFrame w = DisplayUtilities.createNamedWindow(name, title, true);
        BufferedImage bimg = DisplayUtilities.getImage(w);
        ((ImageComponent)w.getContentPane().getComponent(0)).setImage(ImageUtilities.createBufferedImageForDisplay(newImage, bimg));
    }

    public static JFrame createNamedWindow(String name) {
        return DisplayUtilities.createNamedWindow(name, name, false);
    }

    public static JFrame createNamedWindow(String name, String title) {
        return DisplayUtilities.createNamedWindow(name, title, false);
    }

    public static JFrame createNamedWindow(String name, String title, boolean autoResize) {
        if (namedWindows.containsKey(name)) {
            return namedWindows.get(name);
        }
        JFrame frame = DisplayUtilities.makeDisplayFrame(title, 0, 0, null);
        ((ImageComponent)frame.getContentPane().getComponent(0)).autoResize = autoResize;
        ((ImageComponent)frame.getContentPane().getComponent(0)).autoPack = autoResize;
        namedWindows.put(name, frame);
        return frame;
    }

    public static JFrame displayName(Image<?, ?> image, String name) {
        JFrame frame = DisplayUtilities.createNamedWindow(name);
        BufferedImage bimg = DisplayUtilities.getImage(frame);
        return DisplayUtilities.display(ImageUtilities.createBufferedImageForDisplay(image, bimg), frame, image);
    }

    public static JFrame displayName(Image<?, ?> image, String name, boolean autoResize) {
        JFrame frame = DisplayUtilities.createNamedWindow(name, name, autoResize);
        BufferedImage bimg = DisplayUtilities.getImage(frame);
        return DisplayUtilities.display(ImageUtilities.createBufferedImageForDisplay(image, bimg), frame, image);
    }

    public static JFrame display(BufferedImage image, JFrame frame) {
        return DisplayUtilities.display(image, frame, null);
    }

    public static JFrame displayName(BufferedImage image, String name) {
        JFrame f = DisplayUtilities.createNamedWindow(name);
        return DisplayUtilities.display(image, f);
    }

    public static JFrame display(BufferedImage image, JFrame frame, Image<?, ?> originalImage) {
        if (frame == null) {
            return DisplayUtilities.makeDisplayFrame("Image: " + windowCount, image.getWidth(), image.getHeight(), image);
        }
        if (frame.getContentPane().getComponentCount() > 0 && frame.getContentPane().getComponent(0) instanceof ImageComponent) {
            ImageComponent cmp = (ImageComponent)frame.getContentPane().getComponent(0);
            if (!frame.isVisible()) {
                boolean ar = cmp.autoResize;
                boolean ap = cmp.autoPack;
                cmp.autoResize = true;
                cmp.autoPack = true;
                cmp.setImage(image);
                cmp.setOriginalImage(originalImage);
                cmp.autoResize = ar;
                cmp.autoPack = ap;
                frame.setVisible(true);
            } else {
                cmp.setImage(image);
                cmp.setOriginalImage(originalImage);
            }
        } else {
            frame.getContentPane().removeAll();
            ImageComponent c = new ImageComponent(image);
            c.setOriginalImage(originalImage);
            frame.add(c);
            frame.pack();
            frame.setVisible(true);
        }
        return frame;
    }

    public static JFrame makeFrame(String title) {
        final JFrame f = new JFrame(title);
        f.setResizable(false);
        f.setUndecorated(false);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                windowOpenCount = windowCount - 1;
                f.dispose();
            }
        });
        return f;
    }

    public static JFrame displaySimple(BufferedImage image, String title) {
        return DisplayUtilities.displaySimple(image, title, null);
    }

    public static JFrame display(BufferedImage image, String title) {
        return DisplayUtilities.display(image, title, null);
    }

    public static JFrame displaySimple(BufferedImage image, String title, Image<?, ?> originalImage) {
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        return DisplayUtilities.makeDisplayFrameSimple(title, image.getWidth(), image.getHeight(), image, originalImage);
    }

    public static JFrame makeDisplayFrameSimple(String title, int width, int height, BufferedImage img, Image<?, ?> originalImage) {
        JFrame f = DisplayUtilities.makeFrame(title);
        ImageComponent c = new ImageComponent();
        if (img != null) {
            c.setImage(img);
        }
        c.setOriginalImage(originalImage);
        c.setSize(width, height);
        c.setPreferredSize(new Dimension(c.getWidth(), c.getHeight()));
        c.removeMouseListener(c);
        c.removeMouseMotionListener(c);
        c.setShowPixelColours(false);
        c.setShowXYPosition(false);
        c.setAllowZoom(false);
        c.setAutoscrolls(false);
        c.setAllowPanning(false);
        f.add(c);
        f.pack();
        f.setVisible(img != null);
        ++windowCount;
        return f;
    }

    public static JFrame display(BufferedImage image, String title, Image<?, ?> originalImage) {
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        return DisplayUtilities.makeDisplayFrame(title, image.getWidth(), image.getHeight(), image, originalImage);
    }

    public static JFrame makeDisplayFrame(String title, int width, int height) {
        return DisplayUtilities.makeDisplayFrame(title, width, height, null);
    }

    public static JFrame makeDisplayFrame(String title, int width, int height, BufferedImage img) {
        return DisplayUtilities.makeDisplayFrame(title, width, height, img, null);
    }

    public static JFrame makeDisplayFrame(String title, int width, int height, BufferedImage img, Image<?, ?> originalImage) {
        JFrame f = DisplayUtilities.makeFrame(title);
        ImageComponent c = new ImageComponent();
        if (img != null) {
            c.setImage(img);
        }
        c.setOriginalImage(originalImage);
        c.setSize(width, height);
        c.setPreferredSize(new Dimension(c.getWidth(), c.getHeight()));
        f.add(c);
        f.pack();
        f.setVisible(img != null);
        ++windowCount;
        return f;
    }

    public static JFrame display(ConnectedComponent input) {
        return DisplayUtilities.display(input, 1.0f);
    }

    public static JFrame display(ConnectedComponent input, float col) {
        ConnectedComponent cc = input.clone();
        org.openimaj.math.geometry.shape.Rectangle bb = cc.calculateRegularBoundingBox();
        cc.translate(10 - (int)bb.x, 10 - (int)bb.y);
        FImage mask = new FImage((int)Math.max(bb.width + 20.0f, 100.0f), (int)Math.max(bb.height + 20.0f, 100.0f));
        BlobRenderer<Float> br = new BlobRenderer<Float>(mask, Float.valueOf(1.0f));
        cc.process(br);
        return DisplayUtilities.display(mask);
    }

    public static JFrame display(Polygon input) {
        return DisplayUtilities.display(input, 1.0f);
    }

    public static JFrame display(Polygon input, float col) {
        Polygon p = input.clone();
        org.openimaj.math.geometry.shape.Rectangle bb = p.calculateRegularBoundingBox();
        p.translate(10.0f - bb.x, 10.0f - bb.y);
        FImage mask = new FImage((int)(bb.width + 20.0f), (int)(bb.height + 20.0f));
        mask.createRenderer().drawPolygon(p, Float.valueOf(col));
        return DisplayUtilities.display(mask);
    }

    public static JFrame display(String title, Image<?, ?> ... images) {
        BufferedImage[] bimages = new BufferedImage[images.length];
        for (int i = 0; i < images.length; ++i) {
            bimages[i] = ImageUtilities.createBufferedImageForDisplay(images[i]);
        }
        return DisplayUtilities.display(title, bimages);
    }

    public static JFrame display(String title, Collection<? extends Image<?, ?>> images) {
        BufferedImage[] bimages = new BufferedImage[images.size()];
        int i = 0;
        for (Image<?, ?> img : images) {
            bimages[i++] = ImageUtilities.createBufferedImageForDisplay(img);
        }
        return DisplayUtilities.display(title, bimages);
    }

    public static JFrame display(String title, int cols, Image<?, ?> ... images) {
        JFrame f = new JFrame(title);
        f.getContentPane().setLayout(new GridLayout(0, cols));
        for (Image<?, ?> image : images) {
            if (image == null) continue;
            ImageComponent ic = new ImageComponent(ImageUtilities.createBufferedImageForDisplay(image));
            ic.setOriginalImage(image);
            f.getContentPane().add(ic);
        }
        f.pack();
        f.setVisible(true);
        return f;
    }

    public static JFrame displayLinked(String title, int cols, Image<?, ?> ... images) {
        JFrame f = new JFrame(title);
        f.getContentPane().setLayout(new GridLayout(0, cols));
        ImageComponent ic = null;
        for (Image<?, ?> image : images) {
            if (image == null) continue;
            final ImageComponent ic2 = new ImageComponent(ImageUtilities.createBufferedImageForDisplay(image));
            if (ic != null) {
                ic.addImageComponentListener(new ImageComponent.ImageComponentListener(){

                    @Override
                    public void imageZoomed(double newScaleFactor) {
                        ic2.zoom(newScaleFactor);
                    }

                    @Override
                    public void imagePanned(double newX, double newY) {
                        ic2.moveTo(newX, newY);
                    }
                });
            }
            ic2.setOriginalImage(image);
            f.getContentPane().add(ic2);
            ic = ic2;
        }
        f.pack();
        f.setVisible(true);
        return f;
    }

    public static JFrame display(String title, BufferedImage ... images) {
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        final JFrame f = new JFrame(title);
        int box_size = 200;
        int n_images = images.length;
        int n_boxes_x = 4;
        int width = 800;
        int height = 200 * n_images / 4;
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                windowOpenCount = windowCount - 1;
                f.dispose();
            }
        });
        Container scrollContainer = new Container();
        scrollContainer.setLayout(new FlowLayout());
        Container container = new Container();
        container.setSize(new Dimension(800, height));
        container.setPreferredSize(new Dimension(800, height));
        container.setLayout(new GridLayout(0, 4));
        scrollContainer.add(container);
        for (final BufferedImage img : images) {
            JComponent c = new JComponent(){
                private static final long serialVersionUID = 1L;

                @Override
                public void paint(Graphics g) {
                    int cw = this.getWidth();
                    int ch = this.getHeight();
                    if (img.getWidth() < cw && img.getHeight() < ch) {
                        int x = (cw - img.getWidth()) / 2;
                        int y = (ch - img.getHeight()) / 2;
                        g.drawImage(img, x, y, img.getWidth(), img.getHeight(), f);
                    } else if (img.getWidth() > img.getHeight()) {
                        float sf = (float)cw / (float)img.getWidth();
                        int h = Math.round(sf * (float)img.getHeight());
                        g.drawImage(img, 0, (ch - h) / 2, cw, h, f);
                    } else {
                        float sf = (float)ch / (float)img.getHeight();
                        int w = Math.round(sf * (float)img.getWidth());
                        g.drawImage(img, (cw - w) / 2, 0, w, ch, f);
                    }
                }
            };
            c.setSize(200, 200);
            c.setPreferredSize(new Dimension(c.getWidth(), c.getHeight()));
            container.add(c);
        }
        f.setSize(new Dimension(840, 600));
        f.setPreferredSize(new Dimension(840, 600));
        f.getContentPane().add(new JScrollPane(scrollContainer));
        f.pack();
        f.setVisible(true);
        ++windowCount;
        return f;
    }

    public static class ScalingImageComponent
    extends ImageComponent {
        private static final long serialVersionUID = 1L;
        private boolean hq = false;

        public ScalingImageComponent() {
        }

        public ScalingImageComponent(boolean hq) {
            this.hq = hq;
        }

        @Override
        public void paint(Graphics g) {
            if (this.hq) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            Component f = SwingUtilities.getRoot(this);
            if (this.image != null) {
                g.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), f);
            }
        }
    }

    public static class ImageComponent
    extends JComponent
    implements MouseListener,
    MouseMotionListener {
        private static final long serialVersionUID = 1L;
        protected BufferedImage image;
        protected Image<?, ?> originalImage;
        private boolean autoResize = false;
        private boolean autoPack = false;
        private boolean autoFit = false;
        private boolean keepAspect = true;
        private boolean drawTransparencyGrid = false;
        private boolean drawPixelColour = false;
        private boolean showPixelColours = true;
        private boolean showXY = true;
        private boolean allowZooming = true;
        private boolean allowDragging = true;
        private double drawX = 0.0;
        private double drawY = 0.0;
        private double scaleFactorX = 1.0;
        private double scaleFactorY = 1.0;
        private int dragStartX = 0;
        private int dragStartY = 0;
        private int pixelX = 0;
        private int pixelY = 0;
        private int mouseX = 0;
        private int mouseY = 0;
        private Float[] currentPixelColour = null;
        private final ArrayList<ImageComponentListener> listeners = new ArrayList();
        private BufferedImage displayedImage = null;

        public ImageComponent() {
            this(false, false);
        }

        public ImageComponent(boolean autoResize) {
            this(autoResize, true);
        }

        public ImageComponent(BufferedImage image) {
            this(true, true);
            this.setImage(image);
        }

        public ImageComponent(boolean autoResize, boolean autoPack) {
            this(1.0f, autoResize, autoPack);
        }

        public ImageComponent(float initialScale, boolean autoResize, boolean autoPack) {
            this.autoPack = autoPack;
            this.autoResize = autoResize;
            this.scaleFactorX = initialScale;
            this.scaleFactorY = initialScale;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    ImageComponent.this.calculateScaleFactorsToFit(ImageComponent.this.image, ImageComponent.this.getBounds());
                }
            });
        }

        public void addImageComponentListener(ImageComponentListener l) {
            this.listeners.add(l);
        }

        public void removeImageComponentListener(ImageComponentListener l) {
            this.listeners.remove(l);
        }

        public void setAllowZoom(boolean allowZoom) {
            this.allowZooming = allowZoom;
            if (allowZoom) {
                this.autoFit = false;
            }
        }

        public void setAllowPanning(boolean allowPan) {
            this.allowDragging = allowPan;
            if (allowPan) {
                this.autoFit = false;
            }
        }

        public void setTransparencyGrid(boolean drawGrid) {
            this.drawTransparencyGrid = drawGrid;
            this.repaint();
        }

        public void setShowPixelColours(boolean showPixelColours) {
            this.showPixelColours = showPixelColours;
            this.repaint();
        }

        public void setShowXYPosition(boolean showXYPosition) {
            this.showXY = showXYPosition;
            this.repaint();
        }

        public void setImage(BufferedImage image) {
            this.image = image;
            if (this.autoFit) {
                this.calculateScaleFactorsToFit(image, this.getBounds());
            } else if (this.autoResize) {
                Component c;
                if (image.getWidth() != this.getWidth() || image.getHeight() != this.getHeight()) {
                    this.setPreferredSize(new Dimension((int)((double)image.getWidth() * this.scaleFactorX), (int)((double)image.getHeight() * this.scaleFactorY)));
                    this.setSize(new Dimension((int)((double)image.getWidth() * this.scaleFactorX), (int)((double)image.getHeight() * this.scaleFactorY)));
                }
                if ((c = SwingUtilities.getRoot(this)) == null) {
                    return;
                }
                c.validate();
                if (c instanceof JFrame && this.autoPack) {
                    JFrame f = (JFrame)c;
                    f.pack();
                }
            }
            if (this.showPixelColours) {
                this.updatePixelColours();
            } else {
                this.repaint();
            }
        }

        private void calculateScaleFactorsToFit(BufferedImage image, Rectangle bounds) {
            if (image == null || bounds == null) {
                return;
            }
            if (this.autoFit) {
                if (!this.keepAspect) {
                    this.scaleFactorX = (double)bounds.width / (double)image.getWidth();
                    this.scaleFactorY = (double)bounds.height / (double)image.getHeight();
                } else {
                    this.scaleFactorX = this.scaleFactorY = Math.min((double)bounds.width / (double)image.getWidth(), (double)bounds.height / (double)image.getHeight());
                }
            }
        }

        public void moveTo(double x, double y) {
            if (this.drawX != x || this.drawY != y) {
                this.drawX = x;
                this.drawY = y;
                this.repaint();
                for (ImageComponentListener l : this.listeners) {
                    l.imagePanned(x, y);
                }
            }
        }

        public void zoom(double sf) {
            this.scaleFactorX = this.scaleFactorY = sf;
            this.repaint();
            for (ImageComponentListener l : this.listeners) {
                l.imageZoomed(sf);
            }
        }

        public void setScaleFactorX(double sf) {
            this.scaleFactorX = sf;
        }

        public void setScaleFactorY(double sf) {
            this.scaleFactorY = sf;
        }

        public void setScaleFactor(double sfx, double sfy) {
            this.setScaleFactorX(sfx);
            this.setScaleFactorY(sfy);
        }

        public void setOriginalImage(Image<?, ?> image) {
            this.originalImage = image;
        }

        private void sanitiseVars() {
        }

        @Override
        public void paint(Graphics gfx) {
            BufferedImage img = new BufferedImage(this.getWidth(), this.getHeight(), 5);
            Graphics2D g = (Graphics2D)img.getGraphics();
            if (this.drawTransparencyGrid) {
                BufferedImage transparencyGrid = new BufferedImage(this.getWidth(), this.getHeight(), 5);
                Graphics tg = transparencyGrid.getGraphics();
                int gridSizeX = (int)(20.0 * this.scaleFactorX);
                int gridSizeY = (int)(20.0 * this.scaleFactorY);
                for (int y = 0; y < this.getHeight(); y += gridSizeY) {
                    for (int x = 0; x < this.getWidth(); x += gridSizeX) {
                        int c = (x / gridSizeX + y / gridSizeY) % 2;
                        if (c == 0) {
                            tg.setColor(new Color(220, 220, 220));
                        } else {
                            tg.setColor(Color.white);
                        }
                        tg.fillRect(x, y, gridSizeX, gridSizeY);
                    }
                }
                g.drawImage((java.awt.Image)transparencyGrid, 0, 0, null);
            }
            if (this.image != null) {
                g.scale(this.scaleFactorX, this.scaleFactorY);
                g.translate(-this.drawX, -this.drawY);
                g.drawImage(this.image, 0, 0, this.image.getWidth(), this.image.getHeight(), null);
                g.translate(this.drawX, this.drawY);
                g.scale(1.0 / this.scaleFactorX, 1.0 / this.scaleFactorY);
                if ((this.showPixelColours || this.showXY) && this.drawPixelColour) {
                    StringBuffer pixelColourStrB = new StringBuffer();
                    if (this.showXY) {
                        pixelColourStrB.append("[" + this.pixelX + "," + this.pixelY + "] ");
                    }
                    if (this.showPixelColours) {
                        pixelColourStrB.append(Arrays.toString((Object[])this.currentPixelColour));
                    }
                    FontMetrics fm = g.getFontMetrics();
                    int fw = fm.stringWidth(pixelColourStrB.toString());
                    int fh = fm.getHeight() + fm.getDescent();
                    int p = 4;
                    boolean dx = false;
                    int dy = this.getHeight() - (fh + 4);
                    if (this.mouseX <= 0 + fw + 4 && this.mouseX >= 0 && this.mouseY >= dy && this.mouseY <= dy + fh + 4) {
                        dy = 0;
                    }
                    g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.5f));
                    g.fillRect(0, dy, fw + 4, fh + 4);
                    g.setColor(Color.white);
                    g.drawString(pixelColourStrB.toString(), 2, dy + fm.getHeight() + 2);
                }
            }
            gfx.drawImage(img, 0, 0, null);
            this.displayedImage = img;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && this.allowZooming) {
                if (e.isControlDown()) {
                    this.scaleFactorX /= 2.0;
                    this.scaleFactorY /= 2.0;
                    double moveX = this.drawX - (double)e.getX() / this.scaleFactorX / 2.0;
                    double moveY = this.drawY - (double)e.getY() / this.scaleFactorY / 2.0;
                    if (this.allowDragging) {
                        this.moveTo(moveX, moveY);
                    } else {
                        this.moveTo(0.0, 0.0);
                    }
                } else {
                    this.scaleFactorX *= 2.0;
                    this.scaleFactorY *= 2.0;
                    if (this.allowDragging) {
                        this.moveTo(this.drawX + (double)e.getX() / this.scaleFactorX, this.drawY + (double)e.getY() / this.scaleFactorY);
                    } else {
                        this.moveTo(0.0, 0.0);
                    }
                }
                this.sanitiseVars();
                this.repaint();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.allowDragging) {
                this.dragStartX = e.getX();
                this.dragStartY = e.getY();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.drawPixelColour = false;
            this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.allowDragging) {
                return;
            }
            int diffx = e.getX() - this.dragStartX;
            int diffy = e.getY() - this.dragStartY;
            if (diffx == 0 && diffy == 0) {
                return;
            }
            this.moveTo(this.drawX - (double)diffx / this.scaleFactorX, this.drawY - (double)diffy / this.scaleFactorY);
            this.dragStartX = e.getX();
            this.dragStartY = e.getY();
            this.sanitiseVars();
            this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.image == null) {
                return;
            }
            double x = (double)e.getX() / this.scaleFactorX + this.drawX;
            double y = (double)e.getY() / this.scaleFactorY + this.drawY;
            if (x >= (double)this.image.getWidth() || y >= (double)this.image.getHeight() || x < 0.0 || y < 0.0) {
                this.drawPixelColour = false;
                this.repaint();
                return;
            }
            this.pixelX = (int)x;
            this.pixelY = (int)y;
            this.mouseX = e.getX();
            this.mouseY = e.getY();
            this.updatePixelColours();
        }

        protected void updatePixelColours() {
            if (this.showPixelColours && this.image != null) {
                if (this.originalImage == null) {
                    int colour = this.image.getRGB(this.pixelX, this.pixelY);
                    this.currentPixelColour = new Float[3];
                    this.currentPixelColour[0] = Float.valueOf((colour & 0xFF0000) >> 16);
                    this.currentPixelColour[1] = Float.valueOf((colour & 0xFF00) >> 8);
                    this.currentPixelColour[2] = Float.valueOf(colour & 0xFF);
                } else {
                    if (this.pixelX >= this.originalImage.getWidth() || this.pixelX < 0 || this.pixelY >= this.originalImage.getHeight() || this.pixelY < 0) {
                        return;
                    }
                    if (this.originalImage instanceof FImage) {
                        Object o = this.originalImage.getPixel(this.pixelX, this.pixelY);
                        this.currentPixelColour = new Float[1];
                        this.currentPixelColour[0] = (Float)o;
                    } else if (this.originalImage instanceof MBFImage) {
                        MBFImage i = (MBFImage)this.originalImage;
                        this.currentPixelColour = new Float[i.numBands()];
                        for (int b = 0; b < i.numBands(); ++b) {
                            this.currentPixelColour[b] = ((FImage)i.getBand(b)).getPixel(this.pixelX, this.pixelY);
                        }
                    }
                }
                this.drawPixelColour = true;
                this.repaint();
            }
            if (this.showXY) {
                this.drawPixelColour = true;
                this.repaint();
            }
        }

        public void setAutoFit(boolean tf) {
            this.autoFit = tf;
            if (this.autoFit) {
                this.allowZooming = false;
                this.allowDragging = false;
            }
        }

        public void setKeepAspect(boolean tf) {
            this.keepAspect = tf;
        }

        public void setAutoResize(boolean tf) {
            this.autoResize = tf;
        }

        public void setAutoPack(boolean tf) {
            this.autoPack = tf;
        }

        public Point2d getCurrentMousePosition() {
            return new Point2dImpl(this.mouseX, this.mouseY);
        }

        public Point2d getCurrentMouseImagePosition() {
            return new Point2dImpl(this.pixelX, this.pixelY);
        }

        public Float[] getCurrentPixelColour() {
            return this.currentPixelColour;
        }

        public int getCurrentDisplayedPixelColour() {
            return this.displayedImage.getRGB(this.mouseX, this.mouseY);
        }

        public BufferedImage getDisplayedImage() {
            return this.displayedImage;
        }

        public static interface ImageComponentListener {
            public void imageZoomed(double var1);

            public void imagePanned(double var1, double var3);
        }
    }
}

