/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.SingleBandImage;
import org.openimaj.image.colour.ColourSpace;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.image.processor.SinglebandKernelProcessor;
import org.openimaj.image.processor.SinglebandPixelProcessor;
import org.openimaj.math.geometry.shape.Rectangle;

public abstract class MultiBandImage<T extends Comparable<T>, I extends MultiBandImage<T, I, S>, S extends SingleBandImage<T, S>>
extends Image<T[], I>
implements Iterable<S>,
SinglebandImageProcessor.Processable<T, S, I>,
SinglebandKernelProcessor.Processable<T, S, I> {
    private static final long serialVersionUID = 1L;
    public List<S> bands;
    public ColourSpace colourSpace = ColourSpace.CUSTOM;

    public MultiBandImage() {
        this.bands = new ArrayList<S>();
    }

    public MultiBandImage(ColourSpace colourSpace) {
        this();
        this.colourSpace = colourSpace;
    }

    @SafeVarargs
    public MultiBandImage(ColourSpace colourSpace, S ... images) {
        this(colourSpace);
        if (!ImageUtilities.checkSameSize(images)) {
            throw new IllegalArgumentException("images are not the same size");
        }
        this.bands.addAll(Arrays.asList(images));
    }

    @Override
    public I abs() {
        for (SingleBandImage i : this.bands) {
            i.abs();
        }
        return (I)this;
    }

    @Override
    public I add(T num) {
        Image newImage = this.clone();
        ((MultiBandImage)newImage).addInplace(num);
        return (I)newImage;
    }

    public void addBand(S img) {
        if (this.bands.size() > 0 && !ImageUtilities.checkSize(this.getHeight(), this.getWidth(), new Image[]{img})) {
            throw new IllegalArgumentException("images are not the same size");
        }
        this.bands.add(img);
    }

    @Override
    public I addInplace(Image<?, ?> im) {
        if (im instanceof MultiBandImage) {
            return this.addInplace((T)((MultiBandImage)im));
        }
        if (im instanceof SingleBandImage) {
            return this.addInplace((T)((SingleBandImage)im));
        }
        throw new UnsupportedOperationException("Unsupported Type");
    }

    @Override
    public I addInplace(MultiBandImage<?, ?, ?> im) {
        assert (ImageUtilities.checkSameSize(this, im));
        int np = this.bands.size();
        for (int i = 0; i < np; ++i) {
            ((SingleBandImage)this.bands.get(i)).addInplace((Image)im.bands.get(i));
        }
        return (I)this;
    }

    @Override
    public I addInplace(SingleBandImage<?, ?> im) {
        assert (ImageUtilities.checkSameSize(this, im));
        int np = this.bands.size();
        for (int i = 0; i < np; ++i) {
            ((SingleBandImage)this.bands.get(i)).addInplace(im);
        }
        return (I)this;
    }

    @Override
    public I addInplace(T num) {
        for (SingleBandImage sbi : this) {
            sbi.addInplace(num);
        }
        return (I)this;
    }

    @Override
    public I addInplace(T[] num) {
        int np = this.bands.size();
        assert (num.length == np);
        for (int i = 0; i < np; ++i) {
            ((SingleBandImage)this.bands.get(i)).addInplace(num[i]);
        }
        return (I)this;
    }

    @Override
    public I clip(T min, T max) {
        for (SingleBandImage sbi : this) {
            sbi.clip(min, max);
        }
        return (I)this;
    }

    @Override
    public I clip(T[] min, T[] max) {
        int np = this.bands.size();
        assert (min.length == np);
        assert (max.length == np);
        for (int i = 0; i < np; ++i) {
            ((SingleBandImage)this.bands.get(i)).clip(min[i], max[i]);
        }
        return (I)this;
    }

    @Override
    public I clipMax(T thresh) {
        for (SingleBandImage sbm : this) {
            sbm.clipMax(thresh);
        }
        return (I)this;
    }

    @Override
    public I clipMax(T[] thresh) {
        int np = this.bands.size();
        assert (thresh.length == np);
        for (int i = 0; i < np; ++i) {
            ((SingleBandImage)this.bands.get(i)).clipMax(thresh[i]);
        }
        return (I)this;
    }

    @Override
    public I clipMin(T thresh) {
        for (SingleBandImage sbm : this) {
            sbm.clipMin(thresh);
        }
        return (I)this;
    }

    @Override
    public I clipMin(T[] thresh) {
        int np = this.bands.size();
        assert (thresh.length == np);
        for (int i = 0; i < np; ++i) {
            ((SingleBandImage)this.bands.get(i)).clipMin(thresh[i]);
        }
        return (I)this;
    }

    @Override
    public I clone() {
        I newImage = this.newInstance();
        for (SingleBandImage sbi : this) {
            ((MultiBandImage)newImage).bands.add(sbi.clone());
        }
        ((MultiBandImage)newImage).colourSpace = this.colourSpace;
        return newImage;
    }

    public void deleteBand(int index) {
        this.bands.remove(index);
    }

    @Override
    public I divide(T val) {
        Image newImage = this.clone();
        ((MultiBandImage)newImage).divideInplace(val);
        return (I)newImage;
    }

    @Override
    public I divideInplace(Image<?, ?> im) {
        if (im instanceof MultiBandImage) {
            return this.divideInplace((T)((MultiBandImage)im));
        }
        if (im instanceof SingleBandImage) {
            return this.divideInplace((T)((SingleBandImage)im));
        }
        throw new UnsupportedOperationException("Unsupported Type");
    }

    @Override
    public I divideInplace(MultiBandImage<?, ?, ?> im) {
        assert (ImageUtilities.checkSameSize(this, im));
        int np = this.bands.size();
        for (int i = 0; i < np; ++i) {
            ((SingleBandImage)this.bands.get(i)).divideInplace((Image)im.bands.get(i));
        }
        return (I)this;
    }

    @Override
    public I divideInplace(SingleBandImage<?, ?> im) {
        assert (ImageUtilities.checkSameSize(this, im));
        int np = this.bands.size();
        for (int i = 0; i < np; ++i) {
            ((SingleBandImage)this.bands.get(i)).divideInplace(im);
        }
        return (I)this;
    }

    @Override
    public I divideInplace(T val) {
        for (SingleBandImage sbm : this) {
            sbm.divideInplace(val);
        }
        return (I)this;
    }

    @Override
    public I divideInplace(T[] val) {
        int np = this.bands.size();
        assert (val.length == np);
        for (int i = 0; i < np; ++i) {
            ((SingleBandImage)this.bands.get(i)).divideInplace(val[i]);
        }
        return (I)this;
    }

    @Override
    public I extractROI(int x, int y, I out) {
        for (int i = 0; i < this.bands.size(); ++i) {
            SingleBandImage img = (SingleBandImage)this.bands.get(i);
            img.extractROI(x, y, (Image)((MultiBandImage)out).bands.get(i));
        }
        return out;
    }

    @Override
    public I extractROI(int x, int y, int w, int h) {
        I newImage = this.newInstance();
        for (SingleBandImage sbm : this) {
            ((MultiBandImage)newImage).addBand((SingleBandImage)((SingleBandImage)sbm.extractROI(x, y, w, h)));
        }
        return newImage;
    }

    @Override
    public I fill(T[] colour) {
        for (int b = 0; b < this.bands.size(); ++b) {
            ((SingleBandImage)this.bands.get(b)).fill(colour[b]);
        }
        return (I)this;
    }

    public S flatten() {
        if (this.bands.size() == 1) {
            return (S)((SingleBandImage)this.bands.get(0)).clone();
        }
        S out = this.newBandInstance(this.getWidth(), this.getHeight());
        for (SingleBandImage sbm : this) {
            ((Image)out).addInplace((SingleBandImage)sbm);
        }
        return (S)((SingleBandImage)((Image)out).divideInplace(this.intToT(this.numBands())));
    }

    public abstract S flattenMax();

    public S getBand(int i) {
        return (S)((SingleBandImage)this.bands.get(i));
    }

    public ColourSpace getColourSpace() {
        return this.colourSpace;
    }

    @Override
    public Rectangle getContentArea() {
        int minx = this.getWidth();
        int maxx = 0;
        int miny = this.getHeight();
        int maxy = 0;
        for (int i = 0; i < this.numBands(); ++i) {
            Rectangle box = ((Image)this.getBand(i)).getContentArea();
            if (box.minX() < (double)minx) {
                minx = (int)box.minX();
            }
            if (box.maxX() > (double)maxx) {
                maxx = (int)box.maxX();
            }
            if (box.minY() < (double)miny) {
                miny = (int)box.minY();
            }
            if (!(box.maxY() > (double)maxy)) continue;
            maxy = (int)box.maxY();
        }
        return new Rectangle(minx, miny, maxx - minx, maxy - miny);
    }

    @Override
    public I getField(Image.Field f) {
        I newImage = this.newInstance();
        for (SingleBandImage sbm : this) {
            ((MultiBandImage)newImage).bands.add(sbm.getField(f));
        }
        return newImage;
    }

    @Override
    public I getFieldCopy(Image.Field f) {
        I newImage = this.newInstance();
        for (SingleBandImage sbm : this) {
            ((MultiBandImage)newImage).bands.add(sbm.getFieldCopy(f));
        }
        return newImage;
    }

    @Override
    public I getFieldInterpolate(Image.Field f) {
        I newImage = this.newInstance();
        for (SingleBandImage sbm : this) {
            ((MultiBandImage)newImage).bands.add(sbm.getFieldInterpolate(f));
        }
        return newImage;
    }

    @Override
    public int getHeight() {
        if (this.bands.size() > 0) {
            return ((SingleBandImage)this.bands.get(0)).getHeight();
        }
        return 0;
    }

    @Override
    public int getWidth() {
        if (this.bands.size() > 0) {
            return ((SingleBandImage)this.bands.get(0)).getWidth();
        }
        return 0;
    }

    @Override
    public I internalCopy(I im) {
        int nb = this.bands.size();
        for (int i = 0; i < nb; ++i) {
            ((SingleBandImage)this.bands.get(i)).internalCopy(((MultiBandImage)im).getBand(i));
        }
        return (I)this;
    }

    @Override
    public I internalAssign(I im) {
        this.bands = ((MultiBandImage)im).bands;
        return (I)this;
    }

    protected abstract T intToT(int var1);

    @Override
    public I inverse() {
        for (SingleBandImage sbm : this) {
            sbm.inverse();
        }
        return (I)this;
    }

    @Override
    public Iterator<S> iterator() {
        return this.bands.iterator();
    }

    @Override
    public T[] max() {
        ArrayList pixels = new ArrayList();
        for (SingleBandImage sbm : this) {
            pixels.add(sbm.max());
        }
        return pixels.toArray(this.createPixelArray(this.numBands()));
    }

    @Override
    public T[] min() {
        ArrayList pixels = new ArrayList();
        for (SingleBandImage sbm : this) {
            pixels.add(sbm.min());
        }
        return pixels.toArray(this.createPixelArray(this.numBands()));
    }

    protected abstract T[] createPixelArray(int var1);

    @Override
    public I multiply(T num) {
        Image newImage = this.clone();
        ((MultiBandImage)newImage).multiplyInplace(num);
        return (I)newImage;
    }

    @Override
    public I multiplyInplace(Image<?, ?> im) {
        if (im instanceof MultiBandImage) {
            return this.multiplyInplace((T)((MultiBandImage)im));
        }
        if (im instanceof SingleBandImage) {
            return this.multiplyInplace((T)((SingleBandImage)im));
        }
        throw new UnsupportedOperationException("Unsupported Type");
    }

    @Override
    public I multiplyInplace(MultiBandImage<?, ?, ?> im) {
        assert (ImageUtilities.checkSameSize(this, im));
        int np = this.bands.size();
        for (int i = 0; i < np; ++i) {
            ((SingleBandImage)this.bands.get(i)).multiplyInplace((Image)im.bands.get(i));
        }
        return (I)this;
    }

    @Override
    public I multiplyInplace(SingleBandImage<?, ?> im) {
        assert (ImageUtilities.checkSameSize(this, im));
        int np = this.bands.size();
        for (int i = 0; i < np; ++i) {
            ((SingleBandImage)this.bands.get(i)).multiplyInplace(im);
        }
        return (I)this;
    }

    @Override
    public I multiplyInplace(T num) {
        for (SingleBandImage sbm : this) {
            sbm.multiplyInplace(num);
        }
        return (I)this;
    }

    @Override
    public I multiplyInplace(T[] num) {
        int np = this.bands.size();
        assert (num.length == np);
        for (int i = 0; i < np; ++i) {
            ((SingleBandImage)this.bands.get(i)).multiplyInplace(num[i]);
        }
        return (I)this;
    }

    public abstract S newBandInstance(int var1, int var2);

    public abstract I newInstance();

    @Override
    public abstract I newInstance(int var1, int var2);

    @Override
    public I normalise() {
        for (SingleBandImage sbm : this) {
            sbm.normalise();
        }
        return (I)this;
    }

    public int numBands() {
        return this.bands.size();
    }

    @Override
    public I process(SinglebandImageProcessor<T, S> p) {
        I out = this.newInstance();
        for (SingleBandImage sbm : this) {
            ((MultiBandImage)out).bands.add(sbm.process((SinglebandImageProcessor)p));
        }
        return out;
    }

    @Override
    public I process(SinglebandKernelProcessor<T, S> kernel) {
        return (I)this.process((SinglebandKernelProcessor)kernel, false);
    }

    @Override
    public I process(SinglebandKernelProcessor<T, S> kernel, boolean pad) {
        I out = this.newInstance();
        for (SingleBandImage sbm : this) {
            ((MultiBandImage)out).bands.add(sbm.process((SinglebandKernelProcessor)kernel, pad));
        }
        return out;
    }

    @Override
    public I process(SinglebandPixelProcessor<T> pp) {
        I out = this.newInstance();
        for (SingleBandImage sbm : this) {
            ((MultiBandImage)out).bands.add(sbm.process(pp));
        }
        return out;
    }

    @Override
    public I processInplace(SinglebandImageProcessor<T, S> p) {
        for (SingleBandImage sbm : this) {
            sbm.processInplace((SinglebandImageProcessor)p);
        }
        return (I)this;
    }

    @Override
    public I processInplace(SinglebandKernelProcessor<T, S> kernel) {
        return (I)this.processInplace((SinglebandKernelProcessor)kernel, false);
    }

    @Override
    public I processInplace(SinglebandKernelProcessor<T, S> kernel, boolean pad) {
        for (SingleBandImage sbm : this) {
            sbm.processInplace((SinglebandKernelProcessor)kernel, pad);
        }
        return (I)this;
    }

    @Override
    public I processInplace(SinglebandPixelProcessor<T> pp) {
        for (SingleBandImage sbm : this) {
            sbm.processInplace(pp);
        }
        return (I)this;
    }

    @Override
    public void setPixel(int x, int y, T[] val) {
        int np = this.bands.size();
        if (np == val.length) {
            for (int i = 0; i < np; ++i) {
                ((SingleBandImage)this.bands.get(i)).setPixel(x, y, val[i]);
            }
        } else {
            int offset = val.length - np;
            for (int i = 0; i < np; ++i) {
                if (i + offset < 0) continue;
                ((SingleBandImage)this.bands.get(i)).setPixel(x, y, val[i + offset]);
            }
        }
    }

    @Override
    public I subtract(T num) {
        Image newImage = this.clone();
        ((MultiBandImage)newImage).subtractInplace(num);
        return (I)newImage;
    }

    @Override
    public I subtractInplace(Image<?, ?> im) {
        if (im instanceof MultiBandImage) {
            return this.subtractInplace((T)((MultiBandImage)im));
        }
        if (im instanceof SingleBandImage) {
            return this.subtractInplace((T)((SingleBandImage)im));
        }
        throw new UnsupportedOperationException("Unsupported Type");
    }

    @Override
    public I subtractInplace(MultiBandImage<?, ?, ?> im) {
        assert (ImageUtilities.checkSameSize(this, im));
        int np = this.bands.size();
        for (int i = 0; i < np; ++i) {
            ((SingleBandImage)this.bands.get(i)).subtractInplace((Image)im.bands.get(i));
        }
        return (I)this;
    }

    @Override
    public I subtractInplace(SingleBandImage<?, ?> im) {
        assert (ImageUtilities.checkSameSize(this, im));
        int np = this.bands.size();
        for (int i = 0; i < np; ++i) {
            ((SingleBandImage)this.bands.get(i)).subtractInplace(im);
        }
        return (I)this;
    }

    @Override
    public I subtractInplace(T num) {
        for (SingleBandImage sbm : this) {
            sbm.subtractInplace(num);
        }
        return (I)this;
    }

    @Override
    public I subtractInplace(T[] num) {
        int np = this.bands.size();
        assert (num.length == np);
        for (int i = 0; i < np; ++i) {
            ((SingleBandImage)this.bands.get(i)).subtractInplace(num[i]);
        }
        return (I)this;
    }

    @Override
    public I threshold(T thresh) {
        for (SingleBandImage sbm : this) {
            sbm.threshold(thresh);
        }
        return (I)this;
    }

    @Override
    public I threshold(T[] thresh) {
        int np = this.bands.size();
        assert (thresh.length == np);
        for (int i = 0; i < np; ++i) {
            ((SingleBandImage)this.bands.get(i)).threshold(thresh[i]);
        }
        return (I)this;
    }

    @Override
    public byte[] toByteImage() {
        int width = this.getWidth();
        int height = this.getHeight();
        int nb = this.bands.size();
        byte[] ppmData = new byte[nb * height * width];
        for (int n = 0; n < nb; ++n) {
            byte[] band = ((SingleBandImage)this.bands.get(n)).toByteImage();
            for (int j = 0; j < height; ++j) {
                for (int i = 0; i < width; ++i) {
                    ppmData[nb * (i + j * width) + n] = band[i + j * width];
                }
            }
        }
        return ppmData;
    }

    @Override
    public int[] toPackedARGBPixels() {
        if (this.bands.size() == 1) {
            return ((SingleBandImage)this.bands.get(0)).toPackedARGBPixels();
        }
        if (this.bands.size() == 3) {
            int width = this.getWidth();
            int height = this.getHeight();
            byte[] rp = ((SingleBandImage)this.bands.get(0)).toByteImage();
            byte[] gp = ((SingleBandImage)this.bands.get(1)).toByteImage();
            byte[] bp = ((SingleBandImage)this.bands.get(2)).toByteImage();
            int[] data = new int[height * width];
            for (int r = 0; r < height; ++r) {
                for (int c = 0; c < width; ++c) {
                    int rgb;
                    int red = rp[c + r * width] & 0xFF;
                    int green = gp[c + r * width] & 0xFF;
                    int blue = bp[c + r * width] & 0xFF;
                    data[c + r * width] = rgb = 0xFF000000 | red << 16 | green << 8 | blue;
                }
            }
            return data;
        }
        if (this.bands.size() == 4) {
            int width = this.getWidth();
            int height = this.getHeight();
            byte[] ap = ((SingleBandImage)this.bands.get(3)).toByteImage();
            byte[] rp = ((SingleBandImage)this.bands.get(0)).toByteImage();
            byte[] gp = ((SingleBandImage)this.bands.get(1)).toByteImage();
            byte[] bp = ((SingleBandImage)this.bands.get(2)).toByteImage();
            int[] data = new int[height * width];
            for (int r = 0; r < height; ++r) {
                for (int c = 0; c < width; ++c) {
                    int argb;
                    int alpha = ap[c + r * width] & 0xFF;
                    int red = rp[c + r * width] & 0xFF;
                    int green = gp[c + r * width] & 0xFF;
                    int blue = bp[c + r * width] & 0xFF;
                    data[c + r * width] = argb = alpha << 24 | red << 16 | green << 8 | blue;
                }
            }
            return data;
        }
        throw new UnsupportedOperationException("Unable to create bufferedImage with " + this.numBands() + " bands");
    }

    @Override
    public I zero() {
        for (SingleBandImage sbm : this) {
            sbm.zero();
        }
        return (I)this;
    }

    @Override
    public I shiftLeftInplace(int count) {
        for (SingleBandImage b : this.bands) {
            b.shiftLeftInplace(count);
        }
        return (I)this;
    }

    @Override
    public I shiftRightInplace(int count) {
        for (SingleBandImage b : this.bands) {
            b.shiftRightInplace(count);
        }
        return (I)this;
    }

    @Override
    public I flipX() {
        for (SingleBandImage b : this.bands) {
            b.flipX();
        }
        return (I)this;
    }

    @Override
    public I flipY() {
        for (SingleBandImage b : this.bands) {
            b.flipY();
        }
        return (I)this;
    }

    public boolean equals(Object other) {
        MultiBandImage that = (MultiBandImage)other;
        if (this.bands.size() != that.bands.size()) {
            return false;
        }
        int i = 0;
        for (SingleBandImage b : this.bands) {
            boolean fail;
            boolean bl = fail = !b.equals(that.getBand(i));
            if (fail) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public I replace(T[] target, T[] replacement) {
        for (int b = 0; b < this.bands.size(); ++b) {
            ((SingleBandImage)this.bands.get(b)).replace(target[b], replacement[b]);
        }
        return (I)this;
    }

    @Override
    public I extractCentreSubPix(float cx, float cy, I out) {
        for (int b = 0; b < this.bands.size(); ++b) {
            ((SingleBandImage)this.bands.get(b)).extractCentreSubPix(cx, cy, (Image)((MultiBandImage)out).bands.get(b));
        }
        return out;
    }
}

