/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.algorithm;

import java.io.File;
import java.io.IOException;
import org.openimaj.image.DisplayUtilities;
import org.openimaj.image.FImage;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.analyser.ImageAnalyser;

public class EuclideanDistanceTransform
implements ImageAnalyser<FImage> {
    FImage distances;
    int[][] indices;

    @Override
    public void analyseImage(FImage image) {
        if (this.distances == null || this.distances.height != image.height || this.distances.width != this.distances.height) {
            this.distances = new FImage(image.width, image.height);
            this.indices = new int[image.height][image.width];
        }
        EuclideanDistanceTransform.squaredEuclideanDistance(image, this.distances, this.indices);
    }

    public FImage getDistances() {
        return this.distances;
    }

    public int[][] getIndices() {
        return this.indices;
    }

    protected static void DT1D(float[] f, float[] d, int[] v, int[] l, float[] z) {
        int k = 0;
        v[0] = 0;
        z[0] = -3.4028235E38f;
        z[1] = Float.MAX_VALUE;
        int q = 1;
        while (q < f.length) {
            float s = (f[q] + (float)(q * q) - (f[v[k]] + (float)(v[k] * v[k]))) / (float)(2 * q - 2 * v[k]);
            while (s <= z[k]) {
                s = (f[q] + (float)(q * q) - (f[v[--k]] + (float)(v[k] * v[k]))) / (float)(2 * q - 2 * v[k]);
            }
            v[++k] = q++;
            z[k] = s;
            z[k + 1] = Float.MAX_VALUE;
        }
        k = 0;
        for (q = 0; q < f.length; ++q) {
            while (z[k + 1] < (float)q) {
                ++k;
            }
            d[q] = (float)((q - v[k]) * (q - v[k])) + f[v[k]];
            l[q] = v[k];
        }
    }

    public static void squaredEuclideanDistanceBinary(FImage image, FImage distances, int[][] indices) {
        float[] f = new float[Math.max(image.height, image.width)];
        float[] d = new float[f.length];
        int[] v = new int[f.length];
        int[] l = new int[f.length];
        float[] z = new float[f.length + 1];
        for (int x = 0; x < image.width; ++x) {
            int y;
            for (y = 0; y < image.height; ++y) {
                f[y] = image.pixels[y][x] == 0.0f ? Float.MAX_VALUE : 0.0f;
            }
            EuclideanDistanceTransform.DT1D(f, d, v, l, z);
            for (y = 0; y < image.height; ++y) {
                distances.pixels[y][x] = d[y];
                indices[y][x] = l[y] * image.width + x;
            }
        }
        for (int y = 0; y < image.height; ++y) {
            int x;
            EuclideanDistanceTransform.DT1D(distances.pixels[y], d, v, l, z);
            for (x = 0; x < image.width; ++x) {
                l[x] = indices[y][l[x]];
            }
            for (x = 0; x < image.width; ++x) {
                distances.pixels[y][x] = d[x];
                indices[y][x] = l[x];
            }
        }
    }

    public static void squaredEuclideanDistance(FImage image, FImage distances, int[][] indices) {
        float[] f = new float[Math.max(image.height, image.width)];
        float[] d = new float[f.length];
        int[] v = new int[f.length];
        int[] l = new int[f.length];
        float[] z = new float[f.length + 1];
        for (int x = 0; x < image.width; ++x) {
            int y;
            for (y = 0; y < image.height; ++y) {
                f[y] = Float.isInfinite(image.pixels[y][x]) ? (image.pixels[y][x] > 0.0f ? Float.MAX_VALUE : -3.4028235E38f) : image.pixels[y][x];
            }
            EuclideanDistanceTransform.DT1D(f, d, v, l, z);
            for (y = 0; y < image.height; ++y) {
                distances.pixels[y][x] = d[y];
                indices[y][x] = l[y] * image.width + x;
            }
        }
        for (int y = 0; y < image.height; ++y) {
            int x;
            EuclideanDistanceTransform.DT1D(distances.pixels[y], d, v, l, z);
            for (x = 0; x < image.width; ++x) {
                l[x] = indices[y][l[x]];
            }
            for (x = 0; x < image.width; ++x) {
                distances.pixels[y][x] = d[x];
                indices[y][x] = l[x];
            }
        }
    }

    public static void main(String[] args) throws IOException {
        FImage i = ImageUtilities.readF(new File("/Users/ss/Desktop/tache.jpg"));
        EuclideanDistanceTransform etrans = new EuclideanDistanceTransform();
        i.inverse();
        for (int x = 0; x < i.width; ++x) {
            for (int y = 0; y < i.height; ++y) {
                if (i.pixels[y][x] != 1.0f) continue;
                i.setPixel(x, y, Float.valueOf(Float.MAX_VALUE));
            }
        }
        DisplayUtilities.display(i);
        i.analyseWith(etrans);
        i = etrans.getDistances();
        i.normalise();
        DisplayUtilities.display(i);
    }
}

