/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.algorithm;

import gnu.trove.map.hash.TIntFloatHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntFloatProcedure;
import gnu.trove.procedure.TIntObjectProcedure;
import java.util.List;
import org.apache.log4j.Logger;
import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.math.geometry.shape.Circle;
import org.openimaj.util.queue.BoundedPriorityQueue;

public class HoughCircles
implements ImageAnalyser<FImage> {
    Logger logger = Logger.getLogger(HoughCircles.class);
    protected int minRad;
    protected int maxRad;
    protected TIntObjectHashMap<TIntObjectHashMap<TIntFloatHashMap>> radmap;
    private float[][] cosanglemap;
    private float[][] sinanglemap;
    private int nRadius;
    private int nDegree;
    private int radIncr;

    public HoughCircles(int minRad, int maxRad, int radIncrement, int nDegree) {
        this.minRad = minRad;
        if (this.minRad <= 0) {
            this.minRad = 1;
        }
        this.maxRad = maxRad;
        this.radmap = new TIntObjectHashMap();
        this.radIncr = radIncrement;
        this.nRadius = (maxRad - minRad) / this.radIncr;
        this.nDegree = nDegree;
        this.cosanglemap = new float[this.nRadius][nDegree];
        this.sinanglemap = new float[this.nRadius][nDegree];
        for (int radIndex = 0; radIndex < this.nRadius; ++radIndex) {
            for (int angIndex = 0; angIndex < nDegree; ++angIndex) {
                double ang = (double)angIndex * (Math.PI * 2 / (double)nDegree);
                double rad = minRad + radIndex * this.radIncr;
                this.cosanglemap[radIndex][angIndex] = (float)(rad * Math.cos(ang));
                this.sinanglemap[radIndex][angIndex] = (float)(rad * Math.sin(ang));
            }
        }
    }

    @Override
    public void analyseImage(FImage image) {
        int height = image.getHeight();
        int width = image.getWidth();
        this.radmap = new TIntObjectHashMap();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (image.pixels[y][x] != 1.0f) continue;
                for (int rad = 0; rad < this.nRadius; ++rad) {
                    int actualrad = rad * this.radIncr + this.minRad;
                    float radiusWeight = 1.0f / (float)this.nDegree;
                    for (int ang = 0; ang < this.nDegree; ++ang) {
                        TIntFloatHashMap yMap;
                        int x0 = Math.round((float)x + this.cosanglemap[rad][ang]);
                        int y0 = Math.round((float)y + this.sinanglemap[rad][ang]);
                        TIntObjectHashMap<TIntFloatHashMap> xMap = this.radmap.get(actualrad);
                        if (xMap == null) {
                            xMap = new TIntObjectHashMap();
                            this.radmap.put(actualrad, xMap);
                        }
                        if ((yMap = xMap.get(x0)) == null) {
                            yMap = new TIntFloatHashMap();
                            xMap.put(x0, yMap);
                        }
                        yMap.adjustOrPutValue(y0, radiusWeight, radiusWeight);
                    }
                }
            }
        }
        this.logger.debug("Done analysing the image!");
    }

    public List<WeightedCircle> getBest(int n) {
        final BoundedPriorityQueue bpq = new BoundedPriorityQueue(n);
        this.radmap.forEachEntry(new TIntObjectProcedure<TIntObjectHashMap<TIntFloatHashMap>>(){

            @Override
            public boolean execute(final int radius, TIntObjectHashMap<TIntFloatHashMap> b) {
                b.forEachEntry(new TIntObjectProcedure<TIntFloatHashMap>(){

                    @Override
                    public boolean execute(final int x, TIntFloatHashMap b) {
                        b.forEachEntry(new TIntFloatProcedure(){

                            @Override
                            public boolean execute(int y, float weightedCount) {
                                bpq.offer(new WeightedCircle(x, y, radius, weightedCount));
                                return true;
                            }
                        });
                        return true;
                    }
                });
                return true;
            }
        });
        return bpq.toOrderedList();
    }

    public static class WeightedCircle
    extends Circle
    implements Comparable<WeightedCircle> {
        public float weight;

        public WeightedCircle(float x, float y, float radius, float weight) {
            super(x, y, radius);
            this.weight = weight;
        }

        @Override
        public int compareTo(WeightedCircle o) {
            return Float.compare(o.weight, this.weight);
        }
    }
}

