/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.algorithm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.pixel.FValuePixel;
import org.openimaj.math.geometry.line.Line2d;
import org.openimaj.math.geometry.point.Point2dImpl;

public class HoughLines
implements ImageAnalyser<FImage>,
Iterable<Line2d>,
Iterator<Line2d> {
    private FImage accum = null;
    private int numberOfSegments = 360;
    private FImage iteratorAccum = null;
    private FValuePixel iteratorCurrentPix = null;
    private float onValue;

    public HoughLines() {
        this(360, 0.0f);
    }

    public HoughLines(float onValue) {
        this(360, onValue);
    }

    public HoughLines(int nSegments, float onValue) {
        this.setNumberOfSegments(nSegments);
        this.onValue = onValue;
    }

    @Override
    public void analyseImage(FImage image) {
        int amax = (int)Math.round(Math.sqrt(image.getHeight() * image.getHeight() + image.getWidth() * image.getWidth()));
        if (this.accum == null || this.accum.height != amax || this.accum.width != this.getNumberOfSegments()) {
            this.accum = new FImage(this.getNumberOfSegments(), amax);
        } else {
            this.accum.zero();
        }
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                if (image.getPixel(x, y).floatValue() != this.onValue) continue;
                for (int m = 0; m < this.getNumberOfSegments(); ++m) {
                    double mm = (double)m / (double)this.getNumberOfSegments() * (Math.PI * 2);
                    int a = (int)Math.round((double)x * Math.cos(mm) + (double)y * Math.sin(mm));
                    if (a >= amax || a < 0) continue;
                    float[] fArray = this.accum.pixels[a];
                    int n = m;
                    fArray[n] = fArray[n] + 1.0f;
                }
            }
        }
    }

    public FImage getAccumulator() {
        return this.accum;
    }

    public FImage calculateHorizontalProjection() {
        return this.calculateHorizontalProjection(this.accum);
    }

    public FImage calculateHorizontalProjection(FImage accum) {
        FImage proj = new FImage(accum.getWidth(), 1);
        for (int x = 0; x < accum.getWidth(); ++x) {
            float acc = 0.0f;
            for (int y = 0; y < accum.getHeight(); ++y) {
                acc += accum.getPixel(x, y).floatValue() * accum.getPixel(x, y).floatValue();
            }
            proj.setPixel(x, 0, Float.valueOf((float)Math.sqrt(acc)));
        }
        return proj;
    }

    public double calculatePrevailingAngle() {
        return this.calculatePrevailingAngle(this.accum, 0, 360.0);
    }

    public double calculatePrevailingAngle(FImage accum, int offset, double nDegrees) {
        FValuePixel maxpix = this.calculateHorizontalProjection(accum).maxPixel();
        if (maxpix.x == -1 && maxpix.y == -1) {
            return Double.MIN_VALUE;
        }
        return (double)(maxpix.x + offset) * (nDegrees / (double)accum.getWidth());
    }

    public double calculatePrevailingAngle(float minTheta, float maxTheta) {
        if (minTheta > maxTheta) {
            float tmp = minTheta;
            minTheta = maxTheta;
            maxTheta = tmp;
        }
        if (minTheta >= 0.0f) {
            int mt = (int)((double)minTheta / (360.0 / (double)this.getNumberOfSegments()));
            int xt = (int)((double)maxTheta / (360.0 / (double)this.getNumberOfSegments()));
            FImage f = this.accum.extractROI(mt, 0, xt - mt, this.accum.getHeight());
            return this.calculatePrevailingAngle(f, mt, (double)(xt - mt) * (360.0 / (double)this.getNumberOfSegments()));
        }
        int mt = (int)((double)minTheta / (360.0 / (double)this.getNumberOfSegments()));
        int xt = (int)((double)maxTheta / (360.0 / (double)this.getNumberOfSegments()));
        FImage a = ((FImage)this.accum.shiftRight(-mt)).extractROI(0, 0, xt - mt, this.accum.getHeight());
        return this.calculatePrevailingAngle(a, mt, (double)(xt - mt) * (360.0 / (double)this.getNumberOfSegments()));
    }

    public Line2d getBestLine() {
        return this.getBestLine(this.accum, 0);
    }

    public Line2d getBestLine(FImage accumulatorSpace, int offset) {
        FValuePixel p = accumulatorSpace.maxPixel();
        int theta = p.x + offset;
        int dist = p.y;
        return this.getLineFromParams(theta, dist, -2000, 2000);
    }

    public Line2d getBestLine(float minTheta, float maxTheta) {
        if (minTheta > maxTheta) {
            float tmp = minTheta;
            minTheta = maxTheta;
            maxTheta = tmp;
        }
        if (minTheta >= 0.0f) {
            int mt = (int)((double)minTheta / (360.0 / (double)this.getNumberOfSegments()));
            int xt = (int)((double)maxTheta / (360.0 / (double)this.getNumberOfSegments()));
            FImage f = this.accum.extractROI(mt, 0, xt - mt, this.accum.getHeight());
            return this.getBestLine(f, mt);
        }
        int mt = (int)((double)minTheta / (360.0 / (double)this.getNumberOfSegments()));
        int xt = (int)((double)maxTheta / (360.0 / (double)this.getNumberOfSegments()));
        FImage a = ((FImage)this.accum.shiftRight(-mt)).extractROI(0, 0, xt - mt, this.accum.getHeight());
        return this.getBestLine(a, mt);
    }

    public List<Line2d> getBestLines(int n, float minTheta, float maxTheta) {
        if (minTheta > maxTheta) {
            float tmp = minTheta;
            minTheta = maxTheta;
            maxTheta = tmp;
        }
        if (minTheta >= 0.0f) {
            int mt = (int)((double)minTheta / (360.0 / (double)this.getNumberOfSegments()));
            int xt = (int)((double)maxTheta / (360.0 / (double)this.getNumberOfSegments()));
            FImage f = this.accum.extractROI(mt, 0, xt - mt, this.accum.getHeight());
            return this.getBestLines(n, f, mt);
        }
        int mt = (int)((double)minTheta / (360.0 / (double)this.getNumberOfSegments()));
        int xt = (int)((double)maxTheta / (360.0 / (double)this.getNumberOfSegments()));
        FImage a = ((FImage)this.accum.shiftRight(-mt)).extractROI(0, 0, xt - mt, this.accum.getHeight());
        return this.getBestLines(n, a, mt);
    }

    public List<Line2d> getBestLines(int n) {
        return this.getBestLines(n, this.accum, 0);
    }

    public List<Line2d> getBestLines(int n, FImage accumulatorSpace, int offset) {
        FImage accum2 = accumulatorSpace.clone();
        ArrayList<Line2d> lines = new ArrayList<Line2d>();
        for (int i = 0; i < n; ++i) {
            FValuePixel p = accum2.maxPixel();
            lines.add(this.getLineFromParams(p.x + offset, p.y, -2000, 2000));
            accum2.setPixel(p.x, p.y, Float.valueOf(0.0f));
        }
        return lines;
    }

    public Line2d getLineFromParams(int theta, int dist, int x1, int x2) {
        if (theta == 0) {
            return new Line2d(new Point2dImpl(dist, -2000.0f), new Point2dImpl(dist, 2000.0f));
        }
        double t = (double)theta * (360.0 / (double)this.getNumberOfSegments()) * Math.PI / 180.0;
        return new Line2d(new Point2dImpl(x1, (float)((double)x1 * (-Math.cos(t) / Math.sin(t)) + (double)dist / Math.sin(t))), new Point2dImpl(x2, (float)((double)x2 * (-Math.cos(t) / Math.sin(t)) + (double)dist / Math.sin(t))));
    }

    @Override
    public Iterator<Line2d> iterator() {
        this.clearIterator();
        this.checkIteratorSetup();
        return this;
    }

    private void checkIteratorSetup() {
        if (this.iteratorAccum == null) {
            this.iteratorAccum = this.accum.clone();
        }
    }

    @Override
    public boolean hasNext() {
        return this.iteratorAccum.maxPixel().value > 0.0f;
    }

    @Override
    public Line2d next() {
        this.iteratorCurrentPix = this.iteratorAccum.maxPixel();
        Line2d l = this.getBestLine(this.iteratorAccum, 0);
        this.iteratorAccum.setPixel(this.iteratorCurrentPix.x, this.iteratorCurrentPix.y, Float.valueOf(0.0f));
        return l;
    }

    @Override
    public void remove() {
        this.iteratorAccum.setPixel(this.iteratorCurrentPix.x, this.iteratorCurrentPix.y, Float.valueOf(0.0f));
    }

    public void clearIterator() {
        this.iteratorAccum = null;
        this.iteratorCurrentPix = null;
    }

    public void setNumberOfSegments(int numberOfSegments) {
        this.numberOfSegments = numberOfSegments;
    }

    public int getNumberOfSegments() {
        return this.numberOfSegments;
    }
}

