/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.algorithm;

import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.math.util.Interpolation;

public class ImageInterpolation
implements ImageAnalyser<FImage> {
    protected Interpolator interpolator;
    protected Object workingSpace;
    protected FImage image;

    public ImageInterpolation(Interpolator interpolator) {
        this.interpolator = interpolator;
        this.workingSpace = interpolator.createWorkingSpace();
    }

    @Override
    public void analyseImage(FImage image) {
        this.image = image;
    }

    public float getPixelInterpolated(float x, float y) {
        return this.interpolator.interpolate(x, y, this.image, this.workingSpace);
    }

    public static enum InterpolationType implements Interpolator
    {
        NEAREST_NEIGHBOUR{

            @Override
            public float interpolate(float x, float y, FImage image, Object workingSpace) {
                x = Math.round(x);
                y = Math.round(y);
                if (x < 0.0f || x >= (float)image.width || y < 0.0f || y >= (float)image.height) {
                    return 0.0f;
                }
                return image.pixels[(int)y][(int)x];
            }

            @Override
            public Object createWorkingSpace() {
                return null;
            }
        }
        ,
        BILINEAR{

            @Override
            public float interpolate(float x, float y, FImage image, Object workingSpace) {
                return image.getPixelInterpNative(x, y, 0.0f);
            }

            @Override
            public Object createWorkingSpace() {
                return null;
            }
        }
        ,
        BICUBIC{

            @Override
            public float interpolate(float x, float y, FImage image, Object workingSpace) {
                float[][] working = (float[][])workingSpace;
                int sx = (int)Math.floor(x) - 1;
                int sy = (int)Math.floor(y) - 1;
                int ex = sx + 3;
                int ey = sy + 3;
                int yy = sy;
                int i = 0;
                while (yy <= ey) {
                    int xx = sx;
                    int j = 0;
                    while (xx <= ex) {
                        int px;
                        int n = xx < 0 ? 0 : (px = xx >= image.width ? image.width - 1 : xx);
                        int py = yy < 0 ? 0 : (yy >= image.height ? image.height - 1 : yy);
                        working[i][j] = image.pixels[py][px];
                        ++xx;
                        ++j;
                    }
                    ++yy;
                    ++i;
                }
                float dx = (float)((double)x - Math.floor(x));
                float dy = (float)((double)y - Math.floor(y));
                return Interpolation.bicubicInterp(dx, dy, working);
            }

            @Override
            public Object createWorkingSpace() {
                return new float[4][4];
            }
        };

    }

    public static interface Interpolator {
        public float interpolate(float var1, float var2, FImage var3, Object var4);

        public Object createWorkingSpace();
    }
}

