/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.algorithm;

import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import org.openimaj.image.DisplayUtilities;
import org.openimaj.image.FImage;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.colour.RGBColour;
import org.openimaj.image.pixel.FValuePixel;
import org.openimaj.image.processing.algorithm.MeanCenter;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.util.queue.BoundedPriorityQueue;

public class TemplateMatcher
implements ImageAnalyser<FImage> {
    private FImage template;
    private Mode mode;
    private Object workingSpace;
    private Rectangle searchBounds;
    private FImage responseMap;

    public TemplateMatcher(FImage template, Mode mode) {
        this.mode = mode;
        this.template = mode.prepareTemplate(template);
        this.workingSpace = mode.prepareWorkingSpace(this.template);
    }

    public TemplateMatcher(FImage template, Mode mode, Rectangle bounds) {
        this.searchBounds = bounds;
        this.mode = mode;
        this.template = mode.prepareTemplate(template);
        this.workingSpace = mode.prepareWorkingSpace(this.template);
    }

    public Rectangle getSearchBounds() {
        return this.searchBounds;
    }

    public void setSearchBounds(Rectangle searchBounds) {
        this.searchBounds = searchBounds;
    }

    @Override
    public void analyseImage(FImage image) {
        Rectangle searchSpace = null;
        if (this.searchBounds != null) {
            int halfWidth = this.template.width / 2;
            int halfHeight = this.template.height / 2;
            float x = Math.max(this.searchBounds.x - (float)halfWidth, 0.0f);
            x = Math.min(x, (float)(image.width - this.template.width));
            float width = this.searchBounds.width;
            if (this.searchBounds.x - (float)halfWidth < 0.0f) {
                width += this.searchBounds.x - (float)halfWidth;
            }
            if (x + width > (float)(image.width - this.template.width)) {
                width += (float)(image.width - this.template.width) - (x + width);
            }
            float y = Math.max(this.searchBounds.y - (float)halfHeight, 0.0f);
            y = Math.min(y, (float)(image.height - this.template.height));
            float height = this.searchBounds.height;
            if (this.searchBounds.y - (float)halfHeight < 0.0f) {
                height += this.searchBounds.y - (float)halfHeight;
            }
            if (y + height > (float)(image.height - this.template.height)) {
                height += (float)(image.height - this.template.height) - (y + height);
            }
            searchSpace = new Rectangle(x, y, width, height);
        } else {
            searchSpace = new Rectangle(0.0f, 0.0f, image.width - this.template.width + 1, image.height - this.template.height + 1);
        }
        int scanX = (int)searchSpace.x;
        int scanY = (int)searchSpace.y;
        int scanWidth = (int)searchSpace.width;
        int scanHeight = (int)searchSpace.height;
        this.responseMap = new FImage(scanWidth, scanHeight);
        float[][] responseMapData = this.responseMap.pixels;
        for (int y = 0; y < scanHeight; ++y) {
            for (int x = 0; x < scanWidth; ++x) {
                responseMapData[y][x] = this.mode.computeMatchScore(image, this.template, x + scanX, y + scanY, this.workingSpace);
            }
        }
    }

    public FValuePixel[] getBestResponses(int numResponses) {
        Comparator<FValuePixel> comparator = this.mode.scoresAscending() ? FValuePixel.ReverseValueComparator.INSTANCE : FValuePixel.ValueComparator.INSTANCE;
        return TemplateMatcher.getBestResponses(numResponses, this.responseMap, this.getXOffset(), this.getYOffset(), comparator);
    }

    public static FValuePixel[] getBestResponses(int numResponses, FImage responseMap, int offsetX, int offsetY, Comparator<FValuePixel> comparator) {
        BoundedPriorityQueue<FValuePixel> bestResponses = new BoundedPriorityQueue<FValuePixel>(numResponses, comparator);
        float[][] responseMapData = responseMap.pixels;
        int scanWidth = responseMap.width;
        int scanHeight = responseMap.height;
        FValuePixel tmpPixel = new FValuePixel(0, 0, 0.0f);
        for (int y = 0; y < scanHeight; ++y) {
            for (int x = 0; x < scanWidth; ++x) {
                tmpPixel.x = x + offsetX;
                tmpPixel.y = y + offsetY;
                tmpPixel.value = responseMapData[y][x];
                FValuePixel removed = bestResponses.offerItem(tmpPixel);
                tmpPixel = removed == null ? new FValuePixel(0, 0, 0.0f) : removed;
            }
        }
        return bestResponses.toOrderedArray((FValuePixel[])new FValuePixel[numResponses]);
    }

    public int getXOffset() {
        int halfWidth = this.template.width / 2;
        if (this.searchBounds == null) {
            return halfWidth;
        }
        return (int)Math.max(this.searchBounds.x, (float)halfWidth);
    }

    public int getYOffset() {
        int halfHeight = this.template.height / 2;
        if (this.searchBounds == null) {
            return halfHeight;
        }
        return (int)Math.max(this.searchBounds.y, (float)halfHeight);
    }

    public FImage getResponseMap() {
        return this.responseMap;
    }

    public FImage getTemplate() {
        return this.template;
    }

    public static void main(String[] args) throws IOException {
        FImage image = ImageUtilities.readF(new File("/Users/jsh2/Desktop/image.png"));
        FImage template = image.extractROI(100, 100, 100, 100);
        image.fill(0.0f);
        image.drawImage(template, 100, 100);
        TemplateMatcher matcher = new TemplateMatcher(template, Mode.CORRELATION);
        matcher.setSearchBounds(new Rectangle(100.0f, 100.0f, 200.0f, 200.0f));
        image.analyseWith(matcher);
        DisplayUtilities.display(matcher.responseMap.normalise());
        MBFImage cimg = image.toRGB();
        for (FValuePixel p : matcher.getBestResponses(10)) {
            System.out.println(p);
            cimg.drawPoint(p, RGBColour.RED, 1);
        }
        cimg.drawShape(matcher.getSearchBounds(), RGBColour.BLUE);
        cimg.drawShape(new Rectangle(100.0f, 100.0f, 100.0f, 100.0f), RGBColour.GREEN);
        DisplayUtilities.display(cimg);
    }

    public static enum Mode {
        SUM_SQUARED_DIFFERENCE{

            @Override
            protected float computeMatchScore(FImage image, FImage template, int x, int y, Object workingSpace) {
                float[][] imageData = image.pixels;
                float[][] templateData = template.pixels;
                return this.computeMatchScore(imageData, x, y, templateData, 0, 0, template.width, template.height);
            }

            @Override
            public final float computeMatchScore(float[][] img, int x, int y, float[][] template, int templateX, int templateY, int templateWidth, int templateHeight) {
                int stopX1 = templateWidth + x;
                int stopY1 = templateHeight + y;
                int stopX2 = templateWidth + templateX;
                int stopY2 = templateHeight + templateY;
                float score = 0.0f;
                int yy1 = y;
                for (int yy2 = templateY; yy1 < stopY1 && yy2 < stopY2; ++yy1, ++yy2) {
                    int xx1 = x;
                    for (int xx2 = templateX; xx1 < stopX1 && xx2 < stopX2; ++xx1, ++xx2) {
                        float diff = img[yy1][xx1] - template[yy2][xx2];
                        score += diff * diff;
                    }
                }
                return score;
            }

            @Override
            public boolean scoresAscending() {
                return false;
            }
        }
        ,
        NORM_SUM_SQUARED_DIFFERENCE{

            @Override
            protected float computeMatchScore(FImage image, FImage template, int x, int y, Object workingSpace) {
                float score = 0.0f;
                float si = 0.0f;
                float st = ((Float)workingSpace).floatValue();
                float[][] imageData = image.pixels;
                float[][] templateData = template.pixels;
                int stopX = template.width + x;
                int stopY = template.height + y;
                int yy = y;
                int j = 0;
                while (yy < stopY) {
                    int xx = x;
                    int i = 0;
                    while (xx < stopX) {
                        float diff = imageData[yy][xx] - templateData[j][i];
                        score += diff * diff;
                        si += imageData[yy][xx] * imageData[yy][xx];
                        ++xx;
                        ++i;
                    }
                    ++yy;
                    ++j;
                }
                return (float)((double)score / Math.sqrt(si * st));
            }

            @Override
            public final float computeMatchScore(float[][] img, int x, int y, float[][] template, int templateX, int templateY, int templateWidth, int templateHeight) {
                int stopX1 = templateWidth + x;
                int stopY1 = templateHeight + y;
                int stopX2 = templateWidth + templateX;
                int stopY2 = templateHeight + templateY;
                float s1 = 0.0f;
                float s2 = 0.0f;
                float score = 0.0f;
                int yy1 = y;
                for (int yy2 = templateY; yy1 < stopY1 && yy2 < stopY2; ++yy1, ++yy2) {
                    int xx1 = x;
                    for (int xx2 = templateX; xx1 < stopX1 && xx2 < stopX2; ++xx1, ++xx2) {
                        float diff = img[yy1][xx1] - template[yy2][xx2];
                        score += diff * diff;
                        s1 += img[yy1][xx1] * img[yy1][xx1];
                        s2 += template[yy2][xx2] * template[yy2][xx2];
                    }
                }
                return (float)((double)score / Math.sqrt(s1 * s2));
            }

            @Override
            public boolean scoresAscending() {
                return false;
            }

            @Override
            public Float prepareWorkingSpace(FImage template) {
                float sumsq = 0.0f;
                for (int y = 0; y < template.height; ++y) {
                    for (int x = 0; x < template.width; ++x) {
                        sumsq += template.pixels[y][x] * template.pixels[y][x];
                    }
                }
                return new Float(sumsq);
            }
        }
        ,
        CORRELATION{

            @Override
            protected float computeMatchScore(FImage image, FImage template, int x, int y, Object workingSpace) {
                float[][] imageData = image.pixels;
                float[][] templateData = template.pixels;
                return this.computeMatchScore(imageData, x, y, templateData, 0, 0, template.width, template.height);
            }

            @Override
            public float computeMatchScore(float[][] img, int x, int y, float[][] template, int templateX, int templateY, int templateWidth, int templateHeight) {
                float score = 0.0f;
                int stopX1 = templateWidth + x;
                int stopY1 = templateHeight + y;
                int stopX2 = templateWidth + templateX;
                int stopY2 = templateHeight + templateY;
                int yy1 = y;
                for (int yy2 = templateY; yy1 < stopY1 && yy2 < stopY2; ++yy1, ++yy2) {
                    int xx1 = x;
                    for (int xx2 = templateX; xx1 < stopX1 && xx2 < stopX2; ++xx1, ++xx2) {
                        float prod = img[yy1][xx1] * template[yy2][xx2];
                        score += prod;
                    }
                }
                return score;
            }

            @Override
            public boolean scoresAscending() {
                return true;
            }
        }
        ,
        NORM_CORRELATION{

            @Override
            protected float computeMatchScore(FImage image, FImage template, int x, int y, Object workingSpace) {
                float score = 0.0f;
                float si = 0.0f;
                float st = ((Float)workingSpace).floatValue();
                float[][] imageData = image.pixels;
                float[][] templateData = template.pixels;
                int stopX = template.width + x;
                int stopY = template.height + y;
                int yy = y;
                int j = 0;
                while (yy < stopY) {
                    int xx = x;
                    int i = 0;
                    while (xx < stopX) {
                        float prod = imageData[yy][xx] * templateData[j][i];
                        score += prod;
                        si += imageData[yy][xx] * imageData[yy][xx];
                        ++xx;
                        ++i;
                    }
                    ++yy;
                    ++j;
                }
                return (float)((double)score / Math.sqrt(si * st));
            }

            @Override
            public float computeMatchScore(float[][] img, int x, int y, float[][] template, int templateX, int templateY, int templateWidth, int templateHeight) {
                float score = 0.0f;
                float s1 = 0.0f;
                float s2 = 0.0f;
                int stopX1 = templateWidth + x;
                int stopY1 = templateHeight + y;
                int stopX2 = templateWidth + templateX;
                int stopY2 = templateHeight + templateY;
                int yy1 = y;
                for (int yy2 = templateY; yy1 < stopY1 && yy2 < stopY2; ++yy1, ++yy2) {
                    int xx1 = x;
                    for (int xx2 = templateX; xx1 < stopX1 && xx2 < stopX2; ++xx1, ++xx2) {
                        float prod = img[yy1][xx1] * template[yy2][xx2];
                        s1 += img[yy1][xx1] * img[yy1][xx1];
                        s2 += template[yy2][xx2] * template[yy2][xx2];
                        score += prod;
                    }
                }
                return (float)((double)score / Math.sqrt(s1 * s2));
            }

            @Override
            public boolean scoresAscending() {
                return true;
            }

            @Override
            public Float prepareWorkingSpace(FImage template) {
                float sumsq = 0.0f;
                for (int y = 0; y < template.height; ++y) {
                    for (int x = 0; x < template.width; ++x) {
                        sumsq += template.pixels[y][x] * template.pixels[y][x];
                    }
                }
                return new Float(sumsq);
            }
        }
        ,
        CORRELATION_COEFFICIENT{

            @Override
            protected final float computeMatchScore(FImage image, FImage template, int x, int y, Object workingSpace) {
                float[][] imageData = image.pixels;
                float[][] templateData = template.pixels;
                float templateMean = ((Float)workingSpace).floatValue();
                float imgMean = MeanCenter.patchMean(imageData);
                return this.computeMatchScore(imageData, x, y, imgMean, templateData, 0, 0, template.width, template.height, templateMean);
            }

            @Override
            public final float computeMatchScore(float[][] img, int x, int y, float[][] template, int templateX, int templateY, int templateWidth, int templateHeight) {
                float imgMean = MeanCenter.patchMean(img, x, y, templateWidth, templateHeight);
                float templateMean = MeanCenter.patchMean(template, templateX, templateY, templateWidth, templateHeight);
                return this.computeMatchScore(img, x, y, imgMean, template, templateX, templateY, templateWidth, templateHeight, templateMean);
            }

            private final float computeMatchScore(float[][] img, int x, int y, float imgMean, float[][] template, int templateX, int templateY, int templateWidth, int templateHeight, float templateMean) {
                int stopX1 = templateWidth + x;
                int stopY1 = templateHeight + y;
                int stopX2 = templateWidth + templateX;
                int stopY2 = templateHeight + templateY;
                float score = 0.0f;
                int yy1 = y;
                for (int yy2 = templateY; yy1 < stopY1 && yy2 < stopY2; ++yy1, ++yy2) {
                    int xx1 = x;
                    for (int xx2 = templateX; xx1 < stopX1 && xx2 < stopX2; ++xx1, ++xx2) {
                        float prod = (img[yy1][xx1] - imgMean) * (template[yy2][xx2] - templateMean);
                        score += prod;
                    }
                }
                return score;
            }

            @Override
            public boolean scoresAscending() {
                return true;
            }

            @Override
            public Float prepareWorkingSpace(FImage template) {
                return Float.valueOf(MeanCenter.patchMean(template.pixels));
            }
        }
        ,
        NORM_CORRELATION_COEFFICIENT{

            @Override
            protected final float computeMatchScore(FImage image, FImage template, int x, int y, Object workingSpace) {
                int width = template.width;
                int height = template.height;
                float imgMean = MeanCenter.patchMean(image.pixels, x, y, width, height);
                float score = 0.0f;
                float si = 0.0f;
                float st = ((Float)workingSpace).floatValue();
                float[][] imageData = image.pixels;
                float[][] templateData = template.pixels;
                for (int j = 0; j < height; ++j) {
                    for (int i = 0; i < width; ++i) {
                        float ival = imageData[j + y][i + x] - imgMean;
                        float prod = ival * templateData[j][i];
                        score += prod;
                        si += ival * ival;
                    }
                }
                double norm = Math.sqrt(si * st);
                if (norm == 0.0) {
                    return 0.0f;
                }
                return (float)((double)score / norm);
            }

            @Override
            public final float computeMatchScore(float[][] img, int x, int y, float[][] template, int templateX, int templateY, int templateWidth, int templateHeight) {
                float imgMean = MeanCenter.patchMean(img, x, y, templateWidth, templateHeight);
                float templateMean = MeanCenter.patchMean(template, templateX, templateY, templateWidth, templateHeight);
                int stopX1 = templateWidth + x;
                int stopY1 = templateHeight + y;
                int stopX2 = templateWidth + templateX;
                int stopY2 = templateHeight + templateY;
                float score = 0.0f;
                float s1 = 0.0f;
                float s2 = 0.0f;
                int yy1 = y;
                for (int yy2 = templateY; yy1 < stopY1 && yy2 < stopY2; ++yy1, ++yy2) {
                    int xx1 = x;
                    for (int xx2 = templateX; xx1 < stopX1 && xx2 < stopX2; ++xx1, ++xx2) {
                        float ival = img[yy1][xx1] - imgMean;
                        float tval = template[yy2][xx2] - templateMean;
                        float prod = ival * tval;
                        score += prod;
                        s1 += ival * ival;
                        s2 += tval * tval;
                    }
                }
                double norm = Math.sqrt(s1 * s2);
                if (norm == 0.0) {
                    return 0.0f;
                }
                return (float)((double)score / norm);
            }

            @Override
            public boolean scoresAscending() {
                return true;
            }

            @Override
            public FImage prepareTemplate(FImage template) {
                return template.process(new MeanCenter());
            }

            @Override
            public Float prepareWorkingSpace(FImage template) {
                float sumsq = 0.0f;
                for (int y = 0; y < template.height; ++y) {
                    for (int x = 0; x < template.width; ++x) {
                        sumsq += template.pixels[y][x] * template.pixels[y][x];
                    }
                }
                return Float.valueOf(sumsq);
            }
        };


        protected abstract float computeMatchScore(FImage var1, FImage var2, int var3, int var4, Object var5);

        public abstract float computeMatchScore(float[][] var1, int var2, int var3, float[][] var4, int var5, int var6, int var7, int var8);

        public abstract boolean scoresAscending();

        protected FImage prepareTemplate(FImage template) {
            return template;
        }

        protected Object prepareWorkingSpace(FImage template) {
            return null;
        }
    }
}

