/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.algorithm;

import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;

public class VerticalProjection
implements ImageAnalyser<FImage> {
    float[] projection;

    @Override
    public void analyseImage(FImage image) {
        this.projection = VerticalProjection.project(image);
    }

    public static float[] project(FImage image) {
        float[] projection = new float[image.height];
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                int n = y;
                projection[n] = projection[n] + image.pixels[y][x];
            }
        }
        return projection;
    }

    public float[] getProjection() {
        return this.projection;
    }
}

