/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.algorithm.histogram.binning;

import java.util.List;
import org.openimaj.image.analysis.algorithm.histogram.WindowedHistogramExtractor;
import org.openimaj.image.analysis.algorithm.histogram.binning.SpatialBinningStrategy;
import org.openimaj.image.pixel.sampling.QuadtreeSampler;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.statistics.distribution.Histogram;

public class QuadtreeStrategy
implements SpatialBinningStrategy {
    int nlevels;

    public QuadtreeStrategy(int nlevels) {
        this.nlevels = nlevels;
    }

    @Override
    public Histogram extract(WindowedHistogramExtractor binnedData, Rectangle region, Histogram output) {
        QuadtreeSampler sampler = new QuadtreeSampler(region, this.nlevels);
        int blockSize = binnedData.getNumBins();
        List<Rectangle> rects = sampler.allRectangles();
        if (output == null || ((double[])output.values).length != blockSize * rects.size()) {
            output = new Histogram(blockSize * rects.size());
        }
        Histogram tmp = new Histogram(blockSize);
        for (int i = 0; i < rects.size(); ++i) {
            Rectangle r = rects.get(i);
            binnedData.computeHistogram(r, tmp);
            System.arraycopy(tmp.values, 0, output.values, blockSize * i, blockSize);
        }
        return output;
    }
}

