/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.pyramid;

import java.lang.reflect.Array;
import java.util.Iterator;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.processing.convolution.FGaussianConvolve;
import org.openimaj.image.processing.resize.BilinearInterpolation;
import org.openimaj.image.processor.ImageProcessor;
import org.openimaj.image.processor.Processor;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.util.array.ArrayIterator;

public class SimplePyramid<IMAGE extends Image<?, IMAGE>>
implements ImageAnalyser<IMAGE>,
ImageProcessor<IMAGE>,
Iterable<IMAGE> {
    public IMAGE[] pyramid;
    Processor<IMAGE> processor = null;
    float power;
    int nlevels;

    public SimplePyramid(float power) {
        this.power = power;
        this.nlevels = -1;
    }

    public SimplePyramid(float power, int nlevels) {
        this.power = power;
        this.nlevels = nlevels;
    }

    public SimplePyramid(float power, Processor<IMAGE> processor) {
        this.power = power;
        this.nlevels = -1;
        this.processor = processor;
    }

    public SimplePyramid(float power, int nlevels, Processor<IMAGE> processor) {
        this.power = power;
        this.nlevels = nlevels;
        this.processor = processor;
    }

    protected int computeLevels(int size) {
        int levels = 1;
        while ((size = (int)((float)size / this.power)) >= 8) {
            ++levels;
        }
        return levels;
    }

    @Override
    public void analyseImage(IMAGE image) {
        if (this.nlevels <= 0) {
            this.nlevels = this.computeLevels(Math.min(((Image)image).getWidth(), ((Image)image).getHeight()));
        }
        this.pyramid = (Image[])Array.newInstance(image.getClass(), this.nlevels);
        this.pyramid[0] = ((Image)image).clone();
        for (int i = 1; i < this.nlevels; ++i) {
            int m = (int)Math.floor((float)((Image)this.pyramid[i - 1]).getHeight() / this.power);
            int n = (int)Math.floor((float)((Image)this.pyramid[i - 1]).getWidth() / this.power);
            this.pyramid[i] = ((SinglebandImageProcessor.Processable)((Image)this.pyramid[i - 1]).process(this.processor)).process(new BilinearInterpolation(n, m, this.power));
        }
    }

    @Override
    public void processImage(IMAGE image) {
        this.analyseImage(image);
        ((Image)image).internalAssign(this.pyramid[this.nlevels - 1]);
    }

    @Override
    public Iterator<IMAGE> iterator() {
        return new ArrayIterator<IMAGE>(this.pyramid);
    }

    public static <T extends Image<?, T>> SimplePyramid<T> createGaussianPyramid(T image, float sigma, int nLevels) {
        SimplePyramid<FImage> pyr = new SimplePyramid<FImage>(2.0f, nLevels, new FGaussianConvolve(sigma));
        image.analyseWith(pyr);
        return pyr;
    }
}

