/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.pyramid.gaussian;

import org.openimaj.image.Image;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.analysis.pyramid.Pyramid;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianOctave;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianPyramidOptions;
import org.openimaj.image.processing.resize.ResizeProcessor;
import org.openimaj.image.processor.SinglebandImageProcessor;

public class GaussianPyramid<I extends Image<?, I>>
extends Pyramid<GaussianPyramidOptions<I>, GaussianOctave<I>, I>
implements ImageAnalyser<I>,
Iterable<GaussianOctave<I>> {
    public GaussianPyramid(GaussianPyramidOptions<I> options) {
        super(options);
    }

    @Override
    public void process(I img) {
        float currentSigma;
        Object image;
        if (((Image)img).getWidth() <= 1 || ((Image)img).getHeight() <= 1) {
            throw new IllegalArgumentException("Image is too small");
        }
        float octaveSize = 1.0f;
        if (((GaussianPyramidOptions)this.options).doubleInitialImage) {
            image = ResizeProcessor.doubleSize(img);
            octaveSize = (float)((double)octaveSize * 0.5);
        } else {
            image = ((Image)img).clone();
        }
        float f = currentSigma = ((GaussianPyramidOptions)this.options).doubleInitialImage ? 1.0f : 0.5f;
        if (((GaussianPyramidOptions)this.options).initialSigma > currentSigma) {
            float sigma = (float)Math.sqrt(((GaussianPyramidOptions)this.options).initialSigma * ((GaussianPyramidOptions)this.options).initialSigma - currentSigma * currentSigma);
            ((SinglebandImageProcessor.Processable)image).processInplace(((GaussianPyramidOptions)this.options).createGaussianBlur(sigma));
        }
        int minImageSize = 2 + 2 * ((GaussianPyramidOptions)this.options).getBorderPixels();
        while (((Image)image).getHeight() > minImageSize && ((Image)image).getWidth() > minImageSize) {
            GaussianOctave<Object> currentOctave = new GaussianOctave<Object>(this, octaveSize);
            currentOctave.process(image);
            image = ResizeProcessor.halfSize(currentOctave.getNextOctaveImage());
            octaveSize = (float)((double)octaveSize * 2.0);
            if (this.octaves == null) continue;
            this.octaves.add(currentOctave);
        }
        if (((GaussianPyramidOptions)this.options).getPyramidProcessor() != null) {
            ((GaussianPyramidOptions)this.options).getPyramidProcessor().process(this);
        }
    }
}

