/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.watershed;

import java.util.HashSet;
import java.util.Set;
import org.openimaj.image.analysis.watershed.feature.ComponentFeature;
import org.openimaj.image.analysis.watershed.feature.PixelsFeature;
import org.openimaj.image.pixel.IntValuePixel;
import org.openimaj.image.pixel.Pixel;

public class Component
implements Cloneable {
    public boolean isMSER = false;
    public ComponentFeature[] features;
    public IntValuePixel pivot;
    private int size = 0;

    @SafeVarargs
    public Component(IntValuePixel p, Class<? extends ComponentFeature> ... featureClasses) {
        this.pivot = p;
        this.features = new ComponentFeature[featureClasses.length];
        for (int i = 0; i < featureClasses.length; ++i) {
            try {
                this.features[i] = featureClasses[i].newInstance();
                continue;
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public String toString() {
        return "Comp@" + super.hashCode() + "(px:" + this.size + ",gl:" + this.pivot.value + ")";
    }

    public void accumulate(IntValuePixel p) {
        ++this.size;
        for (ComponentFeature f : this.features) {
            f.addSample(p);
        }
    }

    public void merge(Component p) {
        this.size += p.size();
        for (int i = 0; i < this.features.length; ++i) {
            this.features[i].merge(p.features[i]);
        }
    }

    public int size() {
        return this.size;
    }

    public Set<Pixel> getPixels() {
        for (ComponentFeature f : this.features) {
            if (!(f instanceof PixelsFeature)) continue;
            return ((PixelsFeature)f).pixels;
        }
        HashSet<Pixel> pix = new HashSet<Pixel>(1);
        pix.add(this.pivot);
        return pix;
    }

    public Component clone() {
        try {
            Component result = (Component)super.clone();
            result.features = new ComponentFeature[this.features.length];
            for (int i = 0; i < this.features.length; ++i) {
                result.features[i] = this.features[i].clone();
            }
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public ComponentFeature getFeature(int index) {
        if (index >= this.features.length) {
            return null;
        }
        return this.features[index];
    }

    public <T extends ComponentFeature> T getFeature(Class<T> featureClass) {
        for (ComponentFeature f : this.features) {
            if (!f.getClass().isAssignableFrom(featureClass)) continue;
            return (T)f;
        }
        return null;
    }
}

