/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.watershed;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openimaj.image.analysis.watershed.Component;
import org.openimaj.image.analysis.watershed.event.ComponentStackMergeListener;
import org.openimaj.util.tree.TreeNode;
import org.openimaj.util.tree.TreeNodeImpl;

public class MergeTreeBuilder
implements ComponentStackMergeListener {
    Logger logger = Logger.getLogger(MergeTreeBuilder.class);
    private TreeNode<Component> tree = null;
    private Map<Component, TreeNode<Component>> map = new HashMap<Component, TreeNode<Component>>();

    @Override
    public void componentsMerged(Component c1, Component c2) {
        this.logger.debug("Component c1: " + c1);
        this.logger.debug("Component c2: " + c2);
        TreeNode<Component> c1xtn = this.map.get(c1);
        if (c1xtn == null) {
            this.logger.debug("c1 not found");
            c1xtn = new TreeNodeImpl<Component>();
            Component c1x = c1.clone();
            c1xtn.setValue(c1x);
            this.map.put(c1, c1xtn);
        }
        c1xtn.getValue().merge(c2);
        TreeNode<Component> c2xtn = this.map.get(c2);
        if (c2xtn == null) {
            this.logger.debug("c2 not found");
            c2xtn = new TreeNodeImpl<Component>();
            Component c2x = c2.clone();
            c2xtn.setValue(c2x);
            this.map.put(c2, c2xtn);
        }
        c1xtn.addChild(c2xtn);
        this.tree = c1xtn;
    }

    @Override
    public void componentPromoted(Component c1) {
        TreeNode<Component> c1xtn_old = this.map.get(c1);
        Component c1x = c1.clone();
        TreeNodeImpl<Component> c1xtn = new TreeNodeImpl<Component>();
        c1xtn.setValue(c1x);
        this.map.put(c1, c1xtn);
        if (c1xtn_old != null) {
            c1xtn.addChild(c1xtn_old);
        }
    }

    public TreeNode<Component> getTree() {
        return this.tree;
    }
}

