/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.watershed;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.openimaj.image.FImage;
import org.openimaj.image.analysis.watershed.Component;
import org.openimaj.image.analysis.watershed.event.ComponentStackMergeListener;
import org.openimaj.image.analysis.watershed.feature.ComponentFeature;
import org.openimaj.image.pixel.IntValuePixel;

public class WatershedProcessorAlgorithm {
    private IntValuePixel startPixel = null;
    private BitSet accessibleMask = null;
    private IntValuePixel currentPixel = null;
    private ArrayDeque<Component> componentStack = null;
    private BoundaryHeap boundaryHeap = null;
    private int[][] greyscaleImage = null;
    private List<ComponentStackMergeListener> csmListeners = null;
    private Class<? extends ComponentFeature>[] featureClasses;

    @SafeVarargs
    public WatershedProcessorAlgorithm(int[][] greyscaleImage, IntValuePixel startPixel, Class<? extends ComponentFeature> ... featureClasses) {
        this.greyscaleImage = greyscaleImage;
        this.startPixel = startPixel;
        this.csmListeners = new ArrayList<ComponentStackMergeListener>();
        this.featureClasses = featureClasses;
    }

    @SafeVarargs
    public WatershedProcessorAlgorithm(FImage bGreyscaleImage, IntValuePixel startPixel, Class<? extends ComponentFeature> ... featureClasses) {
        this(new int[bGreyscaleImage.getHeight()][bGreyscaleImage.getWidth()], startPixel, featureClasses);
        for (int j = 0; j < bGreyscaleImage.getHeight(); ++j) {
            for (int i = 0; i < bGreyscaleImage.getWidth(); ++i) {
                this.greyscaleImage[j][i] = (int)(bGreyscaleImage.pixels[j][i] * 255.0f);
            }
        }
    }

    public void startPour() {
        this.currentPixel = this.startPixel;
        this.currentPixel.value = this.greyscaleImage[this.startPixel.y][this.startPixel.x];
        this.accessibleMask = new BitSet(this.greyscaleImage.length * this.greyscaleImage[0].length);
        this.componentStack = new ArrayDeque();
        this.boundaryHeap = new BoundaryHeap(256);
        Component dummyComponent = new Component(new IntValuePixel(-1, -1, Integer.MAX_VALUE), this.featureClasses);
        this.componentStack.push(dummyComponent);
        this.processNeighbours();
    }

    private void processNeighbours() {
        Component currentComponent = new Component(this.currentPixel, this.featureClasses);
        this.componentStack.push(currentComponent);
        boolean processNeighbours = true;
        while (true) {
            IntValuePixel[] neighbours;
            boolean toContinue = false;
            for (IntValuePixel neighbour : neighbours = this.getNeighbourPixels_4(this.currentPixel)) {
                if (neighbour == null) break;
                int idx = neighbour.x + neighbour.y * this.greyscaleImage[0].length;
                if (this.accessibleMask.get(idx)) continue;
                this.accessibleMask.set(idx);
                if (neighbour.value >= this.currentPixel.value) {
                    this.boundaryHeap.push(neighbour);
                    continue;
                }
                this.boundaryHeap.push(this.currentPixel);
                this.currentPixel = neighbour;
                currentComponent = new Component(this.currentPixel, this.featureClasses);
                this.componentStack.push(currentComponent);
                toContinue = true;
                break;
            }
            if (toContinue) continue;
            this.componentStack.peek().accumulate(this.currentPixel);
            IntValuePixel p = this.boundaryHeap.pop();
            if (p == null) {
                return;
            }
            if (p.value == this.currentPixel.value) {
                this.currentPixel = p;
                continue;
            }
            this.currentPixel = p;
            this.processComponentStack();
        }
    }

    private void processComponentStack() {
        while (this.currentPixel.value > this.componentStack.peek().pivot.value) {
            Component topOfStack = this.componentStack.pop();
            if (this.currentPixel.value < this.componentStack.peek().pivot.value) {
                topOfStack.pivot = this.currentPixel;
                this.componentStack.push(topOfStack);
                this.fireComponentStackMergeListener(this.componentStack.peek());
                return;
            }
            this.fireComponentStackMergeListener(this.componentStack.peek(), topOfStack);
            this.componentStack.peek().merge(topOfStack);
        }
    }

    private IntValuePixel[] getNeighbourPixels_4(IntValuePixel pixel) {
        IntValuePixel[] p = new IntValuePixel[4];
        int x = pixel.x;
        int y = pixel.y;
        int height = this.greyscaleImage.length;
        int width = this.greyscaleImage[0].length;
        int c = 0;
        if (x < width - 1) {
            p[c++] = new IntValuePixel(x + 1, y, this.greyscaleImage[y][x + 1]);
        }
        if (x > 0) {
            p[c++] = new IntValuePixel(x - 1, y, this.greyscaleImage[y][x - 1]);
        }
        if (y < height - 1) {
            p[c++] = new IntValuePixel(x, y + 1, this.greyscaleImage[y + 1][x]);
        }
        if (y > 0) {
            p[c++] = new IntValuePixel(x, y - 1, this.greyscaleImage[y - 1][x]);
        }
        return p;
    }

    public void addComponentStackMergeListener(ComponentStackMergeListener csml) {
        this.csmListeners.add(csml);
    }

    public void removeComponentStackMergeListener(ComponentStackMergeListener csml) {
        this.csmListeners.remove(csml);
    }

    private void fireComponentStackMergeListener(Component c1, Component c2) {
        for (ComponentStackMergeListener csm : this.csmListeners) {
            csm.componentsMerged(c1, c2);
        }
    }

    private void fireComponentStackMergeListener(Component c1) {
        for (ComponentStackMergeListener csm : this.csmListeners) {
            csm.componentPromoted(c1);
        }
    }

    private String outputArray(Object[] o) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (Object obj : o) {
            if (!first) {
                sb.append(",");
            }
            if (obj == null) {
                sb.append("null");
            } else {
                sb.append(obj.toString());
            }
            first = false;
        }
        sb.append("]");
        return sb.toString();
    }

    private class BoundaryHeap {
        private BitSet availablePixels;
        private ArrayDeque<IntValuePixel>[] stacks;

        public BoundaryHeap(int sz) {
            this.availablePixels = new BitSet(sz);
            this.stacks = new ArrayDeque[sz];
            for (int i = 0; i < sz; ++i) {
                this.stacks[i] = new ArrayDeque();
            }
        }

        public void push(IntValuePixel p) {
            ArrayDeque<IntValuePixel> l = this.stacks[p.value];
            l.push(p);
            this.availablePixels.set(p.value);
        }

        public IntValuePixel pop() {
            int l = this.availablePixels.nextSetBit(0);
            if (l == -1) {
                return null;
            }
            IntValuePixel xx = this.stacks[l].pop();
            if (this.stacks[l].size() == 0) {
                this.availablePixels.set(l, false);
            }
            return xx;
        }
    }
}

