/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.dataset;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.sanselan.ImageReadException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.openimaj.data.dataset.ReadableListDataset;
import org.openimaj.data.identity.Identifiable;
import org.openimaj.image.DisplayUtilities;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.io.HttpUtils;
import org.openimaj.io.InputStreamObjectReader;
import org.openimaj.util.api.auth.DefaultTokenFactory;
import org.openimaj.util.api.auth.common.BingAPIToken;

public class BingImageDataset<IMAGE extends Image<?, IMAGE>>
extends ReadableListDataset<IMAGE, InputStream>
implements Identifiable {
    List<ImageDataSourceResponse> images;
    ImageDataSourceQuery query;

    protected BingImageDataset(InputStreamObjectReader<IMAGE> reader, List<ImageDataSourceResponse> results, ImageDataSourceQuery query) {
        super(reader);
        this.images = results;
        this.query = query;
    }

    @Override
    public IMAGE getInstance(int index) {
        return this.read(this.getImage(index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMAGE read(ImageDataSourceResponse next) {
        Image image;
        if (next == null) {
            return null;
        }
        String imageURL = next.getContentUrl();
        InputStream stream = null;
        try {
            stream = HttpUtils.readURL(new URL(imageURL));
            image = (Image)this.reader.read(stream);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            if (e.getCause() instanceof ImageReadException) {
                System.out.println("The following URL didn't redirect to an image: " + imageURL);
            } else {
                e.printStackTrace();
            }
            IMAGE IMAGE = null;
            return IMAGE;
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return (IMAGE)image;
    }

    @Override
    public int numInstances() {
        return this.images.size();
    }

    public List<ImageDataSourceResponse> getImages() {
        return this.images;
    }

    public ImageDataSourceResponse getImage(int index) {
        return this.images.get(index);
    }

    private static List<ImageDataSourceResponse> performSinglePageQuery(ImageDataSourceQuery query) {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        try {
            URI uri = query.buildURI();
            HttpGet request = new HttpGet(uri);
            request.setHeader("Ocp-Apim-Subscription-Key", query.accountKey);
            HttpResponse response = httpclient.execute(request);
            if (response.getStatusLine().getStatusCode() == 401) {
                throw new IOException("HTTP ERROR 401: Unauthorized Recieved. You probably have the incorrect API Key");
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                try {
                    JSONParser parser = new JSONParser();
                    JSONObject o = (JSONObject)parser.parse(EntityUtils.toString(entity));
                    JSONArray jresults = (JSONArray)o.get("value");
                    ArrayList<ImageDataSourceResponse> results = new ArrayList<ImageDataSourceResponse>(jresults.size());
                    for (Object jro : jresults) {
                        results.add(new ImageDataSourceResponse((JSONObject)jro));
                    }
                    return results;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static List<ImageDataSourceResponse> performQuery(ImageDataSourceQuery query, int number) {
        List<ImageDataSourceResponse> res;
        if (number <= 0) {
            number = 1000;
        }
        query.setOffset(0);
        query.setCount(50);
        ArrayList<ImageDataSourceResponse> images = new ArrayList<ImageDataSourceResponse>();
        for (int i = 0; i < 20 && (res = BingImageDataset.performSinglePageQuery(query)) != null && res.size() != 0; ++i) {
            images.addAll(res);
            if (images.size() >= number) break;
            query.setOffset(query.getOffset() + 50);
        }
        if (images.size() <= number) {
            return images;
        }
        return images.subList(0, number);
    }

    public static <IMAGE extends Image<?, IMAGE>> BingImageDataset<IMAGE> create(InputStreamObjectReader<IMAGE> reader, ImageDataSourceQuery query, int number) {
        return new BingImageDataset<IMAGE>(reader, BingImageDataset.performQuery(query, number), query);
    }

    public static <IMAGE extends Image<?, IMAGE>> BingImageDataset<IMAGE> create(InputStreamObjectReader<IMAGE> reader, BingAPIToken token, ImageDataSourceQuery query, int number) {
        query.setSubscriptionKey(token.accountKey);
        return new BingImageDataset<IMAGE>(reader, BingImageDataset.performQuery(query, number), query);
    }

    public static <IMAGE extends Image<?, IMAGE>> BingImageDataset<IMAGE> create(InputStreamObjectReader<IMAGE> reader, BingAPIToken token, String query, int number) {
        ImageDataSourceQuery aq = new ImageDataSourceQuery();
        aq.setSubscriptionKey(token.accountKey);
        aq.setQuery(query);
        return new BingImageDataset<IMAGE>(reader, BingImageDataset.performQuery(aq, number), aq);
    }

    @Override
    public String getID() {
        return this.query.getQuery();
    }

    public static void main(String[] args) throws BackingStoreException {
        BingAPIToken apiToken = DefaultTokenFactory.get(BingAPIToken.class);
        BingImageDataset<FImage> ds = BingImageDataset.create(ImageUtilities.FIMAGE_READER, apiToken, "foo", 10);
        DisplayUtilities.display((Image)ds.getRandomInstance());
    }

    public static class ImageDataSourceResponse {
        String contentUrl;

        public ImageDataSourceResponse(JSONObject jro) {
            this.contentUrl = (String)jro.get("contentUrl");
        }

        public String getContentUrl() {
            return this.contentUrl;
        }
    }

    public static class ImageDataSourceQuery {
        SafeSearch safeSearch;
        Aspect aspect;
        Color color;
        Freshness freshness;
        int height;
        ImageContent imageContent;
        ImageType imageType;
        License license;
        Size size;
        int width;
        int offset;
        int count;
        String query;
        private String accountKey;

        public SafeSearch getSafeSearch() {
            return this.safeSearch;
        }

        public void setSafeSearch(SafeSearch safeSearch) {
            this.safeSearch = safeSearch;
        }

        public Aspect getAspect() {
            return this.aspect;
        }

        public void setAspect(Aspect aspect) {
            this.aspect = aspect;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public Freshness getFreshness() {
            return this.freshness;
        }

        public void setFreshness(Freshness freshness) {
            this.freshness = freshness;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public ImageContent getImageContent() {
            return this.imageContent;
        }

        public void setImageContent(ImageContent imageContent) {
            this.imageContent = imageContent;
        }

        public ImageType getImageType() {
            return this.imageType;
        }

        public void setImageType(ImageType imageType) {
            this.imageType = imageType;
        }

        public License getLicense() {
            return this.license;
        }

        public void setLicense(License license) {
            this.license = license;
        }

        public Size getSize() {
            return this.size;
        }

        public void setSize(Size size) {
            this.size = size;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public void setSubscriptionKey(String accountKey) {
            this.accountKey = accountKey;
        }

        public URI buildURI() throws URISyntaxException {
            URIBuilder builder = new URIBuilder("https://api.cognitive.microsoft.com/bing/v7.0/images/search");
            builder.setParameter("q", this.query);
            builder.setParameter("count", this.count + "");
            builder.setParameter("offset", this.offset + "");
            return builder.build();
        }

        public static enum Size {
            Small,
            Medium,
            Large,
            Wallpaper,
            All;

        }

        public static enum License {
            Public,
            Share,
            ShareCommercially,
            Modify,
            ModifyCommercially,
            All;

        }

        public static enum ImageType {
            AnimatedGif,
            Clipart,
            Line,
            Photo,
            Shopping;

        }

        public static enum ImageContent {
            Face,
            Portrait;

        }

        public static enum Freshness {
            Day,
            Week,
            Month;

        }

        public static enum Color {
            ColorOnly,
            Monochrome,
            Black,
            Blue,
            Brown,
            Gray,
            Green,
            Orange,
            Pink,
            Purple,
            Red,
            Teal,
            White,
            Yellow;

        }

        public static enum Aspect {
            Square,
            Wide,
            Tall,
            All;

        }

        public static enum SafeSearch {
            Off,
            Moderate,
            Strict;

        }
    }
}

