/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.pixel;

import Jama.Matrix;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.openimaj.math.geometry.point.Point2d;

public class Pixel
implements Point2d,
Cloneable {
    public int x;
    public int y;

    public Pixel(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Pixel() {
        this(0, 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Pixel)) {
            return false;
        }
        return ((Pixel)o).x == this.x && ((Pixel)o).y == this.y;
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this.x;
        hash = 31 * hash + this.y;
        return hash;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public void setX(float x) {
        this.x = Math.round(x);
    }

    @Override
    public void setY(float y) {
        this.y = Math.round(y);
    }

    public Pixel clone() {
        return new Pixel(this.x, this.y);
    }

    @Override
    public void copyFrom(Point2d p) {
        this.setX(p.getX());
        this.setY(p.getY());
    }

    @Override
    public Integer getOrdinate(int dimension) {
        if (dimension == 0) {
            return this.x;
        }
        return this.y;
    }

    @Override
    public int getDimensions() {
        return 2;
    }

    @Override
    public void translate(float x, float y) {
        this.x = Math.round((float)this.x + x);
        this.y = Math.round((float)this.y + y);
    }

    @Override
    public Pixel transform(Matrix transform) {
        if (transform.getRowDimension() == 3) {
            float xt = (float)transform.get(0, 0) * this.getX() + (float)transform.get(0, 1) * this.getY() + (float)transform.get(0, 2);
            float yt = (float)transform.get(1, 0) * this.getX() + (float)transform.get(1, 1) * this.getY() + (float)transform.get(1, 2);
            float zt = (float)transform.get(2, 0) * this.getX() + (float)transform.get(2, 1) * this.getY() + (float)transform.get(2, 2);
            return new Pixel(Math.round(xt /= zt), Math.round(yt /= zt));
        }
        if (transform.getRowDimension() == 2) {
            float xt = (float)transform.get(0, 0) * this.getX() + (float)transform.get(0, 1) * this.getY();
            float yt = (float)transform.get(1, 0) * this.getX() + (float)transform.get(1, 1) * this.getY();
            return new Pixel(Math.round(xt), Math.round(yt));
        }
        throw new IllegalArgumentException("Transform matrix has unexpected size");
    }

    public Pixel transformInplace(Matrix transform) {
        if (transform.getRowDimension() == 3) {
            float xt = (float)transform.get(0, 0) * this.getX() + (float)transform.get(0, 1) * this.getY() + (float)transform.get(0, 2);
            float yt = (float)transform.get(1, 0) * this.getX() + (float)transform.get(1, 1) * this.getY() + (float)transform.get(1, 2);
            float zt = (float)transform.get(2, 0) * this.getX() + (float)transform.get(2, 1) * this.getY() + (float)transform.get(2, 2);
            this.x = Math.round(xt /= zt);
            this.y = Math.round(yt /= zt);
            return this;
        }
        if (transform.getRowDimension() == 2) {
            float xt = (float)transform.get(0, 0) * this.getX() + (float)transform.get(0, 1) * this.getY();
            float yt = (float)transform.get(1, 0) * this.getX() + (float)transform.get(1, 1) * this.getY();
            this.x = Math.round(xt);
            this.y = Math.round(yt);
            return this;
        }
        throw new IllegalArgumentException("Transform matrix has unexpected size");
    }

    @Override
    public Point2d minus(Point2d a) {
        return new Pixel(this.x - (int)a.getX(), this.y - (int)a.getY());
    }

    @Override
    public void readASCII(Scanner in) throws IOException {
        this.x = in.nextInt();
        this.y = in.nextInt();
    }

    @Override
    public String asciiHeader() {
        return "Pixel";
    }

    @Override
    public void readBinary(DataInput in) throws IOException {
        this.x = in.readInt();
        this.y = in.readInt();
    }

    @Override
    public byte[] binaryHeader() {
        return "PX".getBytes();
    }

    @Override
    public void writeASCII(PrintWriter out) throws IOException {
        out.format("%d %d", this.x, this.y);
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        out.writeInt(this.x);
        out.writeInt(this.y);
    }

    @Override
    public void translate(Point2d v) {
        this.translate(v.getX(), v.getY());
    }

    @Override
    public Pixel copy() {
        return this.clone();
    }

    @Override
    public void setOrdinate(int dimension, Number value) {
        if (dimension == 0) {
            this.x = value.intValue();
        }
        if (dimension == 1) {
            this.y = value.intValue();
        }
    }
}

