/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.pixel;

import Jama.Matrix;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Scanner;
import java.util.Set;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.MBFImage;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.io.ReadWriteable;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.shape.Shape;
import org.openimaj.math.matrix.MatrixUtils;

public class PixelSet
implements Cloneable,
ReadWriteable,
Iterable<Pixel> {
    public Set<Pixel> pixels = new HashSet<Pixel>();

    public PixelSet() {
    }

    public PixelSet(int x, int y, int w, int h) {
        for (int j = y; j < h + y; ++j) {
            for (int i = x; i < w + x; ++i) {
                this.pixels.add(new Pixel(i, j));
            }
        }
    }

    public PixelSet(int[][] img) {
        for (int j = 0; j < img.length; ++j) {
            for (int i = 0; i < img[j].length; ++i) {
                if (img[j][i] <= 0) continue;
                this.pixels.add(new Pixel(i, j));
            }
        }
    }

    public PixelSet(FImage mask, float thresh) {
        for (int j = 0; j < mask.height; ++j) {
            for (int i = 0; i < mask.width; ++i) {
                if (!(mask.pixels[j][i] >= thresh)) continue;
                this.pixels.add(new Pixel(i, j));
            }
        }
    }

    public PixelSet(Set<Pixel> pixels) {
        this.pixels.addAll(pixels);
    }

    protected void fromShape(Shape shape) {
        int minx = (int)Math.round(shape.minX());
        int maxx = (int)Math.round(shape.maxX());
        int miny = (int)Math.round(shape.minY());
        int maxy = (int)Math.round(shape.maxY());
        for (int y = miny; y <= maxy; ++y) {
            for (int x = minx; x <= maxx; ++x) {
                Pixel p = new Pixel(x, y);
                if (!shape.isInside(p)) continue;
                this.addPixel(p);
            }
        }
    }

    public void addPixel(int x, int y) {
        this.addPixel(new Pixel(x, y));
    }

    public void addPixel(Pixel p) {
        this.pixels.add(p);
    }

    public Set<Pixel> getPixels() {
        return this.pixels;
    }

    public void merge(ConnectedComponent c) {
        this.pixels.addAll(c.pixels);
    }

    public boolean find(Pixel p) {
        return this.pixels.contains(p);
    }

    public boolean find(int x, int y) {
        return this.find(new Pixel(x, y));
    }

    public int calculateArea() {
        return this.pixels.size();
    }

    public double calculateMoment(int p, int q, double xc, double yc) {
        if (p == 0 && q == 0) {
            return this.calculateArea();
        }
        double mpq = 0.0;
        for (Pixel pix : this.pixels) {
            mpq += Math.pow((double)pix.x - xc, p) * Math.pow((double)pix.y - yc, q);
        }
        return mpq;
    }

    public double calculateMoment(int p, int q) {
        if (p == 0 && q == 0) {
            return this.calculateArea();
        }
        double[] centroid = this.calculateCentroid();
        double mpq = 0.0;
        for (Pixel pix : this.pixels) {
            mpq += Math.pow((double)pix.x - centroid[0], p) * Math.pow((double)pix.y - centroid[1], q);
        }
        return mpq;
    }

    public double calculateMomentNormalised(int p, int q) {
        double gamma = (p + q) / 2 + 1;
        return this.calculateMoment(p, q) / Math.pow(this.pixels.size(), gamma);
    }

    public double calculateDirection() {
        double[] centroid = this.calculateCentroid();
        double u11 = this.calculateMoment(1, 1, centroid[0], centroid[1]);
        double u20 = this.calculateMoment(2, 0, centroid[0], centroid[1]);
        double u02 = this.calculateMoment(0, 2, centroid[0], centroid[1]);
        double theta = 0.5 * Math.atan2(2.0 * u11, u20 - u02);
        return theta;
    }

    public double[] calculateCentroid() {
        double[] centroid = new double[2];
        double m00 = this.calculateMoment(0, 0, 0.0, 0.0);
        centroid[0] = this.calculateMoment(1, 0, 0.0, 0.0) / m00;
        centroid[1] = this.calculateMoment(0, 1, 0.0, 0.0) / m00;
        return centroid;
    }

    public Pixel calculateCentroidPixel() {
        double[] centroid = this.calculateCentroid();
        return new Pixel((int)Math.round(centroid[0]), (int)Math.round(centroid[1]));
    }

    public double[] calculateAverageHeightWidth(double[] centroid) {
        double accumPosH = 0.0;
        double accumNegH = 0.0;
        double accumPosW = 0.0;
        double accumNegW = 0.0;
        int nPosH = 0;
        int nNegH = 0;
        int nPosW = 0;
        int nNegW = 0;
        for (Pixel p : this.pixels) {
            double x = (double)p.getX() - centroid[0];
            double y = (double)p.getY() - centroid[1];
            if (x >= 0.0) {
                accumPosW += x;
                ++nPosW;
            } else {
                accumNegW += x;
                ++nNegW;
            }
            if (y >= 0.0) {
                accumPosH += y;
                ++nPosH;
                continue;
            }
            accumNegH += y;
            ++nNegH;
        }
        double height = 2.0 * (accumPosH / (double)nPosH + Math.abs(accumNegH / (double)nNegH));
        double width = 2.0 * (accumPosW / (double)nPosW + Math.abs(accumNegW / (double)nNegW));
        return new double[]{height, width};
    }

    public double[] calculateAverageHeightWidth() {
        return this.calculateAverageHeightWidth(this.calculateCentroid());
    }

    public double calculateRegularBoundingBoxAspectRatio() {
        Rectangle bb = this.calculateRegularBoundingBox();
        return bb.width / bb.height;
    }

    public Rectangle calculateRegularBoundingBox() {
        int xmin = Integer.MAX_VALUE;
        int xmax = 0;
        int ymin = Integer.MAX_VALUE;
        int ymax = 0;
        for (Pixel p : this.pixels) {
            if (p.x < xmin) {
                xmin = p.x;
            }
            if (p.x > xmax) {
                xmax = p.x;
            }
            if (p.y < ymin) {
                ymin = p.y;
            }
            if (p.y <= ymax) continue;
            ymax = p.y;
        }
        return new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    public void translate(int x, int y) {
        HashSet<Pixel> newPixels = new HashSet<Pixel>();
        for (Pixel p : this.pixels) {
            p.x += x;
            p.y += y;
            newPixels.add(p);
        }
        this.pixels = newPixels;
    }

    public Pixel topLeftMostPixel() {
        int top = Integer.MAX_VALUE;
        Pixel pix = null;
        for (Pixel p : this.pixels) {
            if (p.y >= top) continue;
            top = p.y;
            pix = p;
        }
        for (Pixel p : this.pixels) {
            if (p.y != top || p.x >= pix.x) continue;
            pix = p;
        }
        return pix;
    }

    public Pixel bottomRightMostPixel() {
        int bottom = Integer.MIN_VALUE;
        Pixel pix = null;
        for (Pixel p : this.pixels) {
            if (p.y <= bottom) continue;
            bottom = p.y;
            pix = p;
        }
        for (Pixel p : this.pixels) {
            if (p.y != bottom || p.x <= pix.x) continue;
            pix = p;
        }
        return pix;
    }

    public String toString() {
        return "ConnectedComponent(area=" + this.calculateArea() + ")";
    }

    public MBFImage extractPixels1d(MBFImage input) {
        MBFImage out = new MBFImage(this.pixels.size(), 1, input.numBands());
        int j = 0;
        for (Pixel p : this.pixels) {
            for (int i = 0; i < input.numBands(); ++i) {
                out.setPixel(j, 0, input.getPixel(p.x, p.y));
            }
            ++j;
        }
        return out;
    }

    public FImage extractPixels1d(FImage input) {
        FImage out = new FImage(this.pixels.size(), 1);
        int j = 0;
        for (Pixel p : this.pixels) {
            out.pixels[0][j] = input.pixels[p.y][p.x];
            ++j;
        }
        return out;
    }

    public MBFImage crop(MBFImage input, boolean blackout) {
        Rectangle bb = this.calculateRegularBoundingBox();
        MBFImage output = new MBFImage((int)bb.width, (int)bb.height, input.numBands());
        for (int y = 0; y < (int)bb.height; ++y) {
            for (int x = 0; x < (int)bb.width; ++x) {
                for (int b = 0; b < input.numBands(); ++b) {
                    if (!blackout || this.pixels.contains(new Pixel(x + (int)bb.x, y + (int)bb.y))) {
                        ((FImage)output.getBand(b)).setPixel(x, y, ((FImage)input.getBand(b)).getPixel(x + (int)bb.x, y + (int)bb.y));
                        continue;
                    }
                    ((FImage)output.getBand(b)).setPixel(x, y, Float.valueOf(0.0f));
                }
            }
        }
        return output;
    }

    public MBFImage extractPixels2d(MBFImage input, boolean blackout) {
        return this.crop(input, blackout);
    }

    public FImage calculateBinaryMask(Image<?, ?> input) {
        FImage n = new FImage(input.getWidth(), input.getHeight());
        for (Pixel p : this.pixels) {
            n.pixels[p.y][p.x] = 1.0f;
        }
        return n;
    }

    public String toStringImage() {
        Rectangle bb = this.calculateRegularBoundingBox();
        String s = "";
        int j = (int)bb.y - 1;
        while ((float)j <= bb.y + bb.height + 1.0f) {
            int i = (int)bb.x - 1;
            while ((float)i <= bb.x + bb.width + 1.0f) {
                s = this.pixels.contains(new Pixel(i, j)) ? s + "1" : s + "0";
                ++i;
            }
            s = s + "\n";
            ++j;
        }
        return s;
    }

    public void reposition() {
        Rectangle bb = this.calculateRegularBoundingBox();
        this.translate(-((int)bb.x), -((int)bb.y));
    }

    public FImage toFImage() {
        Rectangle bb = this.calculateRegularBoundingBox();
        FImage img = new FImage((int)(bb.x + bb.width + 1.0f), (int)(bb.y + bb.height + 1.0f));
        for (Pixel p : this.pixels) {
            img.pixels[p.y][p.x] = 1.0f;
        }
        return img;
    }

    public FImage toFImage(int padding) {
        Rectangle bb = this.calculateRegularBoundingBox();
        FImage img = new FImage((int)(bb.x + bb.width + 1.0f + (float)(2 * padding)), (int)(bb.y + bb.height + 1.0f + (float)(2 * padding)));
        for (Pixel p : this.pixels) {
            img.pixels[p.y + padding][p.x + padding] = 1.0f;
        }
        return img;
    }

    public void transform(Matrix transform) {
        Matrix p1 = new Matrix(3, 1);
        for (Pixel p : this.pixels) {
            p1.set(0, 0, p.getX());
            p1.set(1, 0, p.getY());
            p1.set(2, 0, 1.0);
            Matrix p2_est = transform.times(p1);
            p.x = (int)Math.rint(p2_est.get(0, 0));
            p.y = (int)Math.rint(p2_est.get(1, 0));
        }
    }

    public Matrix normMatrix() {
        double u20 = this.calculateMoment(2, 0);
        double u02 = this.calculateMoment(0, 2);
        double u11 = -this.calculateMoment(1, 1);
        Matrix tf = new Matrix(3, 3);
        tf.set(0, 0, u20);
        tf.set(1, 1, u02);
        tf.set(0, 1, u11);
        tf.set(1, 0, u11);
        tf.set(2, 2, 1.0);
        tf = tf.inverse();
        tf = tf.times(1.0 / Math.sqrt(tf.det()));
        tf = MatrixUtils.sqrt(tf);
        tf.set(2, 2, 1.0);
        return tf;
    }

    @Override
    public void readASCII(Scanner in) throws IOException {
        int count = in.nextInt();
        for (int i = 0; i < count; ++i) {
            Pixel p = new Pixel();
            p.readASCII(in);
            this.pixels.add(p);
        }
    }

    @Override
    public void readBinary(DataInput in) throws IOException {
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            Pixel p = new Pixel();
            p.readBinary(in);
            this.pixels.add(p);
        }
    }

    @Override
    public String asciiHeader() {
        return "PixelSet";
    }

    @Override
    public byte[] binaryHeader() {
        return "PS".getBytes();
    }

    @Override
    public void writeASCII(PrintWriter out) throws IOException {
        out.println(this.pixels.size());
        for (Pixel p : this.pixels) {
            p.writeASCII(out);
            out.println();
        }
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        out.writeInt(this.pixels.size());
        for (Pixel p : this.pixels) {
            p.writeBinary(out);
        }
    }

    @Override
    public Iterator<Pixel> iterator() {
        return this.pixels.iterator();
    }
}

